(** Wrapper around Perl [Date::Format] class.
  *
  * Copyright (C) 2003 Merjis Ltd.
  *
  * $Id: pl_Date_Format.ml,v 1.1 2003/11/19 16:28:23 rich Exp $
  *)

open Perl

let _ = eval "use Date::Format qw()"

let language lang =
  call_class_method_void "Date::Format" "language" [sv_of_string lang]

(* This is just provided for your convenience so you can pass the resulting
 * list of SVs directly to the second argument of {!Pl_Date_Format.strftime}.
 *)
let localtime () =
  call_array ~fn:"localtime" []

let time2str ?zone templ time =
  let args =
    [sv_of_string templ; sv_of_float time] @
    match zone with
	None -> []
      | Some zone -> [sv_of_string zone] in
  string_of_sv (call ~fn:"Date::Format::time2str" args)

let strftime ?zone templ time =
  let args =
    (sv_of_string templ :: time) @
    match zone with
	None -> []
      | Some zone -> [sv_of_string zone] in
  string_of_sv (call ~fn:"Date::Format::strftime" args)

let ctime ?zone time =
  let args =
    [sv_of_float time] @
    match zone with
	None -> []
      | Some zone -> [sv_of_string zone] in
  string_of_sv (call ~fn:"Date::Format::ctime" args)

let asctime ?zone time =
  let args =
    [sv_of_float time] @
    match zone with
	None -> []
      | Some zone -> [sv_of_string zone] in
  string_of_sv (call ~fn:"Date::Format::asctime" args)
