(** Wrapper around Perl [HTML::Parser] class.
  *
  * Copyright (C) 2003 Merjis Ltd.
  *
  * $Id: pl_HTML_Parser.ml,v 1.4 2004/11/23 13:40:50 rich Exp $
  *)

open Perl

let _ = eval "use HTML::Parser"

class html_parser sv =

object (self)

  method parse_file filename =
    call_method_void sv "parse_file" [sv_of_string filename]
  method parse content =
    call_method_void sv "parse" [sv_of_string content]
  method eof =
    call_method_void sv "eof" []
  method delete () =
    call_method_void sv "delete" []

end
