/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#include "main.h"

extern void create_rc_file(char *);
extern short mycmp(char *, char *);


void set_vars_from_pftprc(FILE *fp, int *portn, int strnum)
{
   char str[SONAME], *stra=NULL, *stre=NULL;
   char fp_opened=0;
   int tmp=0;

   if (!fp) {
      if ((fp = fopen((*(statstr+strnum))->home, "r")) == NULL) {
         if (!getuid() && !isatty(2)) {
            *portn = INETD_PORT;
            pftpnoroot = 1;
            return;
         }
         else {
            if (isatty(0)) create_rc_file((*(statstr+strnum))->home);
            exit(PFTP_OPEN_RC_ERR);
         }
      }
      fp_opened = 1;
   }

   /*
    * Get variables from resource file.
    */
   for (; fgets(str, SONAME, fp); tmp=0) {
      for (stra=str; *stra && *stra != '\n' && *stra != '#'; stra++);
      *stra = '\0';
      for (stra=str; *stra && (*stra == ' ' || *stra == '\t'); stra++);
      if (!*stra) continue;
      for (stre=stra; *stre && *stre != ' ' && *stre != '\t'; stre++);
      *stre = '\0';
      for (stre++; *stre && (*stre == ' ' || *stre == '\t'); stre++);
      if (!*stre) continue;
      /*
       * Check variables.
       */
      if (!mycmp("PFTPPORT", stra)) {
         if (*portn < 1) *portn = atoi(stre);
      }
      else if (!mycmp("PFTPPERCENT", stra)) {
         (*statstr)->show_percent = atoi(stre)? 1: 0;
      }
      else if (!mycmp("PFTPLOGFILE", stra)) {
         (*statstr)->lognames = atoi(stre)? 1: 0;
      }
      else if (!mycmp("PFTPNOROOT", stra)) {
         pftpnoroot = atoi(stre)? 1: 0;
      }
      else if (!mycmp("PFTPLOG", stra) && !getenv("PFTPLOG")) {
         if (!pftplog && *stre) {
            char *tu=stre;
            for (stre++; *stre && *stre != ' ' && *stre != '\t'; stre++);
            *stre = '\0';
            if (*tu) {
               MEM_CHECK((pftplog = (char *) calloc(SONAME, sizeof(char))));
               strcpy(pftplog, tu);
            }
         } 
      }
      /* The following variables are recognized:
       *    
       *    PFTPCLIENTS
       *    PFTPBANDWID
       *    PFTPSFILTER
       *    PFTPCFILTER
       *    PFTPRECEIVE
       *    PFTPUPLIMIT
       *    PFTPPERCENT
       *    PFTPGIGASTR
       *    PFTPGIGANET
       *    PFTPEDITOR
       *    PFTPNETBUF
       *    PFTPFORCEF
       *    PFTPSFVAR
       *    PFTPCFVAR
       *    PFTPPAGER
       *    PFTPAUSER
       *    PFTPPASS
       *    PFTPSLOG
       */
   }
   if (fp_opened) fclose(fp);
}
