/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include <time.h>
#if defined HAVE_GLIB || defined OSF1
#include <sys/time.h>
#endif
#include "main.h"

#if defined OSF1
extern int usleep(unsigned long);
#endif

char *time_string(void)
{
   time_t secs=1;
   char *str=NULL, *rstr=NULL;

   time(&secs);
   str = asctime(localtime(&secs))+4;
   for (rstr=str; *rstr && *rstr != '\n'; rstr++);
   *rstr = '\0';

   return str;
}


void timing(int strnum, double *sum_bytes, char *str)
{
#ifdef USE_POSIX_THREAD
   double start;
#else
   static double start;
#endif
   double diff=0;
   double rate=0;
   pftp_tv tv;

   /*
    * Read current time.
    */

   if (!(*(statstr+strnum))->first)
   {
   gettimeofday((struct timeval *)&tv, (struct timezone *)NULL);
   diff = (double) tv.tv_sec + ((double) tv.tv_usec / 1000000.0F);
      /*
       * Initialization.
       */
#ifdef USE_POSIX_THREAD
      (*(statstr+strnum))->start = diff;
#else
      start = diff;
#endif
   }
   else if (((*(statstr+strnum))->first & BIT_ONE)) {
      (*(statstr+strnum))->first = BIT_TWO;
      /*
       * Assuming the time it takes for the first datagram
       * sent till it is received is half the time the ACK
       * is sent back and the first datagram is sent.
       */
   gettimeofday((struct timeval *)&tv, (struct timezone *)NULL);
   diff = (double) tv.tv_sec + ((double) tv.tv_usec / 1000000.0F);
#ifdef USE_POSIX_THREAD
      start = (*(statstr+strnum))->start;
#endif
      diff   = (diff - start)/(double)2;
      if ((*statstr)->use_udp) start -= diff;
      else start += diff;
#ifdef USE_POSIX_THREAD
      (*(statstr+strnum))->start = start;
#endif
   }
   else {
      /*
       * Calculate the difference.
       */
      gettimeofday((struct timeval *)&tv, (struct timezone *)NULL);
      diff = (double) tv.tv_sec + ((double) tv.tv_usec / 1000000.0F);
#ifdef USE_POSIX_THREAD
      start = (*(statstr+strnum))->start;
#endif
      diff -= start;
      rate  = *sum_bytes / diff;
      rate /= (double)1024;
      if (slfp) {
#ifdef USE_POSIX_THREAD
         pthread_mutex_lock(&interactiv);
         if (!(*statstr)->_PFTP_DAEMON_ && !(*(statstr+strnum))->_STANDARD_INPUT_) {
            if ((*statstr)->RECEIVING) {
               (*statstr)->RECEIVING = 0;
               putc('\n', slfp);
            }
         }
#endif
         if (slfp != stderr) {
            fprintf(slfp, "%s %s (%ldB %.2fs %.2fKB/s)\n", \
                   time_string(), (*(statstr+strnum))->REMOTEHOSTNAME, \
                   (unsigned long)*sum_bytes, diff, rate);
         }
         else {
#ifdef USE_POSIX_THREAD
            fprintf(slfp, "<%d> Connection to %s (%ldB %.2fs %.2fKB/s) closed.\n\r", \
                   strnum, (*(statstr+strnum))->REMOTEHOSTNAME, (unsigned long)*sum_bytes, diff, rate);
#else
            fprintf(slfp, "<%d> Connection to %s (%ldB %.2fs %.2fKB/s) closed.\n\r", \
                   (int)(*(statstr+strnum))->no_clients, (*(statstr+strnum))->REMOTEHOSTNAME, \
                   (unsigned long)*sum_bytes, diff, rate);
#endif
         }
         fflush(slfp);
#ifdef USE_POSIX_THREAD
         pthread_mutex_unlock(&interactiv);
#endif
      }
      if (*sum_bytes) {
         sprintf(str, "OKAY <*> Sent %.0f bytes in %.2f seconds (%.2fKB/s)", \
                *sum_bytes, diff, rate);
      }
      else {
         if ((*(statstr+strnum))->fad_info) {
            sprintf(str, "OKAY <*> Sent %d message%s containing file and directory information\n", \
                   (*(statstr+strnum))->fad_info, (*(statstr+strnum))->fad_info > 1 ? "s": "");
         }
         else send((*(statstr+strnum))->ws, PFTP_SENDING_ERR, PFTP_SENDING_ERR_LEN, MSG_OOB);
      }
   }
}


void check_bandwidth(size_t sbytes)
{
   static double ct[2] = {0, 0};
   static double bytes[2] = {0, 0};
   static int num=0;
   unsigned long bandwidth = (*statstr)->_BANDWIDTH_;
   double current_time=0;
   double maxsize=0;
   double ttw=0; /* time to wait */
   pftp_tv tv;

   if (!bandwidth) return;
   gettimeofday((struct timeval *)&tv, (struct timezone *)NULL);
   /* in microseconds */
   current_time = ((double) tv.tv_sec * 1000000.0F) + (double) tv.tv_usec;
   if (*(ct+num)) {
      *(bytes+num) += (double)sbytes;
      maxsize = bandwidth * 2;
      /* in microseconds */
      ttw = ((*(bytes+num) / ((double)bandwidth)) * 1000000.0F) - (current_time - *(ct+num));
#ifdef HAVE_USLEEP
      if (ttw > 0.0) usleep((unsigned long)ttw);
#else
      if (ttw > 0.0) {
         tv.tv_sec = (long)(ttw / 1000000.0F);
         tv.tv_usec = ((unsigned long)ttw) % 1000000;
         select(0, NULL, NULL, NULL, (struct timeval *)&tv);
      }
#endif
      if (*(bytes+num) > maxsize) {
         if (*(ct+(!num))) *(bytes+(!num)) += (double)sbytes;
         else {
            gettimeofday((struct timeval *)&tv, (struct timezone *)NULL);
            /* in microseconds */
            current_time = ((double) tv.tv_sec * 1000000.0F) + (double) tv.tv_usec;
            *(ct+(!num)) = current_time;
         }
      }
      if (*(bytes+num) > maxsize * 2) {
         *(bytes+num) = 0;
         *(ct+num) = 0;
         num = !num;
      }
   }
   else {
      *(ct+num) = current_time;
      *(bytes) = (double)0;
      *(bytes+1) = (double)0;
   }
}
