/***************************************************************************
                          mixer.cpp  -  description
                             -------------------
    begin                : Sun Sep 19 1999
    copyright            : (C) 1999 by Edson Pereira
    email                : edson_pereira@harvard.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <linux/soundcard.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <fcntl.h>
#include <stdio.h>

#include "mixer.h"

SoundMixer::SoundMixer(){
}

SoundMixer::~SoundMixer(){
}

/** Sets the output volume */
void SoundMixer::setVolume( int level ){
	setLevel (SOUND_MIXER_VOLUME, level );
}

/** Sets the PCM output level */
void SoundMixer::setPcmLevel( int level ){
	setLevel (SOUND_MIXER_PCM, level );
}

/** Sets the line input level */
void SoundMixer::setLineLevel( int level ){
  setLevel (SOUND_MIXER_LINE, level );
}

/** Sets the appropriate level in the given sound device */
void SoundMixer::setLevel( int device, int level )
{
   int mixer_fd;

   /* Open the Mixer Device */
   if (( mixer_fd = open ("/dev/mixer", O_RDWR)) < 0)
   {
      fprintf (stderr, "Can't open mixer\n");
      perror ("Error: mixer open");
   }

   /* write new values to device */
   if (ioctl (mixer_fd, MIXER_WRITE (device), &level) < 0)
   {
      perror ("Error: mixer write");
      close (mixer_fd);
   }
   close (mixer_fd);
}


