#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

using namespace std;

#include "printoutput.h"

PrintOutput::PrintOutput(ConfigFile *inif,char *section) : ConfigDB(Template), PrinterQueues()
{
	cerr << "In PrintOutput constructor..." << endl;
	new ConfigDBHandler(inif,section,this);
	char *queue=FindString("Queue");
	if(strlen(queue)==0 && GetPrinterCount()>0)
	{
		queue=GetPrinterName(0);
//		char *cmd=GetPrintCommand(queue);
//		SetString("Command",cmd);
//		free(cmd);
		
		if(queue)
		{
			SetString("Queue",queue);
			char *driver=GetPrinterDriver(queue);
			SetString("Driver",driver);
			free(driver);
			free(queue);
		}
		else
			SetString("Driver",DEFAULT_PRINTER_DRIVER);
	}
	cerr << "Done..." << endl;
}


class Consumer_Queue : public Consumer
{
	public:
	Consumer_Queue(struct pqinfo *pq,const char *queuename) : pq(pq)
	{
		pq->SetPrinterQueue(pq,queuename);
		pq->InitialiseJob(pq);
		pq->InitialisePage(pq);
	}
	virtual ~Consumer_Queue()
	{
		pq->EndPage(pq);
		pq->EndJob(pq);
	}
	virtual bool Write(const char *buffer, int length)
	{
		return(pq->WriteData(pq,buffer,length));
	}
	virtual void Cancel()
	{
		pq->CancelJob(pq);
	}
	protected:
	struct pqinfo *pq;
};




Consumer *PrintOutput::GetConsumer()
{
	char *str;
	if(strlen(str=FindString("Queue")))
	{
		Consumer *result=new Consumer_Queue(queues,str);	
		return(result);
	}
	else if(strlen(str=FindString("File")))
	{
		str2=(char *)malloc(strlen(str)+12);
		snprintf(str2,strlen(str)+12,str,FindInt("Serial"));
		SetInt("Serial",FindInt("Serial")+1);
		Consumer *result=new Consumer_File(str2);
		free(str2);
		str2=NULL;
		return(result);
	}
	else if(strlen(str=FindString("Command")))
	{
		return(new Consumer_Pipe(str));
	}
	else
		return(NULL);
}

ConfigTemplate PrintOutput::Template[]=
{
	ConfigTemplate("Driver",""),
	ConfigTemplate("File",""),
	ConfigTemplate("Queue",""),
	ConfigTemplate("Command",""),
	ConfigTemplate("Serial",int(1)),
	ConfigTemplate()
};
