<?php
/**
 * Latin American Spanish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  Ricardo Lago
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @author Ricardo Lago
 * @version $Id: help_text.es.php,v 1.8.2.4 2005/12/07 19:01:59 yalnifj Exp $
 */
if (preg_match("/help_text\...\.php$/", $_SERVER["SCRIPT_NAME"])>0) {
print "Usted no puede acceder a este archivo de idioma directamente.";
exit;
}

//-- GENERAL HELP HEADER
$pgv_lang["tag_start"]				= "<font class=\"helpstart\">";
$pgv_lang["tag_end"]				= "</font>";
$pgv_lang["help_header"]			= "Información adicional sobre:"; //Header text of the popup

//-- Pages Help-messages

//-- Index-page

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~PÁGINA DE ANTEPASADOS.~<br /><br />La página de Antepasados es la primera de este programa.<br /><br />* MÁS AYUDA<br /> A la derecha de algunos enlaces, cajas o botones podrá encontrar un signo de interrogación. Pulsando este signo ?, se abrirá una pequeña ventana con más información<br /><br />* Entrar<br />Puede acceder como usuario registrado desde cualquier página de este programa.<br />Usted accede pulsando el enlace \"Entrar\" en la cabecera de la página.<br />Los visitantes que deseen abrir una cuenta en el sitio también deben de hacer clic en \"Entrar\".<br /><br />*Antepasados<br />La mayoría de los visitantes y usuarios sabrán lo que es un gráfico de Antepasados, pero alguna información mas acerca de nuestros antepasados no vendrá mal:<br />¡Ponga esa información aquí!<br /><br />* Nombres en las cajas de antepasados<br />Más información sobre la persona pulsando sobre su nombre en la caja.<br /><br />* Icono de enlaces dentro de la caja<br />Cuando la opción \"Ver Detalles\" está activada, podrá ver un icono despues del nombre. Dependiendo de la configuración del sitio deberá poner el puntero sobre el icono, o hacer clic sobre él, para acceder a la ventana de enlaces<br /><br />* Lupa para agrandar la caja.<br />También dependiendo de la configuración del sitio tendrá que posar el cursor sobre el icono o hacer clic sobre él.<br /><br />* Las flechas<br />A la derecha e izquierda de la página y a continuación de las cajas de los nombre podrá ver las Flechas.<br /><br />";
$pgv_lang["show_full_help"]			= "~OCULTAR O VER DETALLES~<br /><br />Con esta opción puede escoger entre mostrar todos los detalles de la persona en la caja, u ocultarlos.<br /> Con los detalles ocultos puede mostrar más cajas en la página.<br /><br />Cuando escoja la opción de ocultar detalles, podrá también aumentar la caja haciendo clic en el lugar donde aparecía el icono de la lupa (si está activada por el administrador).";
$pgv_lang["talloffset_help"]			= "~PANTALLA ~<br /><br />Con esta opción determina el tamaño del árbol en la pantalla.<br /> Cambiando este ajuste puede conseguir una pantalla más asequible para imprimir o que se adapte mejor a la resolución de su monitor.";
$pgv_lang["rootid_help"]			= "~NUEVA PERSONA RAÍZ~<br /><br />Si quiere ver el árbol desde una nueva persona, puede escribir aquí su núnero de ID.<br /> Si lo desconoce, seleccione el enlace 'Buscar ID' para encontrarlo.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~NÚMERO DE GENERACIONES~<br /><br />Aquí puede elegir el número de generaciones que mostrará el árbol de antepasados.<br />Lo más idóneo para usted, depende del tamaño de su pantalla y si elige ver detalles o no.";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~LA PÁGINA DE ENTRADA~<br /><br />En esta página puede entrar como usuario registrado, solicitar una nueva contraeña o solicitar una cuenta de usuario.<br /><br />Encontrará más informción pulsando el signo ? entre las cajas o enlaces.";
$pgv_lang["username_help"]			= "~NOMBRE DE USUARIO~<br /><br />En esta caja escriba su nombre de usuario.<br />El nombre de usuario diferencia entre mayúsculas y minúsculas.";
$pgv_lang["password_help"]			= "~CONTRASEÑA~<br /><br />En esta caja escriba su contraseña.<br />La contraseña diferencia entre mayúsculas y minúsculas";
$pgv_lang["login_buttons_help"]			= "~BOTONES DE ENTRADA~<br /><br />Puede ver tres botones para entrar en el sistema.<br />Dependiendo de cúal escoja entrará en una zona diferente.<br /><br />* El botón <b> #pgv_lang[login]# </b><br />Si pulsa este botón del medio, regresará a la página de la que procedía.<br />Así, si pulsó \" #pgv_lang[login]# \" cuando estaba en la página de Antepasados, regresará a la misma.<br /><br />*  El botón <b> #pgv_lang[mygedview]# </b><br />Cuando pulsa este botón a la izquierda, entrará directamente en su página personal, donde puede editar sus preferencias, añadir o editar favoritos, enviar y recibir mensajes, y otros.<br /><br />*  El botón <b> #pgv_lang[admin]# </b><br />Si tiene privilegios de administrador, puede pulsar este botón a la derecha para ir directamente a la página principal de administración.";
$pgv_lang["login_buttons_aut_help"]		= "~MODO AUTENTIFICACIÓN~<br /><br />BOTONES DE ENTRADA<br /><br />Puede ver tres botones para entrar en el sistema.<br />Dependiendo de cúal escoja entrará en una zona diferente.<br /><br />* El botón <b> #pgv_lang[login_aut]# </b><br />Si pulsa este botón del medio, accederá a la página \"EDIT USER\", donde puede editar sus preferencias.<br /><br />* El botón <b> #pgv_lang[mygedview]# </b><br />Cuando pulsa este botón a la izquierda, entrará directamente en su página personal, donde puede editar sus preferencias, añadir o editar favoritos, enviar y recibir mensajes, y otros.<br /><br />* El botón <b> #pgv_lang[admin]# </b><br />Si tiene privilegios de administrador, puede pulsar este botón a la derecha para ir directamente a la página principal de administración.";
$pgv_lang["new_password_help"]			= "~SOLICITAR NUEVA CONTRASEñA~<br /><br />Si perdió su contraseña, puede seleccionar este enlace para solicitar una nueva.";
$pgv_lang["new_user_help"]			= "~SOLICITAR CUENTA DE USUARIO~<br /><br />Si es un visitante de este sitio, y le gustarí solicitar una cuenta de usuario, seleccione este enlace.";

//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~PÁGINA DE DESCENDIENTES~<br /><br />Esta página le mostrará los descendientes de una persona.<br />Puede escoger cualquier persona de esta página para ver su informe de descendientes, o bien enlazar directamente con esta página desde \"Antepasados\" en el menú superior.<br />";
$pgv_lang["desc_rootid_help"]			= "~NUEVA PERSONA RAÍZ~<br /><br />Si quiere ver el informe de descendientes desde una nueva persona, puede escribir aquí su núnero de ID.<br /> Si lo desconoce, seleccione el enlace 'Buscar ID' para encontrarlo.";
$pgv_lang["desc_generations_help"]		= "~NÚMERO DE GENERACIONES~<br /><br />Aquí puede elegir el número de generaciones que mostrará el gráfico de descendientes.<br />Lo más idóneo para usted, depende del tamaño de su pantalla y si elige ver detalles o no.";
//-- show_full is used from pedigree

//-- Time line-page
$pgv_lang["help_timeline.php"]			= "~GRÁFICO DE EDADES~<br /><br />En esta página puede ver una o más personas a lo largo de la línea de tiempo.<br />De esta forma puede visualizar gráficamente el estado de dos o más personas en un determinado momento.<br /><br />Si pulsa el enlace del Gráfico de Edades desde cualquier página ya tendrá una persona o dos en la línea de tiempo.<br />Si pulsa el enlace desde el menú de la cabecera, tendrá que escribir el \"ID\" de al menos una persona para comenzar.";
$pgv_lang["add_person_help"]			= "~AGREGAR PERSONAS AL GRÁFICO~<br /><br />Puede tener muchas personas a lo largo de la línea de tiempo.<br />Utilice esta caja para introducir el ID de la persona.<br />Si lo desconoce, pulse en  \"Buscar ID\".";
$pgv_lang["remove_person_help"]			= "~SUPRIMIR PERSONAS EN EL GRÁFICO~<br /><br />Pulse este enlace para suprimir una persona de la línea de tiempo.";
$pgv_lang["show_age_marker_help"]		= "~VER MARCADOR DE EDAD~<br /><br />Si selecciona esto, verá un marcador de edad, que podrá deslizar a lo largo de la línea de tiempo.<br />Este marcador es una sencilla pero efectiva herramienta para determinar la edad de una persona en un determinado acontecimiento.<br />Puede activar o desactivar el marcador de edad para cada persona del gráfico.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~PÁGINA PARENTESCO~<br /><br />En esta página puede buscar los lazos de parentesco entre dos personas.<br />No necesariamente estas dos personas tienen que estar relaccionadas por línea sanguínea.<br />Cualquier relacción de parentesco será hallada.";
$pgv_lang["relationship_id_help"]		= "~ID de la PERSONA 1 e ID de la PERSONA 2</b>~<br /><br />Si ha accedido desde un enlace de otra página tal que \"Parentesco conmigo\", se encontrará aquí con el camino señalando la relacción entre usted y la persona.<br />Otro modo de operar consiste en introducir los ID de dos personas de las que esté interesado en conocer su parentesco.<br />Si desconoce su ID, puede utilizar el enlace \"Buscar ID\"";
$pgv_lang["next_path_help"]			= "~PRÓXIMO CAMINO~<br /><br />Haciendo clic sobre este botón se mostrará otra ruta que relacciona igualmente a estas dos personas.<br />The previous found path can be displayed again by clicking the link with the path number.";
$pgv_lang["follow_spouse_help"]			= "~BUSCAR PARENTESCO POR MATRIMONIO~<br /><br />Si esta opción está <b>des</b>seleccionada, la relacción de parentesco será chequeada solamente por línea de sangre.<br />Con esta opción seleccionada se buscarán además los lazos familares establecidos a través de matrimonios.";
//-- show_full is used from pedigree

//-- Individuals-page
$pgv_lang["help_indilist.php"]			 = "~PÁGINA de PERSONAS~<br /><br />En esta página puede ver una lista con todos las personas de la base de datos.<br /><br />Se mostrarán por orden alfabético primero los Apellidos seguidos del Nombre.<br />La lista que se obtiene depende de:<br /><b>1.</b>La letra que haya pulsado en el índice alfabético.<br /><b>2.</b> Si pulsó \"Ocultar\" o \"Mostrar\" Listas de Apellidos .<br /><br />Si está como usuario registrado, y tiene los permisos requeridos, puede agregar una persona sin enlazar a la base de datos.<br /><br />Si precisa de más ayuda, pulse el signo ? correspondiente.";
$pgv_lang["alpha_help"]				 = "~ÍNDICE ALFABÉTICO~<br /><br />Su funcionamiento es muy simple:<br />Pulse sobre la letra del alfabeto que corresponda con la inicial de los apellidos de su interés, y obtendrá un listado con todos los apellidos que comienzan por esa letra .<br /><br />A la izquierda de \"A\" puede ver el signo \"<b>(</b>\". Cuando lo pulse,listará a las personas que tengan un apellido desconocido.<br /><br />¿CARACTERES PERDIDOS?<br />Puede suceder que, en su índice alfabético, uno o mas caracteres estén \"desaparecidos\".<br />Bien, no están desaparecidos, lo que sucede es que no hay registros en la base de datos, cuyo apellido comience por esa letra desaparecida.";
$pgv_lang["name_list_help"]			 = "~LISTA DE NOMBRES~<br /><br />Puede escoger entre una lista de personas agrupadas por apellidos o una lista completa de todas las personas.<br />En ambos casos los apellidos comenzarán con la letra del índice que haya pulsado. A menos que seleccionase \"TODAS\"<br /><br />Entonces verá una lista de apellidos o una lista completa dependiendo de la selección inferior.";
$pgv_lang["skip_sublist_help"]			 = "~OCULTAR LISTAS~<br /><br />Por defecto en la configuración del sitio al seleccionar un letra del alfabeto, se listarán todas las personas agrupadas por apellidos. Si pulsa este enlace, se mostrará una lista de todas las personas cuyo apellido comience por la letra del alfabeto seleccionada.";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~PÁGINA de FAMILIAS~<br /><br />En esta página se muestra una lista con todas las familias existentes en  la base de datos.<br /><br />Los apellidos se mostrarán primero ordenados alfabeticamente.<br />La lista obtenida depende de:<br /><b>1.</b> La letra que haya pulsado en el índice alfabético.<br /><b>2.</b> Si pulsó \"Ocultar\" o \"Mostrar\" Listas de Apellidos .<br /><br />Si precisa de más ayuda, pulse el signo ? correspondiente.";
//-- same variable as individuals page

//-- Sourcelist-page
$pgv_lang["help_sourcelist.php"]		= "~PÁGINA de FUENTES~<br /><br />En esta página se muestra un listado de todas las fuentes de la base de datos.<br />A diferencia de Personas y Familias no dispone de un índice alfabético. Pues aunque pueden ser igualmente personas con nombre y apellidos, también lo son bases de datos públicas, institutos, etc.<br />Esto hace difícil encontrar una forma idónea para ordenarlas. Los nombres de fuentes se almacenan en el GEDCOM ordenados alfabéticamente.<br /><br /><b>FUENTES</b><br />Sin fuentes no es posible construir nuestra base de datos. Para toda información almacenada en nuestra base de datos existe una fuente. Y ésta puede ser una persona, instituto, base de datos pública, etc.<br />Una fuente puede enlazar con muchas personas. De otro lado, una persona también puede enlazar con muchas fuentes. Puede tener diferentes fuentes para cada acontecimiento: nacimiento, bautismo, profesión, matrimonio, hijos, etc. etc. ";
$pgv_lang["sourcelist_listbox_help"]		= "~CAJA de LISTA de FUENTES~<br /><br />En esta caja puede ver los nombres de las fuentes tal y como se guardan en el archivo GEDCOM.<br />Los nombres se muestran en orden alfabético.<br /><br />Cuando seleccione un nombre de la lista, irá a la página de la fuente, donde se muestra una lista de personas y familias enlazadas con esa fuente.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~PÁGINA de DETALLES de la FUENTE~<br /><br />En esta página se muestran los detalles de la fuente.<br />Puede ver la información sobre la fuente, y como ésta es guardada en el GEDCOM.<br /><br />Además una lista de personas y familias que enlazan con esta fuente.<br /><br />Si el administrador del sitio los tiene activados, encontrará uno o más iconos en esta página:<br />Ver GEDCOM<br />Añadir al carrito.<br /><br />Hay más ayuda disponible en la página pulsando en el signo <b>?</b>";
$pgv_lang["sources_listbox_help"]		= "~REGISTROS que ENLAZAN a esta FUENTE~<br /><br />En esta caja puede ver los nombres de las personas y las familias que enlazan con esta fuente.<br />Los nombres se muestran por orden afabético.<br /><br />Cuando seleccione un nombre de la lista, le llevará a la página de la persona o de la familia.";
$pgv_lang["show_source_gedcom_help"]		= "~VER REGISTRO GEDCOM~<br /><br />Pulsando este enlace, se abrirá una peueña ventana mostrando la información sobre la fuente tal como fue guardada en el archivo GEDCOM.";
$pgv_lang["add_source_clip_help"]		= "~AÑADIR FUENTE AL CARRITO~<br /><br />Pulsando este enlace puede añadir una fuente al carrito genealógico, para su posterior descarga.";
$pgv_lang["delete_source_help"]			= "~BORRAR FUENTE DEL GEDCOM~<br /><br />Pulsando este enlace marcará esta fuente para su eliminación del GEDCOM.<br />¿Cómo lo hace?<br />Supongamos que tiene una buena razón para eliminar esta fuente del GEDCOM. Haga clic en el enlace, luego se le abrirá una ventana preguntándole si está seguro o quiere cancelar.<br /><br />Si continua eliminará la fuente, puede pasar un poco de tiempo hasta que una nueva ventana aparece diciéndole que la fuente ha sido borrada.<br /><br />Si continua navegando por el sitio, se percatará que la fuente todaví es visible, y puede ser utilizada, tal como estaba antes de su operación.<br /><br />Esto <b>no</b> es un error.<br />El administrador del sitio recibirá un mensaje advirtiéndole del cambio en el GEDCOM, y que quiere eliminar la fuente.<br />El administrador tiene que aceptar (o rechazar) su cambio. Una vez aceptado por el administrador el proceso es irreversible.<br />En caso de duda el administrador contactará con usted.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~JERARQUÍA DE LUGARES~<br />(o Personas por Lugar)<br /><br />En esta pantalla puede ver que personas o familias están conectadas con un lugar.<br /><br />Si hay cualquier conexión entre una persona o familia y un evento en determinado lugar, el programa la encontrará por usted.<br /><br />Los resultados se muestran en un lista doble:<br />Una para personas y otra para familias.<br /><br />Si precisa de más ayuda, pulse el signo ? correspondiente.";
$pgv_lang["ppp_default_form_help"]		= "~ORDEN DE LOS LUGARES~<br /><br /><b>ORDEN POR DEFECTO</b><br />Los lugares están en un orden por defecto.<br />Esto es así, por no haberse encontrado un orden específico de lugares en el archivo GEDCOM.<br />Por lo tanto el orden es el configurado por defecto para el sitio.<br /><br />Si existiese otro orden en el archivo GEDCOM utilizado, éste se mostraría entre los signos (...) al final de la línea.";
$pgv_lang["ppp_match_one_help"]			= "~ORDEN DE LOS LUGARES~<br /><br />ORDEN DEL GEDCOM<br />La disposición de los lugares es la que se ha encontrado en el archivo GEDCOM.<br />?ta tiene prioridad sobre el orden por defecto del sitio, que se utiliza cuando no se encuentra uno específico en el GEDCOM";
$pgv_lang["ppp_numfound_help"]			= "~BUSCAR CONEXIONES CON LOS LUGARES~<br /><br />Aquí se muestran el nú de resultados que coinciden con la búqueda.<br />Puede hacer clic para ver los resulatdos, o redefinir la búsqueda, escogiendo el siguiente lugar de la lista inferior.";
$pgv_lang["ppp_levels_help"]			= "~NIVELES EN LA DISPOSICIÓN~<br /><br />Está viendo los niveles de que dispone este sitio.<br />La lista inferior muestra los lugares, y es una sublista del nivel superior izquierdo.<br /><br />EJEMPLO:<br />El orden por defecto es: #pgv_lang[default_form]#<br />Si el nivel actual es \"Nivel Principal\", se listarán todos los países que existen en el GEDCOM.<br />Si el nivel actual muestra: \"A Coruña, Nivel Principal\" , Luego en la lista se mostrarán los ayuntamientos de esa provincia<br />etc.<br /><br />Puede elegir un nivel, volver atrás uno o más pasos.";
$pgv_lang["ppp_placelist_help"]			= "~LISTADO DE LUGARES~<br /><br />En esta lista puede ver los lugares que existen en el GEDCOM<br />Los nombres de esta lista son seleccionables.<br />Al pulsar un lugar, funciona como un filtro, y le mostrará el nivel inferior del lugar seleccionado.<br />Cuando alcance el último nivel, al pulsar sobre un nombre de lugar, obtendrá la lista de personas y familias relaccionadas con el mismo.<br /><br />El Texto-Ayuda tambié cambiará cuando seleccione el signo <b>?</b> bajo la Lista de Nombres.<br />(No olvide cerrar primero esta ventana)";
$pgv_lang["ppp_name_list_help"]			= "~LISTA DE NOMBRES~<br /><br />Muestra una lista completa con los nombres de las personas y/o familias que están relaccionadas de algún modo con el lugar.<br /><br />Los nombres de la lista son seleccionables.<br />Cuando pulse en un nombre, accederá a la página de la persona o familia.<br /><br />Puede tambié escojer cambiar su selección, pulsando en otro lugar al comienzo de la lista.<br />En ese caso la lista cambiará a una Lista de Lugares de nuevo.";

//-- Mulitmedia-page
$pgv_lang["help_medialist.php"]			= "~MULTIMEDIA~<br />No hay ayuda disponible en este momento.";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~ANIVERSARIOS~<br />El calendarios de aniversarios que puede verse en esta página no es uno al uso.<br />Tiene algunas funciones poderosas.<br />Bajo el \"Seleccionador de Fechas\", el modo \"Ver\", y los botones \"Ver Día\" y \"Ver Mes\" se encuentra un avanzado sistema de filtro que le seleccionará los eventos correctamente.<br /><br />La función de Aniversarios muestra a las personas y familias relaccionadas con un evento en un día o en un mes determinado, dependiendo del botón Ver seleccionado.<br /><br />También dependerá de la selección que haya hecho en el modo \"Ver\".<br /><br />Los nombres que aparecen en la lista o en el calendario son seleccionables.<br />Pulsando sobre un nombre accederá a la página de la persona o familia.<br /><br />Encontrará ayuda más específica pulsando en el signo <b>?</b> que se encuentra entre las cajas.";
$pgv_lang["annivers_date_select_help"]		= "~Seleccionador de Fechas~<br />El seleccionador de fechas consiste en dos menús desplegables, uno para el día y otro para el mes, y una caja donde debe especificar el año.<br /><br />Cuando accede a la página, le muestra los aniversarios de todas las personas para el día actual (\"Ver Día\" por defecto) . <br />Si pulsa <b>Ver Mes</b>, le mostrará a todas las personas con un evento acontecido en ese mes en el pasado. Dependiendo también de la selección del menú <b>Ver</b>.<br /><br /><b>EJEMPLO</b><br />Supongamos que tiene un pariente nacido el 25 de Enero de 1875.<br />Ajuste el selector de fecha a esa determinada.<br />Cuando pulse en alguno de los botones \"Ver\", verá una lista  o un calendario para esa fecha.<br />Todas las edades, aniversarios, etc, son recalculadas hacia atrás desde la fecha que haya fijado en el seleccionador de fechas.<br />De esta forma, estará viendo la lista o el calendario de la misma manera que lo habrían visto sus antepasados hace años.";
$pgv_lang["annivers_show_help"]			= "~¿QUÉ PUEDO VER?~<br />Cuando no está como usuario registrado puede escojer sólo entre dos opciones:<br /><br /><b>1. Todas las personas</b><br />Con esta opción, se muestran todas las personas y familias.<br /><br /><b>2. Eventos recientes (<100 años)</b><br />Con esta opción verá todos los eventos, del día o/y mes escojido, pero no se mostrarán los eventos de más de cien años.<br /><br />Hay una tercera opción, pero debe de estar como usuario registrado para acceder a la misma, a menos que el administrador tenga configurado el sistema para que todo el mundo pueda acceder a la información de las personas vivas.<br /><br /><b>3. Personas vivas</b><br />Con esta opción sólo serán mostradas las personas vivas. ";
$pgv_lang["day_month_help"]			= "~VER DÍA / VER MES~<br />Seleccionando el botón <b>Ver día</b>, solamente se mostrarán los eventos acontecidos ese día.<br /><br />Pulsando <b>Ver Mes</b>, se mostrará un calendario de eventos de todo el mes.";

//-- Clipping Cart-page
$pgv_lang["help_clippings.php"]			="~CARRITO GENEALÓGICO~<br />Permite ir tomando distintos fragmentos del árbol genealógico e irlos añadiendo en un único archivo GEDCOM para su posterior descarga.<br /><br />* ¿Cómo hacerlo?<br />Es muy simple. Siempre que vea un nombre seleccionable (persona, familia o fuente) podrá acceder a la página de ese nombre. Una vez allí encontrará la opción \"Añadir al Carrito\".<br />Pulsando en ese enlace accederá a una página donde se le ofrecen diversas opciones para descargar.<br /><br />* ¿Cómo descargar?<br />Una vez tiene los registros en el carrito, ya puede descargarlos pulsando el enlace \"Descargar\".<br />Luego siga las instrucciones y enlaces.";
$pgv_lang["clip_download_help"]			="~DESCARGAR AHORA~<br /><br />Pulsando este enlace será enviado a la página siguiente.<br />Si hay más opciones para descargar, le serán mostradas aquí.<br />Siga las instrucciones.";
$pgv_lang["empty_cart_help"]			="~VACIANDO EL CARRITO~<br /><br />Pulsando este enlace su carrito se vaciará completamente.<br /><br />Si no quiere eliminar todas las personas, familias, etc. del carrito, puede ir eliminando una a una pulsando en el enlace \"Vaciar\" individual. ";

//-- GEDCOM Edit Utillity
$pgv_lang["show_changes_help"]			="~VER CAMBIOS DEL GEDCOM~<br /><br />Cuando le aparezca este mensaje, suceden dos cosas:<br /><br />1. Alguien ha hecho cambios en el GEDCOM<br />Pueden haber sido añadidos, borrados o modificados registros.<br /><br />2. Las modificaciones no han sido todaví aprobadas por el administrador.<br />Una vez que las modificaciones hayan sido rechazadas o aprobadas, este mensaje no volverá a aparecer mas.<br /><br /><br />Seleccionando el enlace puede ver las modificacione que se hayan producido.<br />Si advierte que alguna nos es correcta, por favor notíqueselo al administrador.";

//-- Search-page
$pgv_lang["help_search.php"]			="~PÁGINA DE BÚSQUEDA~<br /><br />Aunque simple en apariencia, con los dos médos de búsqueda tenemos un poderoso motor de búsquedas.<br /><br />En la mayoría de los sitios de genealogía permiten buscar por un apellido.<br />En este sitio puede prácticamente buscar por todo.<br /><br />La caja de búsqueda de la izquierda es la misma que la de la cabecera.<br /><br />Si esta buscando por personas de un año determinado, introduzca ese año. El programa le encontrará todas las conexiones.<br /><br />¿Buscando un nombre o un lugar?<br />Teclee el nombre o el lugar, completo o una parte, y el programa hará el resto.<br /><br />Méto de búsqueda por SOUNDEX.<br />En la caja de la derecha, puede buscar por nombres, incluso si no sabe como escribir el nombre.<br /><br />Encontrará más ayuda sobre esto pulsando el signo <b>?</b> sobre las cajas.";
$pgv_lang["search_enter_terms_help"]		="~ESCRIBA UNA PALABRA~<br /><br />Introduzca una palabra para la búsqueda de fechas, nombres, apellidos, lugares, multimedia, etc.<br /><br /><b>Comodines</b><br />Los comodines, en la forma que probablemente conozca (como * o ?),no están permitidos, pero el programa los suple sin necesidad de escribirlos.<br />¿Cómo hace ésto?<br />Supongamos que teclea en la caja de búsqueda lo siguiente: \"<b>Rosa</b>\"<br />El resultado será (siempre suponiendo que estos nombres se encuentren en la base de datos):<br /><b>Rosa</b> Aguíño Otero<br /><b>Rosa</b>lía Fariña Montero<br />También O<b>rosa</b> lugar de Aranga, María <b>Rosa</b>do Vázquez, etc., etc.<br /><br /><b>Fechas</b><br />Introduciendo un año en la caja de búsqueda, obtendrá los nombres de todas las personas que tengan algún evento relaccionado con ese año.<br />Si teclea 1950, el resultado serán las personas, nacidas en 1950, o fallecidas, o que contrajeron matrimonio, o....cualquier otro evento relaccionado con el año 1950.<br /><br />Si teclea \"4 dic\", serán listadas todas las personas que tenga un evento relaccionado con ese día y mes.<br />Pero también con los dís 14 y 24 de diciembre.<br />Como puede ver, los comodines también son asumidos sin necesidad de teclearlos.<br /><br /><b>Fechas correctas</b><br />El programa busca sobre las fechas como éstas hallan sido guardadas en el archivo GEDCOM.<br />Si desea localizar un evento del 14 de Diciembre, debería teclear:<br /><b>14 dec</b><br />porque ésta es la manera como guarda en el archivo GEDCOM.<br />Si introduce \"<b>dec 14</b>\", entonces el resultado será una persona relaccionada con un evento con fecha 08 <b>dec</b>ember 18<b>14</b>.<br /><br />Si necesita más ayuda con el sistema de búsqueda, por favor háganoslo saber y así también podremos completar mejor esta ayuda.";
$pgv_lang["soundex_search_help"]		="~BÚSQUEDA POR SOUNDEX~<br /><br />Poder buscar por el soundex de un nombre es muy importante.<br />Primero una breve explicaión de lo que Soundex significa:<br /><br />Soundex agrupa los apellidos que se pronuncian de modo similar pero que se escriben de forma diferente. Un código soundex empieza por la primera letra del apellido seguida por un código de tres dígitos que representan a las tres primeras consonantes siguientes. Para los nombres que no tienen susficientes letras se le añaden ceros al código hasta completarlo.<br /><br />En idioma inglés:<br />Si está buscando por \"Smith\", puede obtener como resultado:<br />Smith - Smid - Smit - Schmidt, Smyth, Smithe, Smithee, Schmitt, Smead,  Sneed, Smoote etc.<br /><br />No tiene que preocuparse por el código Soundex.<br />Teclee el nombre por el que está buscando y el programa hará el trabajo.<br /><br />El sistema Soundex es muy útil: a veces conocemos un nombre pero no sabemos como se escribe.<br />También puede suceder que se produzca un error al teclear el nombre en la base de datos.<br />Utilizando el sistema Soundex, podremos encontrar el nombre sin dificultad.<br /><br />Pruébelo, trate de localizar un apellido que conozca de antemano, pero escríbalo de forma diferente.<br /><br />En el formulario de búsqueda Soundex, un apellido es suficiente para empezar a buscar.<br />Pero si quiere buscar por nombre debe de introducir también un apellido.";

//-- Upgrade utility
$pgv_lang["how_upgrade_help"]			= "~Herramienta de actualización~<br /><br />La herramienta de actualización será la encargada de actualizar su actual versión del PhpGedView a una nueva que haya descargado.<br /><br />Descargando una nueva versión<br />Una nueva versión puede descargarla directamente desde la dirección http://sourceforge.net/projects/phpgedview/ o puede chequear con la herramienta de actualización por una nueva versión. Si existe una nueva versión mostrará las descargas disponibles. Puede elegir entre archivos comprimidos en formato zip o gz.<br /><br />¿Qué actualizar?<br />* PhpGedView<br />Esto actualiza todos los archivos del PhpGedView excepto el config.php, el privacy.php y el authenticate.php. También actualiza la carpeta de imágenes.<br />* Archivos index<br />Esto actualiza la carpeta /index. Utilízelo con precaución, los archivos existentes serán sobreescritos.<br />* Idiomas<br />Esto actualiza la carpeta /languages.<br />* Temas<br />Esto actualiza la carpeta /themes. Utilícelo con precaución, sus adaptaciones y cambios sobre los temas serán sobreescritos.* Archivo de Configuración<br />Esto compara su archivo de configuración con el nuevo archivo de configuración encontrado y actualiza su archivo con los cambios encontrados en el nuevo. Asegúrese de tener el último archivo con su confiuración específica.<br />* Archido de Privacidad<br />Esto compara sus actuales archivos de privacidad con los nuevos encontrados y los actualiza con los nuevos cambios. Asegúrese de tener el último archivo con sus ajustes de privacidad específicos.<br />* Manuales<br />Esto actualiza la carpeta /doc.<br />* Panel de Investigación<br />Esto actualiza el plugin Panel de Investigación.<br />* Crear backup<br />Esto creará una copia backup de su actual archivo en la carpeta /backup.<br />¿Cómo actualizar?<br />1. Seleccione las partes que quiere actualizar.<br />2. Haga clic en Guardar<br /><br />La marcha de la actualización podrá seguirse al pie de la página.";

?>
