<?php
// control attribute plugin for
// locals (which domains should be treated as locals)
//
// $Id: attrib.control.locals.inc,v 2.35.2.2 2005/04/17 10:08:51 turbo Exp $

// {{{ locals_check(type)
function locals_check($type) {
    global $LANG;

    // check validity
    if(is_array($_REQUEST["locals"])) {
		foreach($_REQUEST["locals"] as $key => $host) {
			if($host == "")
			  continue;
			
			if(!pql_check_hostaddress($host)) {
				$error[pql_get_define("PQL_ATTR_LOCALS")."_".$key] = $LANG->_('Invalid');
				$is_error = true;
			}
			
		} // end foreach
    } // end if is_array
	
    if($is_error)
	  return false;
    
    return true;
}

// }}}

// {{{ locals_init(host)
// init values
function locals_init($host) {
    global $_pql_control;
    
    // fetch data from ldap server
    $_REQUEST["locals"] = pql_get_attribute($_pql_control->ldap_linkid,
											pql_get_define("PQL_ATTR_CN")."=$host,".$_SESSION["USER_SEARCH_DN_CTR"],
											pql_get_define("PQL_ATTR_LOCALS"));
    
    if(is_null($_REQUEST["locals"]))
	  return true;
}
// }}}


// {{{ locals_print_view(host)
function locals_print_view($host) {
    global $_pql_control, $LANG;
    
    // init data
    locals_init($host);
?>
  <table cellspacing="0" cellpadding="3" border="0">
    <th align="left"><?=pql_get_define("PQL_ATTR_LOCALS")?> (Defined <?php echo pql_get_define("PQL_ATTR_LOCALS");?>) for host <u><?=$host?></u></th>
      <tr class="title"><td><?=$LANG->_('Domain')?></td></tr>
<?php
    if(!is_array($_REQUEST["locals"])) {
?>
      <tr class="<?php pql_format_table(); ?>"><td><?=$LANG->_('Not set')?></td></tr>
<?php
    } else {
		asort($_REQUEST["locals"]);
		foreach($_REQUEST["locals"] as $localdomain) {
?>
      <tr class="<?php pql_format_table(); ?>"><td><?=pql_maybe_idna_decode($localdomain)?></td></tr>
<?php
        } // end foreach
    } // end if is_array

    if(pql_get_define("PQL_CONF_CONTROL_AUTOADDLOCALS", $_REQUEST["branch"])) {
?>
      <tr class="subtitle">
        <td><a href="control_edit_attribute.php?rootdn=<?=$_REQUEST["rootdn"]?>&attrib=<?=pql_get_define("PQL_ATTR_LOCALS")?>&type=replicate&mxhost=<?=$host?>&submit=1"><img src="images/edit.png" width="12" height="12" border="0" alt="replicate"><?=$LANG->_('Click here to start replication manually')?></a></td>
      </tr>

      <br>

      <tr class="subtitle">
        <td>
          <table cellspacing="0" cellpadding="3" border="0">
            <tr>
              <td><img src="images/info.png" width="16" height="16" border="0"></td>
              <td>These values will be automatically generated by phpQLAdmin, and cannot be edited.<br>If you want to do it by yourself eg. to control more than one QmailLDAP server,<br>disable '<i>Automatically replicate domains to locals</i>' in the config file.</td>
            </tr>
          </table>
        </td>
      </tr>
  <?php
    } else {
  ?>
      <tr class="subtitle">
        <td><a href="control_edit_attribute.php?rootdn=<?=$_REQUEST["rootdn"]?>&attrib=<?=pql_get_define("PQL_ATTR_LOCALS")?>&mxhost=<?=$host?>&view=hosts"><img src="images/edit.png" width="12" height="12" border="0"><?=$LANG->_('Change options')?></a> (<?=$LANG->_('The automatic replication with domain is disabled')?>)</td>
      </tr>
    </th>
<?php }	?>
  </table>
<?php
}
// }}}

// {{{ locals_print_form(void)
function locals_print_form() {
	global $LANG;
    
    // if automatic replication is enabled, don't display form
// BUG?
//    if(pql_get_define("PQL_CONF_CONTROL_AUTOADDLOCALS", $_REQUEST["rootdn"])) {
//		return false;
//    }
?>
  <form action="<?=$_SERVER["PHP_SELF"]?>" method="post">
    <table cellspacing="0" cellpadding="3" border="0">
      <th colspan="3" align="left"><?php echo pql_complete_constant($LANG->_('Add %what%'), array('what' => $LANG->_('domain'))); ?></th>
        <tr class="<?php pql_format_table(); ?>">
          <td><input type="text" name="set" size="30"></td>
        </tr>
      </th>
    </table>

    <input type="hidden" name="submit" value="1">
    <input type="hidden" name="attrib" value="<?=$_REQUEST["attrib"]?>">
    <input type="hidden" name="mxhost" value="<?=$_REQUEST["mxhost"]?>">
    <input type="hidden" name="rootdn" value="<?=$_REQUEST["rootdn"]?>">
    <input type="hidden" name="view"   value="<?=$_REQUEST["view"]?>">
    <input type="hidden" name="type"   value="<?=$_REQUEST["type"]?>">
    <br>
    <input type="submit" value="<?=$LANG->_('Save')?>">
  </form>
<?php
}
// }}}

// {{{ locals_save(type, host)
function locals_save($type, $host) {
    global $_pql, $_pql_control, $LANG;
	$success = 0;

	if(!$host) {
		// {{{ Get all QmailLDAP/Control hosts.
		$result = pql_get_dn($_pql_control->ldap_linkid, $_SESSION["USER_SEARCH_DN_CTR"],
							 '(&(cn=*)(objectclass=qmailControl))', 'ONELEVEL');
		for($i=0; $result[$i]; $i++)
		  $hosts[] = pql_get_attribute($_pql_control->ldap_linkid, $result[$i], pql_get_define("PQL_ATTR_CN"));

		if(is_array($hosts)) {
			if($type == 'add')
			  $modify_host = 1; // Add domain to host
			else
			  $modify_host = 0; // Don't remove the domain from the host

			foreach($hosts as $host) {
				// Get locals in each of the hosts
				$locals = pql_get_attribute($_pql_control->ldap_linkid,
											pql_get_define("PQL_ATTR_CN")."=$host,".$_SESSION["USER_SEARCH_DN_CTR"],
											pql_get_define("PQL_ATTR_LOCALS"));
				if(is_array($locals)) {
					foreach($locals as $local) {
						// In the 'locals' configured for the host, do we have what we're looking for?
						if($local == $_REQUEST["set"])
						  if($type == 'add')
							$modify_host = 0; // The domain exists, don't add
						  else
							$modify_host = 1; // The domain exists, remove it
					}
				}

				if($modify_host)
				  $HOSTS[] = $host;
			}
		}
		// }}}
	} else
	  $HOSTS[] = $host;

	if($HOSTS[1])
	  // We have more than one host
	  $all = ' all';

    switch($type) {
	  // {{{ Start replication manually
      case "replicate":
		if(pql_control_update_domains($_pql_control, $_REQUEST["rootdn"],
									  pql_get_define("PQL_ATTR_CN")."=$host,".$_SESSION["USER_SEARCH_DN_CTR"],
									  $host, '', pql_get_define("PQL_ATTR_LOCALS")))
		  $msg = pql_complete_constant($LANG->_('Successfully replicated %what%'),
									   array('what' => pql_get_define("PQL_ATTR_LOCALS")));
		else
		  $msg = pql_complete_constant($LANG->_('Failed to replicate %what%'),
									   array('what' => pql_get_define("PQL_ATTR_LOCALS"))).": ".pql_format_error(0);
	
		attribute_forward($msg);
		break;
		// }}}

	  // {{{ Delete entry
      case "del":
		foreach($HOSTS as $host) {
			// remove specified domain from locals in host object
			if(pql_modify_attribute($_pql_control->ldap_linkid,
									pql_get_define("PQL_ATTR_CN")."=$host,".$_SESSION["USER_SEARCH_DN_CTR"],
									pql_get_define("PQL_ATTR_LOCALS"), $_REQUEST["set"], ''))
			  $msg = pql_complete_constant($LANG->_('Successfully removed %domain% from %what%'),
										   array('what'   => pql_get_define("PQL_ATTR_LOCALS"),
												 'domain' => $_REQUEST["set"]));
			else
			  $msg = pql_complete_constant($LANG->_('Failed to remove %domain% from %what%'),
										   array('what'   => pql_get_define("PQL_ATTR_LOCALS"),
												 'domain' => $_REQUEST["set"]))
				. ": " . pql_format_error(0);
		}
		break;
		// }}}

	  // {{{ Add entry
      case "add":
		foreach($HOSTS as $host) {
			// adding specified domain to locals in host object
			if(pql_modify_attribute($_pql_control->ldap_linkid,
									pql_get_define("PQL_ATTR_CN")."=$host,".$_SESSION["USER_SEARCH_DN_CTR"],
									$_REQUEST["attrib"], '', $_REQUEST["set"]))
			  $msg = pql_complete_constant($LANG->_('Successfully added %domain% to %value% %what%'),
										   array('what'   => $_REQUEST["attrib"],
												 'domain' => $_REQUEST["set"],
												 'value'  => $all));
			else
			  $msg = pql_complete_constant($LANG->_('Failed adding %domain% to %value% %what%'),
										   array('what'   => $_REQUEST["attrib"],
												 'domain' => $_REQUEST["set"],
												 'value'  => $all))
				. ": " . pql_format_error(0);
		}
		break;
		// }}}

	  // {{{ Default
      default:
		die(pql_complete_constant($LANG->_('Unknown save type %type% in file %file%, function save()'),
								  array('type' => $type, 'file' => __FILE__)));
		// }}}
    }

	if($msg)
	  // redirect back to host details
	  attribute_forward($msg);
}

// }}}


// {{{ locals_help(void)
function locals_help() {
	global $LANG;
?>
List of domain names that the current host receives
mail for, one per line.  Default:  me, if that is
supplied; otherwise qmail-send refuses to run.  An
address user@domain is considered local if domain is
listed in locals.
<?php
}
// }}}

// {{{ locals_help_cr(void)
function locals_help_cr() {
	global $LANG;
	echo $LANG->_('Help text taken from qmail man pages');
}
// }}}

// Local variables:
// mode: php
// mode: font-lock
// tab-width: 4
// End:
?>
