# Perl Instaler and Configuration Agent (PICA)
# or
# PICA Is for C{ompetent,ompulsive,razy} Admins
#
#   Copyright (C) 2001,2002  Miguel Armas, Esteban Manchado
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package picagroups;

# Expand all the groups, adding and substracting when necessary, and return a
# list only with files (well, this depends on the command to be executed,
# cause we don't want to expand alarms if we're about to execute them)
sub expandObjects ($$@);
sub expandObjects ($$@) {
   my @finallist;
   my $objref = shift;
   my $picacmd = shift;

   # Each element is the name of a file or group, supposedly defined in the
   # objects.conf file. It can have a '-' sign at the front, indicating that
   # the element has to be *deleted*, rather than added
   foreach my $i (@_) {
      my $actualname = $i;
      $actualname =~ s/^(-)//;
      my $substract = defined $1?1:0;

      # Doesn't exist? Perhaps an implicit group. If not, don't bother
      if (! exists $objref->{$actualname}) {
         if ($actualname eq 'all') {
            foreach my $o (&main::getAllObjects($objref)) {
               @finallist = grep !/^$o$/, @finallist;
               unless ($substract) {
                  push @finallist, $o;
               }
            }
         } elsif ($actualname eq 'alarms') {
            foreach my $o (&main::getAllAlarms($objref)) {
               @finallist = grep !/^$o$/, @finallist;
               unless ($substract) {
                  push @finallist, $o;
               }
            }
         } else {
            # Non-existent file. Perhaps some command to execute. Pass through
            push @finallist, $actualname;
         }
         next ;
      }

      # If it's a file, it's easy. If not, call recursively
      if ($objref->{$actualname}{'type'} eq 'file') {
         @finallist = grep !/^$i$/, @finallist;
         unless ($substract) {
            push @finallist, $actualname;
         }
      } else {
         if ($objref->{$actualname}{'type'} eq 'alarm') {
            @finallist = grep (!/^$actualname$/, @finallist);
            unless ($substract) {
               push @finallist, $actualname;
               # Don't expand members if we're going to execute this alarm
               next if ($picacmd eq 'exec');
            }
         }
         # Expand members
         foreach my $item (@{$objref->{$actualname}{'members'}}) {
            @finallist = grep (!/^$item$/, @finallist);
            unless ($substract) {
               push @finallist, expandObjects ($objref, $picacmd, $item);
            }
         }           # foreach my $item (@{$objref->{$actualname}{'members'}})
      }
   }                 # foreach my $i (@_)

   return @finallist;
}

# Expand all the hosts and hostgroups, adding and substracting when necessary,
# and return a list only with hosts
sub expandHosts ($@);
sub expandHosts ($@) {
   my @finallist;
   my $hostref = shift;

   # Each element is the name of a host or group, supposedly defined in the
   # hosts.conf file. It can have a '-' sign at the front, indicating that
   # the element has to be *deleted*, rather than added
   foreach my $i (@_) {
      my $actualname = $i;
      $actualname =~ s/^-//;

      # Doesn't exist? Don't bother
      if (! exists $hostref->{$actualname}) {
         if ($actualname eq 'all') {
            foreach my $o (&main::getAllObjects($hostref)) {
               if ($substract) {
                     @finallist = grep !/^$o$/, @finallist;
               } else {
                     push @finallist, $o;
               }
            }
         } else {
            print STDERR "Warning: $actualname doesn't exist\n";
            push @finallist, $actualname;
         }
         next ;
      }

      # If it's a file, it's easy. If not, call recursively
      if ($hostref->{$actualname}{'type'} eq 'host') {
         @finallist = grep !/$actualname/, @finallist;
         if ($i !~ /^-/) {
            push @finallist, $actualname;
         }
      } elsif ($hostref->{$actualname}{'type'} eq 'hostgroup') {
         foreach my $item (expandHosts $hostref,
                                       @{$hostref->{$actualname}{'members'}}) {
            @finallist = grep (!/$item/, @finallist);
            if ($i !~ /^-/) {
               push @finallist, $item;
            }
         }        # foreach my $item (@{$hostref->{$actualname}{'members'}})
      }           # elsif ($hostref->{$actualname}{'type'} eq 'group')
   }              # foreach my $i (@_)

   return @finallist;
}

1;
