# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Vollmert. All Rights Reserved.
# Portions Copyright (c) 2005 Lukas Lalinsky. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Vollmert, Lukas Lalinsky
#
#
# ***** END LICENSE BLOCK *****

import wx

from page import Page

class EncodingsPage(Page):

    name = N_("Encodings")

    def __init__(self, parent, config):
        Page.__init__(self, parent, config)

        box = wx.StaticBox(self, -1, _("Encodings"))
        sizer = wx.StaticBoxSizer(box, wx.VERTICAL)
        
        note = wx.StaticText(self, -1,
                             _("Select the encoding to use when reading and writing filenames") + ":")
        encodingsList = wx.ListBox(self, -1)
        encodingsList.Append(u"utf-7 -- " + _("all languages"), "utf-7")
        encodingsList.Append(u"utf-8 -- " + _("all languages"), "utf-8")
        encodingsList.Append(u"iso8859-1 -- West Europe (latin-1, cp819)", "iso8859-1")
        encodingsList.Append(u"iso8859-2 -- Central and Eastern Europe (iso-8859-2, latin2)", "iso8859-2")
        encodingsList.Append(u"iso8859-3 -- Esperanto, Maltese (iso-8859-3, latin3)", "iso8859-3")
        encodingsList.Append(u"iso8859-4 -- Baltic Languages (iso-8859-4, latin4)", "iso8859-4")
        encodingsList.Append(u"iso8859-5 -- Bulgarian, Byelorussian, Macedonian, Russian, Serbian (iso-8859-5, cyrillic)", "iso8859-5")
        encodingsList.Append(u"iso8859-6 -- Arabic (iso-8859-6)", "iso8859-6")
        encodingsList.Append(u"iso8859-7 -- Greek (iso-8859-7)", "iso8859-7")
        encodingsList.Append(u"iso8859-8 -- Hebrew (iso-8859-8)", "iso8859-8")
        encodingsList.Append(u"iso8859-9 -- Turkish (iso-8859-9, latin5)", "iso8859-9")
        encodingsList.Append(u"iso8859-10 -- Nordic languages (iso-8859-10, latin6)", "iso8859-10")
        encodingsList.Append(u"iso8859-13 -- Baltic Languages (iso-8859-13)", "iso8859-13")
        encodingsList.Append(u"iso8859-14 -- Celtic Languages (iso-8859-14, latin8)", "iso8859-14")
        encodingsList.Append(u"iso8859-15 -- Western Europe (iso-8859-15)", "iso8859-15")
        encodingsList.Append(u"cp1250 -- Central and Eastern Europe (windows-1250)", "cp1250")
        encodingsList.Append(u"cp1251 -- Bulgarian, Byelorussian, Macedonian, Russian, Serbian (windows-1251)", "cp1251")
        encodingsList.Append(u"cp1252 -- Western Europe (windows-1252)", "cp1252")
        encodingsList.Append(u"cp1253 -- Greek (windows-1253)", "cp1253")
        encodingsList.Append(u"cp1254 -- Turkish (windows-1254)", "cp1254")
        encodingsList.Append(u"cp1255 -- Hebrew (windows-1255)", "cp1255")
        encodingsList.Append(u"cp1256 -- Arabic (windows-1256)", "cp1256")
        encodingsList.Append(u"cp1257 -- Baltic languages (windows-1257)", "cp1257")
        encodingsList.Append(u"koi8-r -- Russian", "koi8-r")
        encodingsList.Append(u"koi8-u -- Ukrainian", "koi8-u")

        for i in xrange(encodingsList.GetCount()):
            data = encodingsList.GetClientData(i)
            if data.lower() == self.config.settingIOEncoding.lower():
                encodingsList.SetSelection(i)

        self.encodingsList = encodingsList
       
        sizer.Add(note, 0, wx.ALL, 5)
        sizer.Add(encodingsList, 1, wx.ALL | wx.EXPAND, 5)
        
        self.content.Add(sizer, 1, wx.EXPAND)
        self.Fit()

    def save(self):
        sel = self.encodingsList.GetSelection()
        if sel >= 0:
            self.config.settingIOEncoding = self.encodingsList.GetClientData(sel)
