# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2004 Robert Vollmert. All Rights Reserved.
# Portions Copyright (c) 2005 Lukas Lalinsky. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Robert Vollmert, Lukas Lalinsky
#
#
# ***** END LICENSE BLOCK *****

import wx
import sys

from page import Page
from controls import TextDefaultCtrl
from naminghelp import NamingHelpDialog

class NamingPage(Page):

    name = N_("Naming")
    
    checkId = 1
    helpId = 2

    def __init__(self, parent, config):
        Page.__init__(self, parent, config)

        box = wx.StaticBox(self, -1, _("Naming"))
        sizer = wx.StaticBoxSizer(box, wx.VERTICAL)
        
        self.renameCheck = wx.CheckBox(self, self.checkId, _("Rename files when writing metadata tags"))
        self.renameCheck.SetValue(self.config.settingRenameFiles)
        
        btn_help = wx.Button(self, self.helpId, _("Naming Help"))
        
        sizer1 = wx.BoxSizer(wx.HORIZONTAL)
        sizer1.Add(self.renameCheck)
        sizer1.Add((10,-1), 1, wx.EXPAND)
        sizer1.Add(btn_help)

        self.fileMaskEdit = TextDefaultCtrl(self, desc=_("File format naming specification") + ":",
                                            value = self.config.settingFileMask,
                                            default = self.config.defaultFileMask)

        self.vaFileMaskEdit = TextDefaultCtrl(self, desc=_("Various artist file format naming specification") + ":",
                                              value = self.config.settingVAFileMask,
                                              default = self.config.defaultVAFileMask)

        self.allowedCharsEdit = TextDefaultCtrl(self, -1, desc=_("Allowed filename characters") + ":",
                                                value=self.config.settingAllowedChars, default="")
        self.noteText = wx.StaticText(self, -1, _("Note: Leave blank to allow all "
                                                  "possible characters"))
    
        sizer.Add(sizer1, 0, wx.EXPAND | wx.ALL, 5)
        sizer.Add(self.fileMaskEdit, 0, wx.EXPAND | wx.ALL, 5)
        sizer.Add(self.vaFileMaskEdit, 0, wx.EXPAND | wx.ALL, 5)
        sizer.Add(self.allowedCharsEdit, 0, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP, 5)
        sizer.Add(self.noteText, 0,  wx.LEFT | wx.RIGHT | wx.BOTTOM, 5)
        
        if sys.platform != 'win32': 
            self.winSafeCheck = wx.CheckBox(self, -1, _("Use Windows-safe file names"))
            if not hasattr(config.getTunePimp(), 'setWinSafeFileNames'):
                self.config.settingWinSafeFileNames = False
                self.winSafeCheck.Enable(False)
            self.winSafeCheck.SetValue(self.config.settingWinSafeFileNames)
            sizer.Add(self.winSafeCheck, 0,  wx.LEFT | wx.RIGHT | wx.BOTTOM | wx.TOP, 5)
        else:
            self.winSafeCheck = None

        self.content.Add(sizer, 0, wx.EXPAND)
        self.Fit()

        wx.EVT_CHECKBOX(self, self.checkId, self.OnCheck)
        wx.EVT_BUTTON(self, self.helpId, self.OnHelp)
        self.enable(self.config.settingRenameFiles)

    def enable(self, val):
        self.fileMaskEdit.Enable(val)
        self.vaFileMaskEdit.Enable(val)
        self.allowedCharsEdit.Enable(val)
        self.noteText.Enable(val)

    def OnCheck(self, event):
        self.enable(event.IsChecked())

    def OnHelp(self, event):
        naminghelp = NamingHelpDialog(self, self.config)
        naminghelp.ShowModal()
        naminghelp.Destroy()

    def save(self):
        self.config.settingFileMask = self.fileMaskEdit.GetValue()
        self.config.settingVAFileMask = self.vaFileMaskEdit.GetValue()
        self.config.settingAllowedChars = self.allowedCharsEdit.GetValue()
        self.config.settingRenameFiles = self.renameCheck.IsChecked()
        if self.winSafeCheck:
            self.config.settingWinSafeFileNames = self.winSafeCheck.GetValue()
        
