import sys
import os
import types
import string
import shutil
import apt_pkg

import picax.config

import pdb

cache = None
config = {}

class FoundPackage(Exception):
    pass

def init():
    global cache
    global config

    if cache:
        raise RuntimeError, "apt is already initialized"

    global_conf = picax.config.get_config()
    base_dir = global_conf["temp_dir"] + "/apt-info"
    path = global_conf["base_path"]

    distro_hash = {}
    for (distro, comp) in global_conf["repository_list"]:
        if not distro_hash.has_key(distro):
            distro_hash[distro] = []
        distro_hash[distro].append(comp)
    distro_list = map(lambda x: (x, distro_hash[x]), distro_hash.keys())

    subdirs = ("state", "state/lists", "state/lists/partial", "cache",
               "cache/archives", "cache/archives/partial")

    if os.path.exists(base_dir):
        shutil.rmtree(base_dir)
    os.mkdir(base_dir)

    for subdir in subdirs:
        os.mkdir(base_dir + "/" + subdir)

    status = open("%s/state/status" % (base_dir,), "w")
    status.close()

    conf = open("%s/apt.conf" % (base_dir,), "w")
    conf.write("""
Dir "/tmp/apt-info/"
{
  State "state/" {
    status "status";
  };
  Cache "cache/";
  Etc "/tmp/apt-info/";
};
""")
    conf.close()

    slist = open("%s/sources.list" % (base_dir,), "w")
    for (distro, components) in distro_list:
        component_str = string.join(components, " ")
        slist.write("deb file://%s %s %s\n" % (path, distro, component_str))
    if global_conf.has_key("correction_apt_repo"):
        slist.write(global_conf["correction_apt_repo"] + "\n")
    slist.close()

    os.system("apt-get --config-file %s/apt.conf update" % (base_dir,))

    apt_pkg.InitConfig()
    apt_pkg.ReadConfigFile(apt_pkg.Config, "%s/apt.conf" % (base_dir,))
    apt_pkg.InitSystem()

    cache = apt_pkg.GetCache()
    global_conf["apt_path"] = base_dir

def _find_package_in_cache(pkg_name):
    global cache

    found_pkg = None
    for pkg in cache.Packages:
        if pkg.Name == pkg_name:
            found_pkg = pkg
            break

    if found_pkg is None:
        raise RuntimeError, "could not find package %s" % (pkg_name,)

    return found_pkg

def find_package_uri(pkg_name):
    global config

    found_pkg = _find_package_in_cache(pkg_name)
    if len(found_pkg.VersionList) <= 0:
        raise RuntimeError, "package %s exists, but cannot be found" \
              % (pkg_name,)

    # XXX: Need a better way to choose versions.
    pkg_version = found_pkg.VersionList[0]

    pkg_records = apt_pkg.GetPkgRecords(cache)
    pkg_records.Lookup(pkg_version.FileList[0])
    pkg_path = pkg_records.FileName

    global_conf = picax.config.get_config()
    full_path = global_conf["base_path"] + "/" + pkg_path
    if global_conf.has_key("correction_apt_repo") and \
       not os.path.exists(full_path):
        alt_uri = string.split(global_conf["correction_apt_repo"])[1]
        full_uri = alt_uri + pkg_path
    else:
        full_uri = "file://" + full_path

    return full_uri

def get_package_data(pkg_name_or_ver):
    if isinstance(pkg_name_or_ver, types.StringType):
        version = cache[pkg_name_or_ver].VersionList[0]
    else:
        version = pkg_name_or_ver

    filename = version.FileList[0][0].FileName

    fo = open(filename)
    tag = apt_pkg.ParseTagFile(fo)
    tag_valid = 1
    while tag_valid:
        if tag.Section["Package"] == version.ParentPkg.Name:
            break
        tag_valid = tag.Step()

    if not tag_valid:
        raise RuntimeError, "could not find package in its cache file"

    dict = {}
    for key in tag.Section.keys():
        dict[key] = tag.Section[key]

    fo.close()
    return dict

def _get_latest_version(pkg):
    latest = None
    for ver in pkg.VersionList:
        if not latest:
            latest = ver
        elif apt_pkg.VersionCompare(ver.VerStr, latest.VerStr) > 0:
            latest = ver

    return latest

def _match_version(ver1, ver2):
    return (ver1.ParentPkg.Name == ver2.ParentPkg.Name and \
            ver1.VerStr == ver2.VerStr)

def _match_dep(target_ver, source_ver, type):
    if not source_ver.DependsList.has_key(type):
        return False

    for dep in source_ver.DependsList[type]:
        for dep_alternative in dep:
            for dep_target in dep_alternative.AllTargets():
                if dep_target.ParentPkg.Name == target_ver.ParentPkg.Name and \
                   dep_target.VerStr == target_ver.VerStr:
                    return True

    return False

def resolve_package_list(pkgs, loose_deps = True):
    global cache

    queue = []
    results = []
    result_versions = {}
    reject = []
    seen = []
    bad_deps = []
    in_list = pkgs[:]

    # This is the loop that resolves all the dependencies.

    while len(in_list) > 0:

        # Take each package in turn off the input list and add it
        # to the queue.

        current_in = in_list.pop(0)

        # Make sure that a package by this name exists; if not, add it
        # to the rejects list.

        current_ver = None
        try:
            current_ver = _get_latest_version(cache[current_in])
        except:
            pass

        if not current_ver:
            reject.append(current_in)
            continue

        # Add the package to the queue.

        queue.append(current_ver)

        # Now resolve the queue.  The package, and its depenencies,
        # will be added in the proper order.

        while len(queue) > 0:

            # Long queue lengths most likely mean loops.

            if len(queue) > 100:
                raise RuntimeError, "queue length too long"

            # Get the most recent dependency off the queue.

            current = queue.pop()

            # Short-circuit the whole process if we've already
            # had to do it before to resolve some other package
            # dependency.

            if result_versions.has_key(current.ParentPkg.Name):
                if result_versions[current.ParentPkg.Name] != current.VerStr:
                    raise RuntimeError, "package added twice with different versions"
                continue

            # Look through this package's dependencies for ones
            # that haven't been seen yet.  If there are any, add
            # them to the top of the queue and loop.

            found_dep = False
            dep_list = []
            for key in ("PreDepends", "Depends"):
                if current.DependsList.has_key(key):
                    dep_list.extend(current.DependsList[key])
            for dep in dep_list:

                # For each ORed dependency, check that at least one
                # has been added.  If one has, stop immediately and go
                # on to the next dependency.  All the while, look for
                # candidate packages to add to the queue.

                try:
                    found = False
                    candidate = None
                    for dep_alternative in dep:

                        # Check to see if this has been flagged bad.

                        if loose_deps:
                            for bad_dep in bad_deps:
                                if dep_alternative.TargetPkg.Name == bad_dep.TargetPkg.Name and \
                                   dep_alternative.TargetVer == bad_dep.TargetVer and \
                                   dep_alternative.CompType == bad_dep.CompType:
                                    continue

                        for dep_target in dep_alternative.AllTargets():
                            disqualified = False

                            # If the target is already in the queue,
                            # consider the dependency met.  This
                            # handles certain types of dependency
                            # loops.

                            for item in queue:
                                if _match_version(item, dep_target):
                                    raise FoundPackage

                            # Otherwise, check to make sure the package
                            # isn't already in the results.

                            if result_versions.has_key(dep_target.ParentPkg.Name):
                                if result_versions[dep_target.ParentPkg.Name] != dep_target.VerStr:
                                    raise RuntimeError, "version mismatch with already added package"
                                raise FoundPackage

                                if _match_version(result, dep_target):
                                    raise FoundPackage

                            # If it's not already in the results, maybe
                            # it's a candidate for adding to the results.

                            if not loose_deps and not candidate and \
                               not disqualified:
                                for result in results:
                                    if _match_dep(dep_target, result,
                                                  "Conflicts"):
                                        disqualified = True
                                    elif _match_dep(result, dep_target,
                                                    "Conflicts"):
                                        disqualified = True

                            # We don't have a valid candidate, and this
                            # package looks to be a good one.

                            if not candidate and not disqualified:
                                candidate = dep_target

                # This is where we end up if a package fulfilling
                # a dependency alternative is found.

                except FoundPackage:
                    found = True

                # If no alternative was found in the current list,
                # add the candidate we found to the queue.

                if not found:

                    # If no candidate package was found either, then
                    # we have an unresolvable dependency.

                    if not candidate:
                        if loose_deps:
                            sys.stderr.write("warning: could not resolve dep '%s' for package %s\n"
                                             % (str(dep),
                                                current.ParentPkg.Name))
                            for dep_alternative in dep:
                                bad_deps.append(dep_alternative)
                            found_dep = False
                        else:
                            raise RuntimeError, \
                                  "cannot find '%s' dep for package %s" \
                                  % (str(dep), current.ParentPkg.Name)

                    # Re-add the current package to the queue.

                    else:
                        queue.append(current)

                        # Add the candidate after the current package.

                        queue.append(candidate)
                        found_dep = True
                        break

            # We added a dep to the queue, so re-run the queue.

            if found_dep:
                continue

            # "Leaf" dependency.

            pkg_name = current.ParentPkg.Name
            results.append(current)
            if not result_versions.has_key(pkg_name):
                result_versions[pkg_name] = current.VerStr
            else:
                if result_versions[pkg_name] != current.VerStr:
                    raise RuntimeError, "request to add two packages with same names but different versions"

    # All done.  Now get the package names, and return them.

    return map(lambda x: x.ParentPkg.Name, results)
