/***************************************************************************
 *            qof-address.h
 *
 *  Thu Oct 21 12:44:36 2004
 *  Copyright  2004-2005  Neil Williams  <linux@codehelp.co.uk>
 ****************************************************************************/
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
/** @addtogroup QOF
	@{ */
/** @addtogroup Addr Addresses and Contacts

	Addresses is probably the easiest QOF object to understand - all the entries
	are simple strings. QOF does provide a cache that could be used here but
  until pilot-qof has an interactive shell, creating and then populating
  the cache is considered not worthwhile.

	@{ */
/** @file  qof-address.h
	@brief QOF address definitions for pilot-link
	@author Copyright (c) 2004 Neil Williams <linux@codehelp.co.uk>
*/

#ifndef _QOF_ADDRESS_H
#define _QOF_ADDRESS_H

#define PQ_MOD_ADDRESS "pilotqof-address"
#define PILOT_LINK_QOF_ADDRESS "pilot_address"
/** Hack alert: Because these are strings (for QOF), the
	macros CANNOT be used directly in the enum! */
#define ADDR_LAST_NAME 	"entryLastname"
#define ADDR_FIRST_NAME	"entryFirstname"
#define	ADDR_COMPANY	"entryCompany"
#define	ADDR_PHONE_ONE	"entryPhone1"
#define	ADDR_PHONE_TWO	"entryPhone2"
#define	ADDR_PHONE_THREE "entryPhone3"
#define	ADDR_PHONE_FOUR	"entryPhone4"
#define	ADDR_PHONE_FIVE	"entryPhone5"
#define	ADDR_ADDRESS	"entryAddress"
#define	ADDR_CITY		"entryCity"
#define	ADDR_STATE		"entryState"
#define	ADDR_ZIP		"entryZip"
#define	ADDR_COUNTRY	"entryCountry"
#define	ADDR_TITLE		"entryTitle"
#define	ADDR_CUSTOM_ONE	"entryCustom1"
#define	ADDR_CUSTOM_TWO	"entryCustom2"
#define	ADDR_CUSTOM_THREE "entryCustom3"
#define	ADDR_CUSTOM_FOUR "entryCustom4"
#define	ADDR_NOTE 		"entryNote"
#define	ADDR_CATEGORY	"category"
	
/** \brief Extended for pilot-link

Uses the standard QOF registration but adds a pilot_pack
registration that tells QOF how to deal with the pilot-link
objects contained within the QOF objects.
*/
gboolean AddressRegister (void);

#endif /* _QOF_ADDRESS_H */
/** @} */
/** @} */
