/*
 * PIMPPA: Bowser - Files & Fileareas related stuff
 *
 * FIXME: This file is a mess. ;)
 *
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include "proto.h"
#include "../src/pimppa.h"

typedef enum
{
	SHOW_ONLINE		=	1,
	SHOW_OFFLINE	=	2,
	SHOW_ALL		=	3
} ShowType;

#define AREAS_ALL			1
#define	AREAS_INCOMING		2
#define	AREAS_NORMAL		3

#define CLAUSE_AREA		"areaclause"
#define CLAUSE_AFLAGS	"aflagsclause"
#define CLAUSE_FILE		"fileclause"
#define CLAUSE_MISC		"miscclause"

char *WhereClauses[4]={CLAUSE_AREA, CLAUSE_FILE, CLAUSE_MISC, CLAUSE_AFLAGS};

#define AMOUNT_WHERECLAUSES		4
	
GtkWidget *FileData[2];
unsigned int fileFlags=SHOW_ONLINE;
unsigned int areaFlags=AREAS_ALL;

GtkWidget *flist=NULL;

struct fileKludge
{
	gchar *file_path;
	unsigned long file_id;
};

// FIXME: This doubleclick shit is SO BADLY implemented that
// its worse than shit freezing in hell
int DoubleClickKludge=0;

typedef struct fileKludge fileKludge;

static void refresh_files(GtkWidget *widget, gpointer data);
static void area_sel(GtkWidget *clist, gint row, gint column,
	    GdkEventButton *event, gpointer data);
static void showfiles_all(GtkWidget *widget, gpointer data);
static void showfiles_online(GtkWidget *widget, gpointer data);
static void showfiles_offline(GtkWidget *widget, gpointer data);
static void areas_all(GtkWidget *widget, gpointer data);
static void areas_normal(GtkWidget *widget, gpointer data);
static void areas_incoming(GtkWidget *widget, gpointer data);
static void refresh_areas(GtkWidget *widget, gpointer data);
static void delete_file(GtkWidget *widget, gpointer data);
static void edit_file(GtkWidget *widget, gpointer data);
static void kill_file(GtkWidget *widget, gpointer data);
static void move_file(GtkWidget *widget, gpointer data);
static void view_file(GtkWidget *widget, gpointer data);
static void where_fs_last(GtkWidget *widget, gpointer data);
static gint doubleclick_handler(GtkWidget *widget, GdkEventButton *event,
                        gpointer data);
static void free_kludge(gpointer data);
static void update_wherebox(GtkWidget *widget, gpointer data);

GnomeUIInfo areaMenu[] = {
	GNOMEUIINFO_ITEM_NONE("Refresh areas", "Reload filearea datas",
							refresh_areas),
	GNOMEUIINFO_END
};
	
GnomeUIInfo fileMenu[] = {
	GNOMEUIINFO_MENU_SELECT_ALL_ITEM(select_all, GNOMEUIINFO_KEY_UIDATA),
	GNOMEUIINFO_MENU_CLEAR_ITEM(unselect_all, GNOMEUIINFO_KEY_UIDATA),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM_NONE("Refresh filelist", "Reload filelist contents",
							refresh_files),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM_NONE("View selected", "Display selected files",
							view_file),
	GNOMEUIINFO_ITEM_NONE("Edit selected", "Edit selected files",
							edit_file),
	GNOMEUIINFO_ITEM_NONE("Delete selected", "Delete selected files",
							delete_file),
	GNOMEUIINFO_ITEM_NONE("Move selected", "Move selected files",
							move_file),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM_NONE("KILL selected", "Kill selected files",
							kill_file),
	GNOMEUIINFO_END
};

GnomeUIInfo whereMenu[] = {
	GNOMEUIINFO_ITEM_NONE("Find since last", "Find all since last press",
						where_fs_last),
	GNOMEUIINFO_END
};


static char *areaFlagNames[3]={"AREA_NOTRANS (1)", "AREA_INCOMING (2)", "AREA_NOASSIGN (4)"};

static bowser_flags areaFlagStrings={areaFlagNames, 3};
static bowser_foreign areaContextForeign={"c_name","c_id", "p_contexts"};

static bowser_column areaDatas[6]=
    {{"area_name", COLUMN_TEXT, 100, "cats", NULL},
     {"area_path", COLUMN_TEXT, 200, "/stuff/cats/", NULL},
     {"area_id", COLUMN_NUMBER, 20,  "", NULL},
     {"area_flags", COLUMN_FLAGS, 20, "0", &areaFlagStrings},
     {"area_context", COLUMN_COMBO, 50, "", &areaContextForeign},
     {"area_targets", COLUMN_TEXT, 100, "$", NULL}};
static bowser_table areaTable={areaDatas, "p_areas", 6};


GtkWidget *get_areas_box(void)
{
	return(get_table(&areaTable));
}

static gint
doubleclick_handler(GtkWidget *widget, GdkEventButton *event, 
						gpointer data)
{
	GList *tmp;
	int row,col;
	GtkCList *flist=(GtkCList *)data;

//	fprintf(stderr, "DEBUG: Event %d\n", event->type);

	if (event->type==GDK_2BUTTON_PRESS && event->button == 1)
	{
		tmp=GTK_CLIST(flist)->selection;
		if(!tmp)
		{
			if(gtk_clist_get_selection_info(flist, event->x, event->y, &row, &col))
			{
				DoubleClickKludge=row+1;

				view_file(NULL, flist);
			
				DoubleClickKludge=0;
			}
			
		}
		else
			view_file(NULL, flist);
	}

	return(TRUE);
}

/*
static void
view_clicked(GnomeDialog *dlg, int button, gpointer data)
{
	gnome_dialog_close(dlg);
	return;
}
*/

/* Add all the fileareas */
static void 
refresh_areas(GtkWidget *widget, gpointer data)
{
	GtkCList *alist=(GtkCList *)data;
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	char *defaultarea[2]={"*All areas*","%" };

	gtk_clist_freeze(GTK_CLIST(alist));

	gtk_clist_clear(GTK_CLIST(alist));

/******* Incoming areas *********/

	gtk_clist_append(GTK_CLIST(alist), defaultarea);
	gtk_clist_select_row(GTK_CLIST(alist), 0, 0);
	
	if(areaFlags==AREAS_INCOMING || areaFlags==AREAS_ALL)
	{
		p_query(db, "SELECT area_name, area_id "
			    "FROM p_areas "
			    "WHERE (area_flags & %ld) "
			    "ORDER by area_name",
			AREA_INCOMING);
		if(mysql_error(db)[0])
		{
			my_error_dialog("Error: %s\n", mysql_error(db));
			return;
		}
		sql_result=mysql_store_result(db);
		if(sql_result)
		{
			while((sql_row=mysql_fetch_row(sql_result)))
			{
				gtk_clist_append(GTK_CLIST(alist), sql_row);
			}
			mysql_free_result(sql_result);
		}
	}
	
/****** Normal areas **************/

	if(areaFlags==AREAS_NORMAL || areaFlags==AREAS_ALL)
	{
		p_query(db, "SELECT area_name, area_id "
			    "FROM p_areas "
			    "WHERE NOT (area_flags & %ld) "
			    "ORDER by area_name",
			AREA_INCOMING);
		if(mysql_error(db)[0])
		{
			gtk_clist_thaw(alist);
			my_error_dialog("Error: %s\n", mysql_error(db));
			return;
		}
		sql_result=mysql_store_result(db);
		if(sql_result)
		{
			while((sql_row=mysql_fetch_row(sql_result)))
			{
				gtk_clist_append(GTK_CLIST(alist), sql_row);
			}
			mysql_free_result(sql_result);
		}
	}
	gtk_clist_thaw(alist);

	return;
}

static void 
showfiles_offline(GtkWidget *widget, gpointer data)
{
	fileFlags=SHOW_OFFLINE;
	
	refresh_files(NULL, data);

	return;
}

static void 
showfiles_online(GtkWidget *widget, gpointer data)
{
	fileFlags=SHOW_ONLINE;
	
	refresh_files(NULL, data);
}

static void 
showfiles_all(GtkWidget *widget, gpointer data)
{
	fileFlags=SHOW_ALL;

	refresh_files(NULL, data);
}

static void 
areas_all(GtkWidget *widget, gpointer data)
{
	GtkWidget *wherebox, *flist;
	gchar *clause;

//	fprintf(stderr, "DEBUG: areas_all()\n");

	flist=gtk_object_get_data(GTK_OBJECT(data), "flist");
	wherebox=gtk_object_get_data(GTK_OBJECT(flist), "wherebox");
	clause=gtk_object_get_data(GTK_OBJECT(wherebox), CLAUSE_AFLAGS);

	clause[0]=0;

	areaFlags=AREAS_ALL;
	update_wherebox(NULL, wherebox);
	refresh_areas(NULL, data);
}
	
	
static void 
areas_normal(GtkWidget *widget, gpointer data)
{
	GtkWidget *wherebox, *flist;
	gchar *clause;
	
	flist=gtk_object_get_data(GTK_OBJECT(data), "flist");
	wherebox=gtk_object_get_data(GTK_OBJECT(flist), "wherebox");
	clause=gtk_object_get_data(GTK_OBJECT(wherebox), CLAUSE_AFLAGS);

	sprintf(clause, "NOT (area_flags & %d)", AREA_INCOMING);

	areaFlags=AREAS_NORMAL;
	update_wherebox(NULL, wherebox);
	refresh_areas(NULL, data);
}
	
static void 
areas_incoming(GtkWidget *widget, gpointer data)
{
	GtkWidget *wherebox, *flist;
	gchar *clause;
	
	flist=gtk_object_get_data(GTK_OBJECT(data), "flist");
	wherebox=gtk_object_get_data(GTK_OBJECT(flist), "wherebox");
	clause=gtk_object_get_data(GTK_OBJECT(wherebox), CLAUSE_AFLAGS);
	
	sprintf(clause, "(area_flags & %d)", AREA_INCOMING);

	areaFlags=AREAS_INCOMING;
	update_wherebox(NULL, wherebox);
	refresh_areas(NULL, data);
}
	
static void 
edit_file_clicked(GnomeDialog *dlg, int button, gpointer data)
{
	gchar *file_desc, *escaped_desc;
	GtkCList *flist=(GtkCList *)data;
	GList *tmp;
	int go=0, desc_len=0;

	switch(button)
	{
		case 0:			// Ok
			break;
		case 1:			// Cancel
		default:
			gnome_dialog_close(dlg);
			gtk_clist_thaw(flist);
			return;
			break;
	}
	
	if(!flist)
	{
		gnome_dialog_close(dlg);
		return;
	}

//	file_name=gtk_entry_get_text(GTK_ENTRY(FileData[0]));
	file_desc=gtk_entry_get_text(GTK_ENTRY(FileData[0]));

	desc_len=strlen(file_desc);
	escaped_desc=malloc(2*desc_len+1);
	mysql_escape_string(escaped_desc, file_desc, desc_len);

	tmp=flist->selection;
	while(tmp)
	{
		int row=(int)tmp->data;
		fileKludge *kludge;

		kludge=gtk_clist_get_row_data(flist, row);
		
		p_query(db, "UPDATE p_files SET file_desc='%s' "
			    "WHERE file_id=%lu",
			escaped_desc,
			kludge->file_id);
		
		tmp=tmp->next;
		go=1;
	}

	if(go)
		refresh_files(NULL, flist);

	free(escaped_desc);

	gtk_clist_thaw(flist);
	gnome_dialog_close(dlg);
}

static void 
edit_file(GtkWidget *widget, gpointer data)
{
	GtkWidget *dlg;
	GtkCList *flist=(GtkCList *)data;

	if(!flist || !flist->selection)
		return;

	gtk_clist_freeze(flist);
		
	dlg=gnome_dialog_new("Edit file",
						GNOME_STOCK_BUTTON_OK,
						GNOME_STOCK_BUTTON_CANCEL,
						NULL);
	gnome_dialog_set_parent(GNOME_DIALOG(dlg), GTK_WINDOW(Bowser));
	gtk_signal_connect(GTK_OBJECT(dlg),"clicked",
						GTK_SIGNAL_FUNC(edit_file_clicked),
						flist);

//	hbox = gtk_hbox_new (TRUE, 0);
//	gtk_box_pack_end(GTK_BOX(GNOME_DIALOG(dlg)->vbox), hbox, FALSE, FALSE, 0);
//	gtk_widget_show(hbox);

	newbox("Description", GNOME_DIALOG(dlg)->vbox, "", 
			&FileData[0], 250);

	gtk_widget_show(dlg);

	return;
}

/*
 * Deletes the currently selected file(s). No abort!
 *
 */
static void
delete_file(GtkWidget *widget, gpointer data)
{
	char buffer[QUERY_MAX];
	GtkCList *flist=(GtkCList *)data;
	gchar *filename;
	GList *tmp;

	if(!flist)
		return;

	tmp=flist->selection;
	while(tmp)
	{
		int data=(int)tmp->data;
		fileKludge *kludge;
		
		tmp=tmp->next;

		kludge=gtk_clist_get_row_data(flist, data);

		gtk_clist_get_text(flist, data, 0, &filename);

		p_query(db, "DELETE FROM p_files "
			    "WHERE file_id=%lu",
			kludge->file_id);

		sprintf(buffer, "%s%s%s", 
						kludge->file_path,
						(p_checkp(kludge->file_path) ? "" : "/"),
						filename);
		remove(buffer);

		gtk_clist_remove(flist, data);
	}

	return;
}

/* 
 * User clicked the "View" button. 
 * 
 * This is a external viewer based version currently in use.
 *
 */
static void 
view_file(GtkWidget *widget, gpointer data)
{
	char tmpdir[PATH_MAX];
	char olddir[PATH_MAX];
	char fullpath[PATH_MAX];
	char newpath[PATH_MAX];
//	GtkCList *flist=(GtkCList *)data;
	gchar *text;
	GList *tmp;
	char *viewercmd;

//	printf("call\n");

	if(!flist)
		return;
	
	viewercmd=p_getmisc(db, P_KEY_VIEWER);
	if(!viewercmd)
		viewercmd=P_VIEWER;

	tmp=GTK_CLIST(data)->selection;
	if(!tmp && !DoubleClickKludge)
		return;
/*		
	{
		my_error_dialog("Select some files first...\n");
		return;
	}
*/

	sprintf(tmpdir, "/tmp/bowser.%d", getpid());
	mkdir(tmpdir, 0700);

	getcwd(olddir, PATH_MAX);
	chdir(tmpdir);
	
	while(tmp || DoubleClickKludge)
	{
		fileKludge *kludge;
		int row;
	
		if(DoubleClickKludge)
		{
			row=DoubleClickKludge-1;
			DoubleClickKludge=0;
		}
		else
			row=(int)tmp->data;
		
		gtk_clist_get_text(GTK_CLIST(flist), row, 0, &text);
		kludge=gtk_clist_get_row_data(GTK_CLIST(flist), row);
		
		sprintf(fullpath, "%s%s%s", 
				kludge->file_path,
				(p_checkp(kludge->file_path) ? "" : "/"),
				text);
		sprintf(newpath, "%s/%s", tmpdir, text);
		symlink(fullpath, newpath);	

		if(tmp)
			tmp=tmp->next;
	}

	if(fork()==0)
	{
		char buffer[PATH_MAX];
		char newdir[PATH_MAX];

		sprintf(newdir, "/tmp/bowser.%d", getpid());
		rename(tmpdir, newdir);
		chdir(newdir);
	
		system(viewercmd);

		chdir(olddir);

		sprintf(buffer, "rm -Rf %s", newdir);
		system(buffer);

		_exit(0);
	}
	
	gtk_clist_unselect_all(GTK_CLIST(flist));

//	fprintf(stderr, "DEBUG: view_file() end!\n");
}

/* If we come here, then the user has selected a row in the list. */
static void 
area_sel( GtkWidget		 *clist,
			  gint			  row,
			  gint			  column,
			  GdkEventButton *event,
			  gpointer		  data )
{
	gchar *area_id;
	char *areatmp;
	GtkWidget *wherebox=gtk_object_get_data(data, "wherebox");
	GtkCList *flist=(GtkCList *)data;

	gtk_clist_get_text(GTK_CLIST(clist), row, 1, &area_id); 
//	gtk_clist_get_text(GTK_CLIST(clist), row, 3, &flags);

	areatmp=gtk_object_get_data(GTK_OBJECT(wherebox), CLAUSE_AREA);

	if(strcmp(area_id, "%")==0)
		areatmp[0]=0;
	else
	{
		sprintf(areatmp, "file_area=%s", area_id);
	}

	update_wherebox(NULL, wherebox);
	
	refresh_files(NULL, flist);
	
//	fprintf(stderr, "DEBUG: diedthere\n");

	return;
}

static void 
refresh_files(GtkWidget *widget, gpointer data)
{
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	char buffer[QUERY_MAX];
	GtkWidget *flist;
	gchar *where;
	GtkWidget *wherebox;

	flist=(GtkWidget *)data;
	wherebox=gtk_object_get_data(GTK_OBJECT(flist), "wherebox");
	where=gtk_entry_get_text(GTK_ENTRY(wherebox));

	if(!where || !where[0] || !flist)
		return;
	
	gtk_clist_clear(GTK_CLIST(flist));
	
	switch(fileFlags)
	{
		case SHOW_ONLINE:
			sprintf(buffer, "NOT (file_flags & %d)",
					FILE_OFFLINE);
			break;
		case SHOW_OFFLINE:
			sprintf(buffer, "(file_flags & %d)",
					FILE_OFFLINE);
			break;
		case SHOW_ALL:
		default:
			buffer[0]=0;
			break;
	}
	
	p_query(db, "SELECT file_name, file_size, file_desc, "
		    "  area_path, file_id "
		    "FROM p_files, p_areas "
		    "WHERE %s %s %s AND area_id=file_area", 
		(buffer[0] ? buffer : ""),
		(buffer[0] ? "AND" : ""),
		where);
//	fprintf(stderr, "%s AND %s\n", buffer, where);
	if(mysql_error(db)[0])
	{
		my_error_dialog("Error: %s\n", mysql_error(db));
		return;
	}
	sql_result=mysql_use_result(db);
	if(sql_result)
	{
		gtk_clist_freeze(GTK_CLIST(flist));
		
		while((sql_row=mysql_fetch_row(sql_result)))
		{
			gint currow=0;
			fileKludge *kludge=malloc(sizeof(fileKludge));
			
			currow=gtk_clist_prepend(GTK_CLIST(flist), sql_row);
			kludge->file_path=strdup(sql_row[3]);
			kludge->file_id=atol(sql_row[4]);
			
			gtk_clist_set_row_data_full(GTK_CLIST(flist), 
				currow, kludge, free_kludge);
		}
		mysql_free_result(sql_result);
	
		gtk_clist_sort(GTK_CLIST(flist));
		gtk_clist_thaw(GTK_CLIST(flist));
	}
	
	return;
}

static void 
move_file_clicked(GnomeDialog *dlg, int button, gpointer data)
{
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	GtkCList *flist=(GtkCList *)data;
	gchar *area_name, *file_name;
	int dest_area_id=0, dst_context=0;
	char dest_area_path[PATH_MAX];
	GList *tmp;
	int total=0, counter=0;
	char *value;
	int minassnamelen;

	if(!flist)
	{
		gnome_dialog_close(dlg);
		return;
	}

	switch(button)
	{
		case 0:		// Ok
			break;
		case 1:
		default:
			gnome_dialog_close(dlg);
			gtk_clist_thaw(flist);
			return;
			break;
	}

	area_name=gtk_entry_get_text(GTK_ENTRY(FileData[0]));
	p_query(db, "SELECT area_id, area_path, area_context "
	 	    "FROM p_areas "
		    "WHERE area_name='%s'", 
		area_name);
	sql_res=mysql_store_result(db);
	if(sql_res)
	{
		if((sql_row=mysql_fetch_row(sql_res)))
		{
			dest_area_id=atoi(sql_row[0]);
			strcpy(dest_area_path, sql_row[1]);
			dst_context=atoi(sql_row[2]);
		}

		mysql_free_result(sql_res);
	}

	if(!dest_area_id)
	{
		gnome_dialog_close(dlg);
		gtk_clist_thaw(flist);
		return;
	}

	tmp=flist->selection;
	while(tmp)
	{
		tmp=tmp->next;
		total++;
	}

	if(!total)
	{
		gnome_dialog_close(dlg);
		gtk_clist_thaw(flist);
		return;
	}

	value=p_getmisc(db, P_KEY_MINASSNAMELEN);
	if(value)
		minassnamelen=atoi(value);
	else
		minassnamelen=atoi(P_MIN_ASS_NAMELENGTH);

	gnome_appbar_set_status (GNOME_APPBAR(statusBar), "Moving...");
	while (gtk_events_pending())
		gtk_main_iteration();
	
	tmp=flist->selection;
	while(tmp)
	{
		char fullsrc[PATH_MAX];
		char escaped_fn[2*P_LEN_FILE_NAME+1];
		int row=(int)tmp->data;
		fileKludge *kludge;

		gtk_clist_get_text(flist, row, 0, &file_name);
		kludge=gtk_clist_get_row_data(flist, row);

//		fprintf(stderr, "P: %s\n", path);

		mysql_escape_string(escaped_fn, file_name, strlen(file_name));

		// Delete destination file, if exists
		p_query(db, "DELETE FROM p_files " 
			    "WHERE file_name='%s' AND file_area=%d",
			escaped_fn, dest_area_id);
		
		// Move file in db
		p_query(db, "UPDATE p_files SET file_area=%d "
			    "WHERE file_id=%lu",
			dest_area_id, kludge->file_id);
	
		if(dest_area_id<0)	
			p_query(db, "UPDATE p_files "
				    "SET file_flags=(file_flags | %ld) "
				    "WHERE file_id=%lu",
				FILE_OFFLINE, kludge->file_id);

		sprintf(fullsrc, "%s%s%s", 
						kludge->file_path,
						(p_checkp(kludge->file_path) ? "" : "/"),
						file_name);
		if(!p_mv(fullsrc, dest_area_path))
		{
			my_error_dialog("p_mv() error from %s to %s\n",
					fullsrc, dest_area_path);
		}

		p_assign(db, file_name, minassnamelen, dest_area_id, dst_context);

		tmp=tmp->next;

	    gnome_appbar_set_progress(GNOME_APPBAR(statusBar), 
			(float)((float)counter/(float)total));

		while (gtk_events_pending())
			gtk_main_iteration();
			
		counter++;
	}

	gnome_appbar_set_progress(GNOME_APPBAR(statusBar), 
		(float)0);
	gnome_appbar_set_status (GNOME_APPBAR(statusBar), "");

	refresh_files(NULL, flist);

	gnome_dialog_close(dlg);
	gtk_clist_thaw(flist);
}

/*
 * Moves the currently selected files to another area. 
 * Asks for the area name.
 * 
 */
static void move_file(GtkWidget *widget, gpointer data)
{
	GtkWidget *dlg;
	GtkWidget *combox, *label;
	GtkCList *flist=(GtkCList *)data;
	GList *glist=NULL;

	if(!flist || !flist->selection)
		return;

	gtk_clist_freeze(flist);
	
	dlg = gnome_dialog_new("Move file(s)",
                        GNOME_STOCK_BUTTON_OK,
                        GNOME_STOCK_BUTTON_CANCEL,
                        NULL);

	gnome_dialog_set_parent(GNOME_DIALOG(dlg), GTK_WINDOW(Bowser));
	
	gtk_signal_connect(GTK_OBJECT(dlg),"clicked",
					GTK_SIGNAL_FUNC(move_file_clicked), 
					flist);
	
/********* Generate areaList button **********/

	label = gtk_label_new("Select destination area:");
	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox), label, 0, 0, 0);
	gtk_widget_show(label);
	
	glist=get_sql(db, "SELECT area_name " 
			  "FROM p_areas "
			  "ORDER BY area_name");

	combox=gtk_combo_new();
    gtk_combo_set_popdown_strings( GTK_COMBO(combox), glist) ;
	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox), combox, TRUE, TRUE, 0);
	gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combox)), "destroy",
						(GtkSignalFunc) clear_glist, glist);
	gtk_widget_show(combox);
	FileData[0]=GTK_WIDGET(GTK_COMBO(combox)->entry);

	gtk_widget_show(dlg);

	return;
}

GtkWidget *get_stuff_box(void)
{
	GtkWidget *popupmenu;
	GtkWidget *vbox, *hbox, *label, *button;
	GtkWidget *alist,*wherebox;
//	GtkWidget *flist;
	GtkWidget *sincebutton;
	GtkWidget *table;
	GtkWidget *areaList_window, *fileList_window;
	gchar *areatitles[2] = { "Area", "ID" };
    gchar *filetitles[3] = { "Filename", "Size", "Description" };
	gchar *clause;
	int i;
	GSList *group;	
	GtkAdjustment *adj;
	char *value;
	int sincedays;

	value=p_getmisc(db, P_KEY_BOWSERSINCE);
	if(value)
		sincedays=atoi(value);
	else
		sincedays=atoi(P_BOWSER_DEFAULT_SINCE);

    vbox=gtk_vbox_new(FALSE,0);

	table = gtk_table_new (4, 4, TRUE);
	gtk_container_add (GTK_CONTAINER(vbox), table);

/****** AreareaList window *****/
	
	areaList_window=gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(areaList_window),
								GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

	gtk_table_attach_defaults (GTK_TABLE(table), areaList_window, 0, 1, 0, 4);

	alist=gtk_clist_new_with_titles(2, areatitles);
	gtk_clist_set_shadow_type(GTK_CLIST(alist), GTK_SHADOW_OUT);

	gtk_clist_set_column_auto_resize(GTK_CLIST(alist), 0, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(alist), 1, TRUE);

	gtk_container_add(GTK_CONTAINER(areaList_window), alist);

/****** Filelist window *****/

	fileList_window=gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(fileList_window),
									GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_table_attach_defaults (GTK_TABLE(table), fileList_window, 1, 4, 0, 4);
	
	flist = gtk_clist_new_with_titles( 3, filetitles);

	gtk_object_set_data(GTK_OBJECT(alist), "flist", flist);
	gtk_clist_set_selection_mode((GtkCList *)flist, GTK_SELECTION_EXTENDED);

	gtk_signal_connect(GTK_OBJECT(alist), "select_row",
						GTK_SIGNAL_FUNC(area_sel),
						flist);
	gtk_signal_connect(GTK_OBJECT(flist), "button_press_event",
						GTK_SIGNAL_FUNC(doubleclick_handler),
						flist);
						/*
	gtk_signal_connect(GTK_OBJECT(flist), "button_release_event",
						GTK_SIGNAL_FUNC(doubleclick_handler),
						flist);
						*/
	
	
	gtk_clist_set_shadow_type((GtkCList *)flist, GTK_SHADOW_OUT);

	gtk_clist_set_column_auto_resize(GTK_CLIST(flist), 0, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(flist), 1, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(flist), 2, TRUE);
	
	gtk_container_add(GTK_CONTAINER(fileList_window), flist);

/******** Arealist popup menu ***********/

	popupmenu=gnome_popup_menu_new(areaMenu);
	gnome_popup_menu_attach(popupmenu, alist, alist);
	gnome_app_install_menu_hints(GNOME_APP(Bowser), areaMenu);

/******** Filelist popup menu ***********/

	popupmenu=gnome_popup_menu_new(fileMenu);
	gnome_popup_menu_attach(popupmenu, flist, flist);
	gnome_app_install_menu_hints(GNOME_APP(Bowser), fileMenu);

/******** Incoming buttons *************/
	
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	
	label = gtk_label_new("Areas matched:");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

	button = gtk_radio_button_new_with_label(NULL, "All");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
							GTK_SIGNAL_FUNC(areas_all),
							alist);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 0);

	group=gtk_radio_button_group(GTK_RADIO_BUTTON(button));
	button=gtk_radio_button_new_with_label(group, "Normal");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
							GTK_SIGNAL_FUNC(areas_normal),
							alist);
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 0);

	group=gtk_radio_button_group (GTK_RADIO_BUTTON (button));
	button=gtk_radio_button_new_with_label(group, "Incoming");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
							GTK_SIGNAL_FUNC(areas_incoming),
							alist);
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 0);


/******** Selection buttons *************/
	
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	
	label = gtk_label_new("Files matched:");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

	button = gtk_radio_button_new_with_label(NULL, "Online");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
							GTK_SIGNAL_FUNC(showfiles_online),
							flist);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), TRUE);
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 0);

	group=gtk_radio_button_group(GTK_RADIO_BUTTON(button));
	button=gtk_radio_button_new_with_label(group, "Offline");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
							GTK_SIGNAL_FUNC(showfiles_offline),
							flist);
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 0);

	group=gtk_radio_button_group (GTK_RADIO_BUTTON (button));
	button=gtk_radio_button_new_with_label(group, "All");
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
							GTK_SIGNAL_FUNC(showfiles_all),
							flist);
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 0);

/****** Since box, to the same hbox **********/
	
	label = gtk_label_new("Since days:");
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);

	adj=(GtkAdjustment *)gtk_adjustment_new(sincedays, 
											0, INT_MAX, 1, 0, 0);
	sincebutton=gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(sincebutton), TRUE);

	gtk_box_pack_start(GTK_BOX(hbox),sincebutton,FALSE,FALSE,0);

/****** SQL Where box ******/

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	
	label = gtk_label_new("SQL where:");
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);

	wherebox=gtk_entry_new_with_max_length(PATH_MAX);
	gtk_signal_connect(GTK_OBJECT(wherebox),"activate",
						GTK_SIGNAL_FUNC(refresh_files),
						flist);
	
	gtk_object_set_data(GTK_OBJECT(wherebox), "sincebutton", sincebutton);
	
	// This first kludge makes sure that the value given will be delivered
	// to the next called function.
	gtk_signal_connect(GTK_OBJECT(sincebutton),"activate",
						GTK_SIGNAL_FUNC(gtk_spin_button_update),
						sincebutton);
	gtk_signal_connect(GTK_OBJECT(sincebutton),"activate",
						GTK_SIGNAL_FUNC(update_wherebox),
						wherebox);
	gtk_signal_connect(GTK_OBJECT(sincebutton),"activate",
						GTK_SIGNAL_FUNC(refresh_files),
						flist);

	for(i=0;i<AMOUNT_WHERECLAUSES;i++)
	{
		clause=malloc(PATH_MAX);
		clause[0]=0;
	
		gtk_object_set_data(GTK_OBJECT(wherebox), WhereClauses[i], clause);
	}

	clause=gtk_object_get_data(GTK_OBJECT(wherebox), CLAUSE_FILE);
	sprintf(clause, "file_name LIKE '%%'");

	update_wherebox(NULL, wherebox);
	
	gtk_box_pack_start(GTK_BOX(hbox),wherebox,TRUE,TRUE,0);

/******** Wherebox popup menu ***********/

	popupmenu=gnome_popup_menu_new(whereMenu);
	gnome_popup_menu_attach(popupmenu, wherebox, flist);
	gnome_app_install_menu_hints(GNOME_APP(Bowser), whereMenu);
	

	gtk_object_set_data(GTK_OBJECT(flist), "wherebox", wherebox);

/************ All done **********************************/

	refresh_areas(NULL, alist);
	refresh_files(NULL, flist);

	return(vbox);
}

/* This would be an internal pic viewer. ;)
 *
 * NOT IN USE
 *
void my_view(char *path)
{
	GtkWidget *pix;
	GtkWidget *dlg; 
	int i;

	pix = gnome_pixmap_new_from_file(path);
	dlg=gnome_dialog_new(path,
						GNOME_STOCK_BUTTON_OK,
						NULL);
	gnome_dialog_set_parent(GNOME_DIALOG(dlg), GTK_WINDOW(Bowser));
	gtk_signal_connect(GTK_OBJECT(dlg),"clicked",
						GTK_SIGNAL_FUNC(view_clicked),
						NULL);
	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox),pix,TRUE,TRUE,0);
	gtk_widget_show(pix);

	gtk_widget_show(dlg);

	for(;;) 
	{
		i = gnome_dialog_run(GNOME_DIALOG(dlg));
		if(i == 0) {
			gnome_dialog_close(GNOME_DIALOG(dlg));
			break;
		}
        else 
			if(i < 0)
				break;
	}

	return;
}
*/

static void
view_since_ok(gchar * string, gpointer data)
{
	char buffer[PATH_MAX];

	if(!string)
		return;

	if(atoi(string)>0)
	{
		if(fork()==0)
		{	
			sprintf(buffer, "pv_since %s\n", string);
			system(buffer);
		
			_exit(0);
		}
	}
	else
		my_error_dialog("Wrong number. Dial again.\n");

}

int view_since(void)
{
	gnome_request_dialog(0, "How many days since?", "1", 3, view_since_ok, NULL, GTK_WINDOW(Bowser));

	return(1);
}

/*
 * Kills the selected files. No abort. Creates negative
 * assign patterns.
 *
 */
static void
kill_file(GtkWidget *widget, gpointer data)
{
	char buffer[QUERY_MAX];
	GtkCList *flist=(GtkCList *)data;
	gchar *filename;
	int src_context=0;
	GList *tmp;
	char *value;
	int minassnamelen;
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;

	if(!flist)
		return;

	value=p_getmisc(db, P_KEY_MINASSNAMELEN);
	if(value)
		minassnamelen=atoi(value);
	else
		minassnamelen=atoi(P_MIN_ASS_NAMELENGTH);

	tmp=flist->selection;
	while(tmp)
	{
		int data=(int)tmp->data;
		fileKludge *kludge;
	
		tmp=tmp->next;

		kludge=gtk_clist_get_row_data(flist, data);

		gtk_clist_get_text(flist, data, 0, &filename);

		p_query(db, "SELECT area_context "
			    "FROM p_files, p_areas "
			    "WHERE file_id=%lu AND file_area=area_id",
  		        kludge->file_id);
		sql_res=mysql_store_result(db);
		if(sql_res)
		{
			if((sql_row=mysql_fetch_row(sql_res)))
			{
				src_context=atoi(sql_row[0]);
			}
			mysql_free_result(sql_res);
		}

		p_query(db, "DELETE FROM p_files "
			    "WHERE file_id=%lu",
			kludge->file_id);

		sprintf(buffer, "%s%s%s", 
						kludge->file_path,
						(p_checkp(kludge->file_path) ? "" : "/"),
						filename);
		remove(buffer);

		p_assign(db, filename, minassnamelen, -1, src_context);

		gtk_clist_remove(flist, data);
		
	}

	return;
}

static void 
where_fs_last(GtkWidget *widget, gpointer data)
{
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	char *miscclause;
	GtkWidget *wherebox=gtk_object_get_data(data, "wherebox");
	
	miscclause=gtk_object_get_data(GTK_OBJECT(wherebox), CLAUSE_MISC);

	p_query(db, "SELECT if(misc_data!='', misc_data, NOW()) " 
		    "FROM p_misc "
		    "WHERE misc_key='%s'", 
		P_KEY_VIEW_LAST);
	sql_res=mysql_store_result(db);
	if(sql_res)
	{
		if((sql_row=mysql_fetch_row(sql_res)))
		{
			sprintf(miscclause, "file_date>='%s'",
					sql_row[0]);
		}
		mysql_free_result(sql_res);
	}

	if(miscclause[0])
	{
		update_wherebox(NULL, wherebox);
		refresh_files(NULL, data);
	}

	p_query(db, "REPLACE INTO p_misc (misc_key,misc_data) " 
		    "VALUES ('%s', NOW())",
		  P_KEY_VIEW_LAST);
		
}

/*
 * Frees a fileKludge structure
 *
 */
static void
free_kludge(gpointer data)
{
	static fileKludge *kludge;
	
	kludge=(fileKludge *)data;

//	fprintf(stderr, "FreeK %lu\n", (unsigned long)kludge);
	
	free(kludge->file_path);
	free(kludge);
}

static void
update_wherebox(GtkWidget *widget, gpointer data)
{
	char *tmp;
	char *miscclause;
	char buffer[512];
	int i, first_ok=0;
	unsigned long tmptime;
	GtkWidget *sincebutton;
	GtkWidget *wherebox=(GtkWidget *)data;
	int bloodykludge=0;
	
	if(!wherebox)
		return;

	buffer[0]=0;

	// Overrides the sincebutton
	miscclause=gtk_object_get_data(GTK_OBJECT(wherebox), CLAUSE_MISC);
	if(!miscclause[0])
	{
		sincebutton=gtk_object_get_data(GTK_OBJECT(wherebox), "sincebutton");
		tmptime=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sincebutton));
	
		if(tmptime>0)
		{
			sprintf(miscclause, "file_date>=FROM_UNIXTIME(%lu)", time(NULL)-tmptime*60*60*24);
			bloodykludge=1;
		}
	}
		
	tmp=gtk_object_get_data(GTK_OBJECT(wherebox), CLAUSE_AREA);
//	fprintf(stderr, "DEBUG: %s\n", tmp);

	for(i=0;i<AMOUNT_WHERECLAUSES;i++)
	{
		tmp=gtk_object_get_data(GTK_OBJECT(wherebox), WhereClauses[i]);
		if(tmp && tmp[0])
		{
			if(first_ok)
				strcat(buffer, " AND ");
			
			strcat(buffer, tmp);
			first_ok=1;
		}
	}

	if(bloodykludge)
		miscclause[0]=0;

//	fprintf(stderr, "DEBUG: %s\n", buffer);
	gtk_entry_set_text(GTK_ENTRY(wherebox), buffer);
}

int externcmd(gchar *dummy, gpointer data)
{
	char *command=data;

	createinfowindow(NULL, (void *)1);

	if(fork()==0)
	{
		freopen(FifoFile, "w", stdout);
		freopen(FifoFile, "w", stderr);
		system(command);

		_exit(0);
	}

	return(0);
}
