/*
 * misc func + p_misc table
 *
 */

#include "proto.h"
#include "../src/pimppa.h"

static bowser_column miscDatas[2]=
	{{"misc_key", COLUMN_TEXT, 200, "", NULL},
	 {"misc_data", COLUMN_TEXT, 300, "", NULL}};
static bowser_table miscTable={miscDatas, "p_misc", 2};

GtkWidget *get_misc_box(void)
{
	return(get_table(&miscTable));
}

/*
 * Returns the results of an SQL query in a GList. 
 *
 * Only the first column is returned.
 *
 */
  
GList *get_sql(MYSQL *db, const char *format,...)
{
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	va_list args;
	char query[QUERY_MAX];
	GList *glist=NULL;

	va_start(args, format);
	vsnprintf(query, QUERY_MAX, format, args);
	va_end(args);

	mysql_query(db, query);
	if(mysql_error(db)[0])
	{
		fprintf(stderr, "SQL error: %s\n", mysql_error(db));
		return(NULL);
	}
	if(!(sql_result=mysql_store_result(db)))
		return(NULL);

	while((sql_row=mysql_fetch_row(sql_result)))
	{
		gchar *tmp;

		tmp=malloc(strlen(sql_row[0])+1);
		strcpy(tmp, sql_row[0]);
	
		glist=g_list_append(glist, tmp);
	}
	mysql_free_result(sql_result);

	return(glist);
}

void clear_glist(GtkWidget *widget, gpointer data)
{
	GList *glist=(GList *)data;

	while(glist)
	{
		free(glist->data);
		glist=g_list_next(glist);
	}
	
	g_list_free((GList *)data);
}

void select_all(GtkWidget *dummy, GtkWidget *list)
{
    if(list)
        gtk_clist_select_all(GTK_CLIST(list));
}

void unselect_all(GtkWidget *dummy, GtkWidget *list)
{
    if(list)
        gtk_clist_unselect_all(GTK_CLIST(list));
}


