/*
 * Preferences
 *
 */

#include "proto.h"

static int PrefsActive=0;

static void
prefs_quit(GtkWidget *widget, gpointer data)
{
	PrefsActive=0;

	gtk_widget_destroy(widget);
}
	
void preferences(void)
{
	GtkWidget *vbox, *label, *notebook, *dialog, *tmp;

	if(PrefsActive)
	{
		my_error_dialog("You already have prefs open\n");
		return;
	}
	else
		PrefsActive=1;

	dialog=gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), _("Preferences"));
	gtk_container_border_width (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), 10);
	gtk_container_border_width (GTK_CONTAINER
                  (GTK_DIALOG (dialog)->action_area), 5);
	gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 2);
	gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->action_area), 15);
	gtk_box_set_homogeneous (GTK_BOX (GTK_DIALOG (dialog)->action_area), TRUE);
	gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
	gtk_signal_connect_object (GTK_OBJECT (dialog), "delete_event",
                 GTK_SIGNAL_FUNC (prefs_quit),
                 GTK_OBJECT (dialog));
	gtk_signal_connect_object (GTK_OBJECT (dialog), "destroy",
                 GTK_SIGNAL_FUNC (prefs_quit),
                 GTK_OBJECT (dialog));
	gtk_widget_set_usize(dialog,640,480);

  notebook = gtk_notebook_new ();
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), notebook, TRUE,
              TRUE, 0);

/****** Fileareas ********************/
	
	tmp=note_dialog("Loading filearea list...\n");
	vbox=get_areas_box();
	label=gtk_label_new("Fileareas");
    gtk_notebook_append_page(GTK_NOTEBOOK (notebook), vbox, label);
	gtk_widget_destroy(tmp);

/****** Newsgroups *******************/

	tmp=note_dialog("Loading newsgroup list...\n");
	vbox=get_groups_box();
	label=gtk_label_new("Newsgroups");
    gtk_notebook_append_page(GTK_NOTEBOOK (notebook), vbox, label);
	gtk_widget_destroy(tmp);

/****** Contexts *******************/

	tmp=note_dialog("Loading context list...\n");
	vbox=get_contexts_box();
	label=gtk_label_new("Contexts");
    gtk_notebook_append_page(GTK_NOTEBOOK (notebook), vbox, label);
	gtk_widget_destroy(tmp);

/****** Types page ****************/

	tmp=note_dialog("Loading filetype list...\n");
	vbox=get_types_box();
	label=gtk_label_new("Filetypes");
    gtk_notebook_append_page(GTK_NOTEBOOK (notebook), vbox, label);
	gtk_widget_destroy(tmp);

/****** Assigns page **************/

	tmp=note_dialog("Loading assign pattern list...\n");
	vbox=get_assigns_box();
	label=gtk_label_new("Assigns");
    gtk_notebook_append_page(GTK_NOTEBOOK (notebook), vbox, label);
	gtk_widget_destroy(tmp);

/****** Servers page *************/
	
	tmp=note_dialog("Loading server list...\n");
	vbox=get_server_box();
	label=gtk_label_new("Servers");
    gtk_notebook_append_page(GTK_NOTEBOOK (notebook), vbox, label);
	gtk_widget_destroy(tmp);
	
/****** Rules page ****************/

	tmp=note_dialog("Loading rule list...\n");
	vbox=get_rules_box();
	label=gtk_label_new("Rules");
    gtk_notebook_append_page(GTK_NOTEBOOK (notebook), vbox, label);
	gtk_widget_destroy(tmp);


/****** Misc page ****************/

	tmp=note_dialog("Loading p_misc table...\n");
	vbox=get_misc_box();
	label=gtk_label_new("Miscellaneous");
    gtk_notebook_append_page(GTK_NOTEBOOK (notebook), vbox, label);
	gtk_widget_destroy(tmp);

	gtk_notebook_set_page (GTK_NOTEBOOK(notebook), 0);
    gtk_widget_show (notebook);

/******* Buttons ******************/

  tmp = gtk_button_new_with_label (_("OK"));
  GTK_WIDGET_SET_FLAGS (tmp, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), tmp,
              TRUE, TRUE, 0);
  gtk_signal_connect_object (GTK_OBJECT (tmp), "clicked",
                 GTK_SIGNAL_FUNC (gtk_widget_destroy),
                 GTK_OBJECT (dialog));
  gtk_widget_show (tmp);

  gtk_widget_show_all(dialog);
}

