#!/usr/bin/perl
#  make_source_tree.pl
#    $Last modified: Wed Apr 19 03:25:36 2000$
#                   Copyright (c) 1999 kamop
#  $Id: make_source_tree.pl,v 1.1 1999/12/06 09:50:15 kamop Exp $
# 
use strict;
use FileHandle;
use KDEB;

my($kdeb) = new KDEB;

#my($alias) = {};
#$alias->{'lsof-2.2'} = 'lsof';

## եɤ߹
my($conf_file) = $ARGV[0];
if(! -f $conf_file){
  die "No such input file $conf_file.";
}
my($fileconf_debug) = 0;
my($conf) = $kdeb->conf_read(file=>$conf_file,
                             debug=>$fileconf_debug);

my($debug) = $conf->{"make_source_debug"};

## ѥåեɤ߹
my($pacf) = $kdeb->PACF_new(conf=>$conf);
$kdeb->PACF_read_packages(PACF=>$pacf);

##
my($dsc_file) = $conf->{"dsc_file"};
my($lst_file) = $conf->{"expand_file"};
my($res, $fhin);
($fhin, $res) = $kdeb->open_file(file=>$dsc_file);
my($dsc);
$dsc = $kdeb->DSC_read(fh=>$fhin);
$fhin->close();


my($dsc_correct) = {};
my($package, $section);
($fhin, $res) = $kdeb->open_file(file=>$conf->{'dsc_correct'});
while(<$fhin>){
  chomp;
  next if(/^$/);
  ($package, $section) = split(/\s+/, $_);
  $dsc_correct->{$package} = $section;
} ## while
$fhin->close();


my($fhout);
($fhin, $res) = $kdeb->open_file(file=>$lst_file);
($fhout, $res) = $kdeb->open_file(file=>"> ".$conf->{"script_src"});

my($check) = {};
my($total_size) = 0;
my($goukei) = 0;
my($bin, $src);
my($tag_bin);
my($tag_size);
my($tag_filenames);
my($tag_version);
my($i);
my($file, $dir, $arch, $section, $debfile, $dscfile);
my($dir, $base_dir);
my($info, $section);
my($to_dir, $from_dir, $real_to_dir, $real_from_dir);
&output_header(fhout=>$fhout, PACF=>$pacf);
my($check_dir) = {};
while(<$fhin>){
  chomp;
  next if((/^\#/) || (/^$/));
  $bin = $_;
  print STDERR "Check '$bin'\n" if($debug & 1);
  ($res, $info, $file) = $kdeb->PACF_get_info
    (PACF=>$pacf, name=>$bin, info=>'source');
  if($res == 1){
    $src = $info;
    $src =~ s/(\S+)\s+.*/$1/;
  }else{
    $tag_bin = $kdeb->DSCN_binname(name=>$bin);
    $src = $dsc->{$tag_bin};
  }
  if($src eq ''){
#    if($alias->{$tagbin} eq ""){
      print STDERR "There is not '".$bin."'.\n";
#      die;
      next;
#    }else{
#      $src = $alias->{$tagbin};
#    }
  }
#  print STDERR "$src\n";
  next if($check->{$src} == 1);
  $tag_filenames = $kdeb->DSCN_filenames(name=>$src);
  ($res, $file, $info) = $kdeb->PACF_get_info(PACF=>$pacf, name=>$bin,
                                              info=>'Filename');
  $base_dir = $pacf->[$info]->{"base_dir"};
  $file =~ /(.*)\/([^\/]+)\/([^\/]+)\/([^\/]+)$/;
  $dir = $1;
  $section = $3; ## only check for non-US for slink
  print STDERR "$dir $section $file\n";
  ## Copy tar.gz and diff.gz
  for($i = 0; $i <= $#{$dsc->{$tag_filenames}} ;$i++){
    $file = $dsc->{$tag_filenames}->[$i]->{'name'};
    $goukei += $dsc->{$tag_filenames}->[$i]->{'size'};
    ## ONLY slink
    if($section eq "binary-i386"){
      ## slink
#      $from_dir = "$base_dir/dists/frozen/non-US/source";
#      $to_dir = "$base_dir/dists/frozen/non-US/source";
      ## potato
#      $from_dir = "$base_dir/dists/potato/non-US/".$dir."source";
#      $from_dir = "$base_dir/dists/potato/non-US/main/source";
      ## woody
      $from_dir = "$base_dir/dists/woody/non-US/main/source";
      $to_dir = $from_dir;
    }else{
      if($dsc_correct->{$src} ne ''){
        print STDERR "$src :: $section ->".$dsc_correct->{$src}."\n";
        $section = $dsc_correct->{$src};
      }
      $to_dir = $from_dir = $base_dir."/".$dir."/source/".$section;
    }
    $real_to_dir = "\$\{TO_DIR\}/$to_dir";
    $real_from_dir = "\$\{FROM_DIR\}/$to_dir";
    if($check_dir->{$to_dir} eq ""){
      $check_dir->{$to_dir} = "OK";
      print $fhout "if [ ! -x $real_to_dir ]; then\n";
      print $fhout "  mkdir -p $real_to_dir\n";
      print $fhout "fi\n\n";
    }
    print $fhout "cp $real_from_dir/$file $real_to_dir/\n";
#    print $fhout "echo $file ".$dsc->{$tag_filenames}->[$i]->{'size'} . "  ".
#      "`ls -la $real_from_dir/$file | awk '\{print \$5;\}'`\n";
#    print $fhout "\n";
#    print STDERR "$to_dir/$file  ".$dsc->{$tag_filenames}->[$i]->{'size'}."\n";
  } ## for($i)
  ## Copy .dsc
  $tag_version = $kdeb->DSCN_version(name=>$src);
  $dscfile = $src."_*.dsc";
  print $fhout "cp $real_from_dir/$dscfile $real_to_dir/\n";
  print $fhout "\n";
  $check->{$src} = 1;
  $tag_size = $kdeb->DSCN_totalsize(name=>$src);
  $total_size += $dsc->{$tag_size};
} ## while(<>)
print $fhout "# SIZE: ".$total_size." $goukei\n";
$fhin->close();
$fhout->close();
print STDERR "Total size is ", $total_size,"\n";
exit;

#######################################################################
#######################################################################
#######################################################################
sub output_header{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($fhout) = $ref{'fhout'};
  my($pacf) = $ref{'PACF'};
##
  print $fhout "#!/bin/sh\n";
  print $fhout "\n";
  print $fhout "FROM_DIR=".$conf->{"from_dir"}."\n";
  print $fhout "TO_DIR=".$conf->{"to_dir"}."\n";
  print $fhout "\n\n";

} ## output_header()
