/***************************************************************************
 *   Copyright (C) 2005,2006,2007 by Siraj Razick                          *
 *   siraj@kdemail.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#include "ciavc.h"

#include <math.h>

#include <QApplication>
#include <QBitmap>
#include <QGraphicsScene>
#include <QMatrix>
#include <QPaintEvent>
#include <QPainter>
#include <QPixmap>
#include <QStyleOptionGraphicsItem>
#include <QDialog>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QCheckBox>
#include <QPushButton>

#include <KDebug>
#include <KLocale>
#include <KIcon>
#include <KSharedConfig>

#include <plasma/svg.h>
#include <plasma/widgets/vboxlayout.h>
#include <plasma/widgets/lineedit.h>

CiaVc::CiaVc(QObject *parent, const QVariantList &args)
    : Plasma::Applet(parent, args) //"plasma-clock-default", appletId)
{
    //setHasConfigurationInterface(true);
    m_engine = dataEngine("ciavc");

    m_layout = new Plasma::VBoxLayout(0);
    m_layout->setGeometry(QRectF(0, 0, 400, 800));
    m_layout->setMargin(12);

    setDrawStandardBackground(true);

    //TODO: make configurable
    sourceAdded("KDE");
    connect(m_engine, SIGNAL(newSource(QString)), this, SLOT(sourceAdded(QString)));
    connect(m_engine, SIGNAL(sourceRemoved(QString)), this, SLOT(sourceRemoved(QString)));
}

CiaVc::~CiaVc()
{
    delete m_layout;
}

QSizeF CiaVc::contentSizeHint() const
{
    return m_layout->geometry().size();
}

void CiaVc::sourceAdded(const QString& source)
{
    Plasma::LineEdit* text = new Plasma::LineEdit(this);
    text->setTextInteractionFlags(Qt::TextSelectableByMouse|Qt::TextSelectableByKeyboard);
    text->setObjectName(source);
    kDebug() << "added " << text->objectName() << " with expandings " << text->expandingDirections();
    m_engine->connectSource(source, text);
    m_layout->addItem(text);
}

void CiaVc::sourceRemoved(const QString& source)
{
    foreach (QGraphicsItem * child, QGraphicsItem::children()) {
        Plasma::LineEdit * text = dynamic_cast<Plasma::LineEdit*>(child);
        if (!text) {
            continue;
        }

        if (text->objectName() == source) {
            delete text;
        }
        return;
    }
}

void CiaVc::showConfigurationInterface()
{
    //TODO: implement configuration of projects
}

void CiaVc::acceptedConfigDialog()
{
    //KConfigGroup cg = globalConfig();
    //TODO: implement configuration of projects
}

void CiaVc::paintInterface(QPainter *p, const QStyleOptionGraphicsItem *option, const QRect &contentsRect)
{
    Q_UNUSED(option);

}

#include "ciavc.moc"
