/*
 *   Copyright (C) 2007 Matt Broadstone <mbroadst@kde.org>
 *   Copyright (C) 2007 Matias Costa <m.costacano@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef DESKTOPORGANIZER_H
#define DESKTOPORGANIZER_H

#include <QList>
#include <QGraphicsItem>

class StandardDesktop;
class Launcher;

class DesktopOrganizer
{
public:
    enum Organizer { Vertical=0, Horizontal = 1 };
    enum Sort {NameCaseSensitive = 0, NameCaseInsensitive = 1, Size = 2, Type = 3, Date =4 };

    DesktopOrganizer(StandardDesktop *desktop, Organizer type = Vertical );
    virtual ~DesktopOrganizer();

    void organize(const QList<Launcher*> &items);
    void changeAlignment( Organizer type);

    bool sortDirectoriesFirst() const;
    void setSortDirectoriesFirst(bool b);

protected:
    void alignVertical(const QList<Launcher*> &items);
    void alignHorizontal(const QList<Launcher*> &items);

private:
    StandardDesktop *m_desktop;
    Organizer m_type;
    bool m_bSortDirectoriesFirst:1;
};

#endif

