/*
 *   Copyright (C) 2007 Matt Broadstone <mbroadst@kde.org>
 *   Copyright (C) 2007 Matias Costa <m.costacano@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include <QApplication>
#include <QPainter>
#include <QTextOption>
#include <QStyleOptionGraphicsItem>
#include <QGraphicsView>
#include <QGraphicsScene>

#include <KDesktopFile>
#include <KIconLoader>
#include <KGlobal>
#include <KGlobalSettings>
#include <KStandardDirs>
#include <KDebug>
#include <KFileItem>

#include <plasma/svg.h>
#include "plasmadesktopsettings.h"

#include "launcher.h"
#include "launcher.moc"

Launcher::Launcher(QGraphicsItem *parent)
    : Plasma::Icon(parent),m_iconMoved(false)
{
    setFlag(QGraphicsItem::ItemIsMovable, PlasmaDesktopSettings::lockIcons);
    setFlag(QGraphicsItem::ItemClipsToShape, true);
    setFlag(QGraphicsItem::ItemIsSelectable, true);
    setFlag(QGraphicsItem::ItemIsFocusable, true);
    int sz = KIconLoader::global()->currentSize( K3Icon::Desktop );
    setIconSize(sz, sz);
}

Launcher::~Launcher()
{
}

void Launcher::lockIcon(bool lock)
{
   setFlag(QGraphicsItem::ItemIsMovable, lock);
}

void Launcher::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
{
    if (!KGlobalSettings::singleClick())
        launch();

    Icon::mouseDoubleClickEvent(event);
}
void Launcher::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
{
    m_iconMoved = true;
    Icon::mouseMoveEvent(event);
}

void Launcher::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    m_iconMoved = false;
    Icon::mousePressEvent(event);
}

void Launcher::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
{
    if (KGlobalSettings::singleClick() && !m_iconMoved)
        launch();

    Icon::mouseReleaseEvent(event);
}

// Silly little helper
QString fileName(const QString &name)
{
    QString base = name.split(".")[0];
    return base;
}

FileLauncher::FileLauncher(KFileItem *file, QGraphicsItem *parent)
    : Launcher(parent),
      m_fileItem(file)
{
    if (KDesktopFile::isDesktopFile(file->name()))
    {
        KDesktopFile tmp(file->localPath());
        QString iconPath = tmp.readIcon();
        setIcon(iconPath);
    }
    else
        setIcon(m_fileItem->iconName());

    setText(fileName(m_fileItem->name()));
}

FileLauncher::~FileLauncher()
{
}

void FileLauncher::launch()
{
    QGraphicsView *parentView = 0;

    QList<QGraphicsView*> viewsToCheck = scene()->views();
    foreach (QGraphicsView *view, viewsToCheck)
    {
        if (view->items().contains(this))
        {
            parentView = view;
            break;
        }
    }

    if (parentView)
        m_fileItem->run(parentView);
}


DeviceLauncher::DeviceLauncher(const QString &udi, QGraphicsItem *parent)
    : Launcher(parent),
      m_device(udi)
{
    setIcon(m_device.icon());

    if (m_device.vendor().isEmpty())
        setText(m_device.product());
    else
        setText(m_device.vendor() + ' ' + m_device.product());
}

DeviceLauncher::~DeviceLauncher()
{
}


void DeviceLauncher::launch()
{
    kDebug() << "launch with dolphin or something..";
}

