/***************************************************************************
 *   Copyright (C) 2007 by Anne-Marie Mahfouf <annma@kde.org>              *
 *   Copyright (C) 2007 by Stephan Binner <binner@kde.org>                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#ifndef GROUPPHOTO_H
#define GROUPPHOTO_H

#include <QPaintDevice>
#include <QLabel>
#include <QPixmap>
#include <QPaintEvent>
#include <QPainter>
#include <QGraphicsItem>
#include <QColor>

#include <plasma/applet.h>
#include <plasma/dataengine.h>
#include <plasma/widgets/lineedit.h>

#include "ui_config.h"

class KDialog;
class QGraphicsSceneDragDropEvent;
class Kurl;
class QTimer;

namespace Plasma
{
    class Svg;
    class Layout;
}

// Widget to show search hits in the group photo
class HitBox : public QObject, public QGraphicsItem
{
    Q_OBJECT
    public:
        HitBox(QGraphicsItem *parent, const QString& name, int width);
        ~HitBox();

        QRectF boundingRect() const;

    private:
        int m_width;
	Plasma::LineEdit *m_label;
        void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
};

class Groupphoto : public Plasma::Applet
{
    Q_OBJECT
    public:
        Groupphoto(QObject *parent, const QVariantList &args);
        ~Groupphoto();

        void paintInterface(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect &contentsRect);
	QSizeF contentSizeHint() const;

    public slots:
        void updated(const QString &name, const Plasma::DataEngine::Data &data);
        void showConfigurationInterface();

    protected Q_SLOTS:
	void dropEvent(QGraphicsSceneDragDropEvent *event);
	void dragEnterEvent(QGraphicsSceneDragDropEvent *event);
	void resizeEvent( QResizeEvent * );
	void configAccepted();
	void choosePicture();
 
        void search();
        void autoSearch(const QString &word);
        void hoverMoveEvent(QGraphicsSceneHoverEvent *event);

    private:
	void composePicture();
	/// The current color of the frame
        QColor m_frameColor;
        KDialog *m_dialog; //should we move this into another class?
	/// true if the user wants a frame. If false, there's only the black border around the picture
	bool m_frame;
	/// If true, the frame will have squared corners
	bool m_squareCorners;
	/// If true, the frame will have round corners 
	bool m_roundCorners;
	/// If true, the picture will have a drop shadow.
	bool m_shadow;
	/// true if the user wants Wikipedia Picture of the Day
	bool m_potd;
	/// Stores the current picture URL. Wikipedia Picture of the Day is default.
	KUrl m_currentUrl;
	/// The current picture
	QPixmap myPicture;
	/// Off-Screen pixmap
	QPixmap *m_cmpPicture;
	Plasma::Layout *m_layout;
	/// The size of the picture, it's max(width, height) that is set
	int m_pixelSize;
	/// Rotation angle & transformation matrix
	int m_rotation;
	
	/// Designer Config file
	Ui::config ui;

        // necessary definitions for groupphoto extension
        struct _person {
           QString      name;
           int          x,y,width;
        };

        void readNames();
        QList<_person*> m_personList;
        QList<HitBox*> m_hitboxList;
	Plasma::LineEdit *m_searchEdit;
   
        QPointF m_oldPos;
        QTimer* m_timer;

        int m_year;
};

K_EXPORT_PLASMA_APPLET(groupphoto, Groupphoto)

#endif
