/***************************************************************************
 *   Copyright (C) 2007 by Alex Merry <alex.merry@kdemail.net>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

#include "testapplet.h"

#include <QPainter>

#include <plasma/svg.h>
#include <plasma/widgets/vboxlayout.h>
#include <plasma/widgets/lineedit.h>

class LimitedLineEdit : public Plasma::LineEdit
{
public:
    explicit LimitedLineEdit(QGraphicsItem *parent = 0, QGraphicsScene *scene = 0)
        : Plasma::LineEdit(parent, scene)
        , m_height(300)
    {
    }
    QRectF boundingRect()
    {
        QRectF rect(Plasma::LineEdit::boundingRect());
        rect.setHeight(m_height);
        return rect;
    }
    void setHeight(qreal height)
    {
        m_height = height;
    }
private:
    qreal m_height;
};

TestApplet::TestApplet(QObject *parent, const QVariantList &args)
    : Plasma::Applet(parent, args)
    , m_edit( new LimitedLineEdit(this) )
    , m_svg( 0 )
{
    setDrawStandardBackground(true);

    m_edit->setMultiLine(true);
    m_edit->setTextWidth(300);
    m_edit->setHeight(200);

    //m_svg = new Plasma::Svg("widgets/wallpaper", this);
    //m_svg->resize(640,480);
    //kDebug() << "SVG size: " << m_svg->size();

    connect(m_edit, SIGNAL(textChanged(QString)), this, SLOT(editUpdate(QString)));
}

TestApplet::~TestApplet()
{
}

void TestApplet::editUpdate(const QString&)
{
    prepareGeometryChange();
}

QSizeF TestApplet::contentSizeHint() const
{
    //return QSizeF(300, 300);
    return m_edit->sizeHint();
    //return m_svg->size();
}


void TestApplet::paintInterface(QPainter *p, const QStyleOptionGraphicsItem *option, const QRect &contentsRect)
{
    Q_UNUSED(option)
    //p->setPen(Qt::blue);
    //p->drawRoundRect(contentsRect);
    //m_svg->paint(p, contentsRect.topLeft());
}

#include "testapplet.moc"
