/*
 *   Copyright © 2007 Fredrik Höglund <fredrik@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef CLIPBOARDENGINE_H
#define CLIPBOARDENGINE_H

#include <plasma/dataengine.h>

class ClipboardPoll;

class ClipboardEngine : public Plasma::DataEngine
{
    Q_OBJECT

public:
    ClipboardEngine(QObject* parent, const QVariantList& args);
    ~ClipboardEngine();

    QStringList sources() const;

protected:
    void init();

private slots:
    void clipboardChanged(bool selectionMode);

private:
    static void updateTimestamp();
    ClipboardPoll *poll;

    friend class ClipboardPoll;
};

#endif
