/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_SPINX_MENU_WIDGET_H
#define KBFX_SPINX_MENU_WIDGET_H

#include <qwidget.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <QtGui/QMouseEvent>
//#include <kbfxplasmalistview.h>
//#include <kbfxdatasource.h>
#include <q3canvas.h>
#include <kbfxplasmacanvasview.h>
#include <kbfxplasmacanvasgroup.h>
#include <kbfxplasmapluginloader.h>
//#include <kbfxplasmalistbox.h>
#include <qframe.h>
#include <qstringlist.h>
#include "kbfxspinxtop.h"
#include "kbfxspinxscrollbar.h"
#include <kbfxdatastack.h>
#include <qlineedit.h>
#include <kbfxplasmaindexview.h>
#include <kbfxpixmaplabel.h>
#include <kbfxconfig.h>
#include "kbfxspinxtoolbar.h"


class KbfxSpinxMenuWidget:public QWidget
{
		Q_OBJECT
	public :
		KbfxSpinxMenuWidget ( QWidget * parent = 0, const char * name = 0, Qt::WindowFlags fl =0 );
		virtual	~KbfxSpinxMenuWidget();
//        virtual void mouseMoveEvent(QMouseEvent * me);
//	virtual void focusInEvent ( QFocusEvent * ) ;
		virtual void keyPressEvent ( QKeyEvent * e ) ;
		void grabEvent ( QKeyEvent * e ) { keyPressEvent ( e );}
		void loadHistory();
		void resizeContent();

	public slots:
		void hideMenu();
//	void propergateMove(QMouseEvent * me);
		void loadPluginLeft ( QString name );
		void loadPluginRight ( QString name );
		void enterPressed();
		void search_clear ( Qt::MouseButton );
//	void changeHeight(int h);
	signals:
		void nowHidden();
		void runItem();
		void runItemAt ( int i );
		void leads();

	private:
		QPoint menuPosition();
		void createMask();
		KbfxPlasmaCanvasView * m_canvasView;
//	KbfxPlasmaCanvasView * m_indexView;
		Q3Canvas * m_canvas ;
		//KbfxPlasmaListBox * m_listBox;
		KbfxPlasmaPluginLoader * m_loader;
		KbfxSpinxTop * m_menuTop;
		QString m_loadedList;
		KbfxSpinxScrollBar * m_barTop;
		KbfxSpinxScrollBar * m_barBot;
//FIXME:
//canvasstack is  is depricated Interface
		KbfxPlasmaCanvasStack * m_stack;
		KbfxDataStack * m_stack_R;
		QWidget * m_parent;
		QLineEdit  * m_search;
		KbfxPixmapLabel * m_searchTag;
		KbfxSpinxToolBar * m_toolBarBot;
		KbfxSpinxToolBar * m_toolBarSide;
		int m_h;

//////SUPER NEW LAYOUT FIX HERE//////////

		QBoxLayout * m_fixedFrame;
		QBoxLayout * m_middleFrame;
		Q3Canvas  * m_appCanvas;
		Q3Canvas  * m_indexCanvas;
		Q3Canvas  * m_indexLeftCanvas;

		KbfxPlasmaIndexView * m_indexView;

		KbfxPlasmaIndexView * m_indexLeftView;
		KbfxSpinxTop * m_kbfxSpinxTop;

};

#endif
