/**************************************************************************
*   Copyright (C) 2006 by Riccardo Iaconelli  <ruphy@fsfe.org>            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include <kapplication.h>
#include <kaboutdata.h>
#include <kdebug.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kguiitem.h>

#include <uploader.h>

int main ( int argc, char *argv[] )
{
    KAboutData aboutData("plasmagik", "plasmagik", ki18n("Plasmagik"),
                         "0.1", ki18n("A \"magic\" packager for application add ons"),
                         KAboutData::License_GPL,
                         ki18n("(c) 2006, Riccardo Iaconelli"), KLocalizedString(), "http://plasma.kde.org/",
                         "ruphy@fsfe.org" );
    aboutData.addAuthor(ki18n("Riccardo Iaconelli"), KLocalizedString(), "ruphy@fsfe.org");

    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineOptions options;
    options.add("s", ki18n("Speed up testing by autofilling in the fields"));
    KCmdLineArgs::addCmdLineOptions( options );
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    KApplication app;

    KNS::Uploader o("test");
//     o.setContentTypes( "|C++|Python|Java|Javascript" );
    o.setPackageType("Artwork");

    if ( args->isSet( "s" ) ) {
        o.fillFields();
        kDebug() << "filled in the fields";
    }
    o.show();
    return app.exec();
}
