#include <stdlib.h>
#include <string.h>

#include "sys/wcetrace.h"
#include "sys/fixpath.h"


#define IS_DIRECTORY_SEP(X) (X == '\\')
#define IS_ANY_SEP(X) (X == '\\')


/* This is from emacs... */
static char *
_canonicalizepath(char *target)
{
  char *p = target;
  char *o = target;

  while (*p) {
    if (!IS_DIRECTORY_SEP(*p)) {
      *o++ = *p++;
    } else if (IS_DIRECTORY_SEP(p[0]) && p[1] == '.'
               && (IS_DIRECTORY_SEP(p[2]) || p[2] == 0)) {
      /* If "/." is the entire filename, keep the "/".  Otherwise just delete the whole "/.".  */
      if (o == target && p[2] == '\0')
        *o++ = *p;
      p += 2;
    } else if (IS_DIRECTORY_SEP(p[0]) && p[1] == '.' && p[2] == '.'
               /* `/../' is the "superroot" on certain file systems.  */
               && o != target && (IS_DIRECTORY_SEP(p[3]) || p[3] == 0)) {
      while (o != target && (--o) && !IS_DIRECTORY_SEP(*o));

      /* Keep initial / only if this is the whole name.  */
      if (o == target && IS_ANY_SEP(*o) && p[3] == 0)
        ++o;
      p += 3;
    } else {
      *o++ = *p++;
    }
  }

  *o = 0;

  return target;
}


void
fixpath(const char *pathin, char *pathout)
{
  char *cp;

  if (pathin == NULL || pathout == NULL) {
    return;
  }
   
  strcpy(pathout, pathin);
  for (cp = pathout; *cp; cp++) {
    if (*cp == '/')
      *cp = '\\';
  }

  /* disallow slash at end of directory name */
  if (cp[-1] == '\\' && cp != pathout + 1)
    cp[-1] = 0;

  /* now remove . and .. */
  _canonicalizepath(pathout);

  return pathout;
}
