/*
  Python dictionary pretty printing.
  Copyright (C) 2005 The MITRE Corporation

  Author: John D. Ramsdell

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  After initializing the pretty printer, Python values are constructed
  and then printed.  A Python value is either a string or a dictionary
  containing an unordered sequence of key-value entries.  The key is a
  string.  If initialized with the string "pyval", the print function
  generates a textual representation of the Python value prefixed by
  the string "pyval(", and followed by the string ")".  A Python
  script can use execfile to read the generated data after providing a
  definition for the function pyval.
*/

#if !defined PYVAL_H
#define PYVAL_H

typedef struct pyval *pyval_t;

/* Set the Python function to be called with the printed dictionary.
   Call this before building any Python dictioraries. */
void pyval_init(const char *function);

/* Construct a string value.  Returns null if given it. */
pyval_t pyval_string(const char *value);

/* Construct an empty dictionary. */
pyval_t pyval_dictionary(void);

/* Add a key value entry to a dictionary.  Returns null if given a bad
   argument. */
pyval_t pyval_entry(const char *key, pyval_t value, pyval_t dictionary);

/* Print Python value.  Return zero on success.  In all cases, the
   memory allocated for the Python value is freed. */
int pyval_print(FILE *out, pyval_t value, int margin);

#endif
