from util import *
import config
import sys
import gen
from pres_util import *
import recog_domain
import patterns
import specs
import pr
from futil import reads_from, writes_to, execs

#################### Recognition Results ####################




def gen_recog_results_browser (finalp = 1):
    """ creates web-page showing all pattern instances"""
    prgm = get_current_program()
    fileid  = "Pattern-Instances.html"
    fileStr = config.result_file(fileid)
    out = open(fileStr, "w")
    #print "Writing to " + fileStr
    top_of_file(out, "Pattern Instances for " + capitalize_it(prgm.name))
    out.write("</font><a name = top>")
    create_pattern_type_list(out)
    for uid in [p.uid for p in pr.pattern_assertions.values() ]:
        out.write('<a href=#' + uid + '>' + uid + '</a> ---')
    for patStr in patterns.PATTERN_TYPES:
        patobj = eval('patterns.' + patStr)
        found = the_pattern_instances(patStr)
        if len(found) > 0:
            out.write("<hr><hr><table><tr><td width = 70%>")
            card_char = "s"
            if len(found) == 1:
                card_char = ""
            out.write("<a name =" + patStr + "> " \
                  + "<h1><font color = 008000>" + patStr + "</font></h1><font size = 3>"\
                      + str(len(found)) + "<b> " + patobj.participants[0] + " tree" +  card_char + \
                      " found </font>")
            objs = []
            if finalp:
                values = pr.pattern_assertions_final.values()
            else:
                values = pr.pattern_assertions.values()
            for v in values:
                if v.pattern.name == patStr:
                    objs.append(v)
            good = [o for o in objs if o.accepted == 1]
            out.write(";" + str(len(objs)) + " constellations.  <br> \n")
            # pattern_assertions used to establish all allow statements
            # pattern instances might contain aggregations
            top_count = 0
            for obj in objs:
                top_count = top_count + 1
                if finalp and obj.accepted == 1: 
                    out.write('<hr><h3><font color = 0066ff> ' + str(top_count) + '.) Accepted</h3>')
                elif not finalp:
                    if obj.treat_as in [specs.Violator, specs.OutOfScope]:
                        out.write('<hr><h3><font color = 669900> ' + str(top_count) + '.) Rejected - not sufficient evidence</h3>')
                    else:
                       out.write('<hr><h3><font color = 0066ff> ' + str(top_count) + '.) Accepted</h3>') 
                else: # finalp and rejected
                    out.write('<hr><h3><font color = 669900> ' + str(top_count) + '.) Rejected - user choice or not sufficient evidence</h3>')
                allow_char = "s"
                if len(obj.evidence) == 1:
                    allow_char = ""
                out.write("<a name =" + str(obj.uid) + "> " \
                      + "<h3><font color = 008000>" + str(obj.uid) + ":" + str(obj.print_form) + \
                          "</font></h3><font size = 3>(covers " + str(len(obj.evidence)) + \
                          " allow path" + allow_char + \
                          " )</font>")
                count = 0
                for e in obj.evidence: # a uid for a PatternR
                    count = count + 1
                    out.write('<br> ----' + str(top_count) + '.' + str(count) + '.) ')
                    e_obj = pr.all_pattern_realizations[e]
                    participant_roles = patobj.participants
                    for p_role in participant_roles:
                        filler = e_obj.__dict__[p_role]
                        out.write(p_role + ":" + obj2href(filler) + ' <br>')
                out.write('</font>')
            out.write('</td> \
                             <td><img src = "images/%s.gif" \
                                      width="470" height="276"> \
                             </td></tr></table>' % patobj.name.lower())
    out.close()
     
def spec2html (out, recog):
    """ out = stream; key = name of recognizer; fileid = prgm-version.html
    creates html table for pattern instances """
    key = recog.__name__
    instances = PRGM.pattern_instances[key]
    out.write("\n<a name = " + key + "> \n" + \
              "<h3>" + key + "</h3>")
    out.write("For pattern " + recog.pattern.name + "\n")
    out.write("<br>Detection level = " + recog.detection + "\n")

    for inst in instances:
       show_instance(out, inst)
    if len(instances) > 0:
        out.write("\n")

def show_instance(out, inst):
    out.write("<br>")
    show_instance_helper(out, inst, 0, 0)

def show_instance_helper(out, accum, level, bqClose):
    if accum == None:
        out.write("<br> Found None")
    if accum.__class__.__name__ == "Aggr":
        for e in accum.elements:
            out.write("<br>" + dashes(level) + obj2href(e.focus) + "<br> \n")
        return
    role = accum.pattern_role
    if role == 'obj':
        role = accum.recognizer.focus_name
    nbr_str = "%d)" % accum.nbr
    color = '500000'
    if level == 0:
        color = '800080'
        if accum.nbr > 1:
            out.write("\n")
        out.write(nbr_str + " \n")
    out.write("<br>" + dashes(level) + obj2href(accum.focus)\
              + " : <font color = " + color + ">" + role + "</font>")
    if (bqClose > 0):
        out.write("\n")
    collabs = accum.with
    if not empty(collabs):
         if level == 0:
            out.write("\n")
         for coll in collabs.keys():
            out.write('<br>' + dashes(level) + "With " + coll + ":\n")
            for c in collabs[coll]:
                show_instance_helper(out, c, level + 4, 1)
            out.write("\n")

def create_pattern_type_list (strm):
    patterns.PATTERN_TYPES.sort()
    strm.write('<center>Number of pattern focii<br>')
    strm.write('<table><tr>')
    count = 0
    for p in patterns.PATTERN_TYPES: 
        nbr = len(the_pattern_instances(p))
        count = count + 1
        if count == 4:
            count = 0
            strm.write('</tr>')
        ref_char = ""
        if nbr == 0:
            ref_char = "!"
        strm.write("<td><" + ref_char + "a href = #" + p + "><font size =1>" + \
                             p + " ( " + str(nbr) \
                             + " )</font></a></td> \n")
    strm.write('</tr></table></center>')

def gen_spec_ptrs ():
    """Utility for geneerating href for specs"""
    for item in specs.SPECIFIERS:
        ref = item.__name__
        str = ref[5:]
        sys.stdout.write("<a href =#" + ref + "> - " + str + " - </a>")

def gen_security_context_report():
    """Report listing all security contexts and resources with a given context"""
    prgm = get_current_program()
    fileid  = "Security-Context.html"
    fileStr = config.result_file(fileid)
    out = open(fileStr, "w")
    #print "Writing to " + fileStr
    top_of_file(out, "Security Context for " + capitalize_it(prgm.name))
    out.write("Go to <a href=Pattern-Instances.html> Pattern Instances </a> \n")
    out.write("<br>Go to <a href=PolicyHelp.html> Resources </a> \n")
    contexts = seq2set([x.get_sc() for x in resources_dict.values()])
    for c in contexts:
        if c not in [None, 'DEFAULT']:
            out.write("<a name = " + context2type(c) + "><h3><font color = ff00ff>" + str(c) + "</font></h3> \n")
            for r in [x for x in resources_dict.values() if the_type(x) != 'Spawn']:
                #excluding exec, scket links
                if r.get_sc() == c:
                    out.write("<br><a href='PolicyHelp.html#" + r.id + "'>" \
                              + r.name \
                              + "</a> \n")
            out.write("<hr> \n")

def gen_anomalies_page():
    """Report on executables that have been tagged as inactive"""
    problems = [preal for preal in pr.all_pattern_realizations.values() \
                if preal.pattern.name == 'Executable' \
                and preal.active == 0]
    prgm = get_current_program()
    fileid  = "Uncovered-Execs.html"
    fileStr = config.result_file(fileid)
    out = open(fileStr, "w")
    #print "Writing to " + fileStr
    top_of_file(out, "Uncovered Executions in " + capitalize_it(prgm.name))
    out.write("""Uncovered executions are listed below.  There are two possible causes for this.
    Either the user has indicated that they reject patterns or a transition conflicts with another transition with the same input types.""")
    out.write("<h3> No polgen_executable macro in .te file for following: </h3>")
    for p in problems:
        app = p.application
        file = p.file
        process = p.process
        out.write("<hr><br>" + obj2href(app) + ' executes the code in ' + obj2href(file) + "<br> \n" + \
                  app.get_sc() + "," + file.get_sc() + " -> " + process.get_sc() + " <br> \n")
        out.write('reason: ' + p.reason + " <br> \n")
        
    return 'done'

def gen_override_issues():
    #  problems are outside resources that got changed
    type1_problems = [r for r in resources_dict.values() if not \
                     r.sc_from == 'typegen' \
                     and r.original_context != r.security_context]
    # problems are outside resources that should have
    # changed via group inclusion or pattern participation
    type2_problems = [r for r in resources_dict.values() \
                      if the_type(r) == 'File' and  not \
                          r.sc_from == 'typegen' \
                          and Exists(r.type_contributors) \
                          and r.original_context == r.get_sc()]
    prgm = get_current_program()
    fileid  = "Override_Issues.html"
    fileStr = config.result_file(fileid)
    out = open(fileStr, "w")
    neg = ""
    if not PRGM.outsiders_mutable:
        neg = 'not'
    #print "Writing to " + fileStr
    top_of_file(out, "Override Issues for Prior Resources of " + capitalize_it(prgm.name))
    out.write('<br> Processing did ' + neg +
              ' allow changes to security context for external resources <br> \n')
    if Exists(type1_problems):
        out.write('<h3> External resources that changed </h3> \n')
        for p in type1_problems:
            out.write('<br>' + obj2href(p) + ': ' + p.original_context \
                      + " -> " + p.security_context + ' \n')
    if Exists(type2_problems):
        out.write('<h3> External resources that could have changed, but did not </h3> \n')
        for p in type2_problems:
            out.write('<br>' + obj2href(p) + ': ' + p.original_context \
                      + " -> " + str(p.type_contributors) + ' \n')
    return 'done'

def gen_interface_page ():
    """A page showing all interactions with outside world"""
    infrom = {}
    outto = {}
    execd = {}
    fileid  = "Interface.html"
    fileStr = config.result_file(fileid)
    out = open(fileStr, "w")
    print "Writing to " + fileStr
    prgm = get_current_program()
    top_of_file(out, "Interfaces of " + capitalize_it(prgm.name))
    processes = [x for x in resources_dict.values() if the_type(x) == 'Process']
    for p in processes:
              infrom[p] = [x for x in reads_from(p) if not x.is_local()] 
              outto[p] = [x for x in writes_to(p) if  not x.is_local()] 
              execd[p] = [x for x in execs(p) if not x.is_local()]
    all_in = seq2set([context2type(x.security_context) for x in flatten(infrom.values())])
    all_out = seq2set([context2type(x.security_context) for x in flatten(outto.values())])
    all_exec = seq2set([context2type(x.security_context) for x in flatten(execd.values())])
    out.write('<a href = #details> Details Below </a> \n')
    out.write('<h1> Types in Interface </h1> \n') 
    out.write('<h2>Types Read</h2> \n')
    for t in all_in:
        out.write('<br>  <a href=Security-Context.html#' + t + '>' + t + '</a>\n')
    out.write('<h2>Types Written</h2> \n')
    for t in all_out:
        out.write('<br><a href=Security-Context.html#' + t + '>' + t + '</a>\n')
    out.write('<h2>Types Spawned</h2> \n')
    for t in all_exec:
        out.write('<br><a href=Security-Context.html#' + t + '>' + t + '</a>\n')
    out.write('<hr><a name = "details"><h1> Details </h1> \n')
    for p in processes:
              out.write('<h2>' +  obj2href(p) + '</h2> \n')
              out.write('<h3>' + str(len(infrom[p])) + ' file reads </h3><br>')
              for inp in infrom[p]:
                  out.write(obj2href(inp) + ' (' + context2type(inp.security_context) +  ')<br>')
              out.write('<h3>' + str(len(outto[p])) + ' file writes </h3><br>')
              for inp in outto[p]:
                  out.write(obj2href(inp) + ' (' + context2type(inp.security_context) + ')<br>')
              out.write('<h3>' + str(len(execd[p])) + ' processes executed </h3><br>')
              for inp in execd[p]:
                  out.write(obj2href(inp) + ' (' + context2type(inp.security_context)+  ')<br>')

def gen_boundary_crossing_report ():
    """Report on pattern instances that cross module boundary"""
    prgm = get_current_program()
    items = prgm.external_connections
    fileid  = "boundary_crossings.html"
    fileStr = config.result_file(fileid)
    out = open(fileStr, "w")
    #print "Writing to " + fileStr
    top_of_file(out, "Pattern Instances that Cross Module Boundaries")
    for i in items:
        out.write('<br>' + i + ' \n')
    out.write('</html>')
    out.close()
              
def gen_diff_report ():
    """Report showing differences between processes, files, etc declared via different sources"""
    sources = get_current_program().sources
    if len(sources) > 1:
            prgm = get_current_program()
            fileid  = "diff.html"
            fileStr = config.result_file(fileid)
            out = open(fileStr, "w")
            #print "Writing to " + fileStr
            top_of_file(out, "Differences between Input from Multiple Sources")
            out.write("Showing the differences in resources input from different sources\n")
            for i in range(len(sources) -1):
                s1 = sources[i]
                all1 = s1.resources.values()
                p1 = [x for x in all1 if the_type(x) == 'Process']
                rest1 = setdiff(all1, p1)
                for j in  range(i + 1, len(sources)):
                    s2 = sources[j]
                    all2 = s2.resources.values()
                    p2 = [x for x in all2 if the_type(x) == 'Process']
                    rest2 = setdiff(all2, p2)
                    out.write('<h1>Comparing ' + s1.name + ' to ' + s2.name + '</h1> \n')
                    do_diff(out, s1, s2, setdiff(p1, p2), 'Processes')
                    do_diff(out, s2, s1, setdiff(p2, p1), 'Processes')
                    do_diff(out, s1, s2, setdiff(rest1, rest2), 'Others')
                    do_diff(out, s2, s1, setdiff(rest2, rest1), 'Others')
            out.write('</html>')
            out.close()
                    

                    
            
def do_diff (strm, s1, s2, diffitems, type):
    """utility for difference report"""
    if len(diffitems) > 0:
        strm.write('<h3>' + type + ' in ' + s1.name + ' but not in ' + s2.name + '</h3> \n')
        for item in diffitems:
            strm.write(obj2href(item) + '<br> \n')
        

def gen_cgi_page ():
    """Report showing situations where cgi scripts attempt to gain access beyond that requested by the web server"""
    cgis = [preal for preal in pr.all_pattern_realizations.values() if preal.pattern.name == 'CGI']
    prgm = get_current_program()
    fileid  = "CGI.html"
    fileStr = config.result_file(fileid)
    out = open(fileStr, "w")
    #print "Writing to " + fileStr
    top_of_file(out, "CGI scripts invoked in " + capitalize_it(prgm.name))
    out.write("CGI scripts are listed below. For each script we provide data on information flow for the script that goes beyond information flow of the server. \n")
    for cgi in cgis:
        serv = cgi.server
        script = cgi.script
        out.write("<hr><h3>" +  obj2href(script) + "</h3> \n")
        ins = setdiff([r.get_sc() for r in reads_from(script)], \
                       [r.get_sc() for r in reads_from(serv)])
       
        outs = setdiff([r.get_sc() for r in writes_to(script)], \
                       [r.get_sc() for r in writes_to(serv)])
        if Exists(ins):
           out.write("<h5>Additional types read from</h5> \n")
           for t in ins:
                out.write("--<a href= Security-Context.html#" + t + ">" \
                          + t + "</a><br> \n")
                out.write("<P>----- because " + str([obj2href(x)[:-1] for x in reads_from(script) \
                                                if x.security_context == t]) + " \n")
        if Exists(outs):
            out.write("<h5>Additional types written to</h5> \n")
            for t in ins:
                out.write("--<a href= Security-Context.html#" + t + ">" \
                          + t + "</a><br> \n")
                out.write("<P>----- because " + str([obj2href(x)[:-1] for x in writes_to(script) \
                                                if x.security_context == t]) + " \n")
                                                
        execs = setdiff([r.get_sc() for r in script.executing],
                        [r.get_sc() for r in serv.executing])
        if Exists(execs):
            out.write("<h5> Additional executed types </h5> \n")
            for e in execs:
                out.write("--<a href= Security-Context.html#" + e + ">" \
                          + e + "</a><br> \n")
                out.write("<P>----- because " + str([obj2href(x)[:-1] for x in script.executing \
                                                if x.security_context == e]) + " \n")
                    
                    
  
    return 'done'
    
