from util import *
import sys
import string

################# API ######################

def show (accum):
    """ to be used in interpreter to show results of pattern recognition.
    Takes a pattern instance tree as input """
    out = sys.stdout
    show_helper(out, accum, 0)

################ helpers #####################
    
def show_helper(out, accum, level):
    sps = spaces(level)
    if accum == None:
        out.write("found None")
    if accum.__class__.__name__ == "Aggr":
        out.write(sps + "Aggr for " + summarize(accum.elements) + "\n")
        return
    out.write(sps + "<" + who(accum) + " : " + accum.pattern_role)
    nbr_str = "; %d" % accum.nbr
    out.write(nbr_str + ">\n")
    collabs = accum.with
    if not empty(collabs):
        sps = spaces(level + 1)
        for coll in collabs.keys():
            out.write(sps + "With " + coll + ":\n")
            for c in collabs[coll]:
                show_helper(out, c, level + 2)

def who (item):
    if item == None:
        return "found None"
    ty = item.__class__.__name__
    if ty == "Aggr":
        return item.label
    if ty == "Player":
        return who(item.focus)
    else:
        return item.name

def summarize (lst):
    str = ""
    for item in lst:
        str = str + who(item) + " "
    return str
