/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef PXMCHEM_FRAGMENT_H
#define PXMCHEM_FRAGMENT_H

#include "libpolyxmass-globals.h"
#include "pxmchem-polymer.h"
#include "pxmchem-fragspec.h"
#include "pxmchem-fragopt.h"
#include "pxmchem-oligomer.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/******************* POLYMER FRAGMENTATION STUFF ********************/

gint
pxmchem_fragment_polymer (PxmPolymer *polymer,
			  GPtrArray *GPA,
			  PxmPolchemdef *polchemdef,			
			  PxmFragOpt *fragopt, 
			  PxmCalcOpt *calcopt);

gint
pxmchem_fragment_polymer_end_none (PxmPolymer *polymer,
				   GPtrArray *GPA,
				   PxmPolchemdef *polchemdef,			
				   PxmFragOpt *fragopt, 
				   PxmCalcOpt *calcopt);
  

gint
pxmchem_fragment_polymer_end_left (PxmPolymer *polymer,
				   GPtrArray *GPA,
				   PxmPolchemdef *polchemdef,			
				   PxmFragOpt *fragopt, 
				   PxmCalcOpt *calcopt);
  

gint
pxmchem_fragment_polymer_end_right (PxmPolymer *polymer,
				   GPtrArray *GPA,
				   PxmPolchemdef *polchemdef,			
				   PxmFragOpt *fragopt, 
				    PxmCalcOpt *calcopt);
  

gboolean
pxmchem_fragment_account_fragrule (PxmFragRule *fragrule,
				   gboolean check,
				   gint idx,
				   PxmEnd end,
				   PxmMasspair *masspair,
				   PxmPolymer *polymer,
				   GPtrArray *atom_refGPA);
  

  gboolean
  pxmchem_fragment_parse_name (gchar *name,
			       gchar **pattern,
			       gint *number);
  







































































#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* PXMCHEM_FRAGMENT_H */
