/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef PXMCHEM_MONOMER_H
#define PXMCHEM_MONOMER_H

#include "libpolyxmass-globals.h"
#include "pxmchem-atom.h"
#include "pxmchem-polchemdef.h"
#include "pxmchem-modif.h"
#include "libpolyxmass-reportopt.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  
  
  /* typedef's
   */
  typedef struct _PxmMonomer PxmMonomer;

  struct _PxmMonomer
  {
    gchar *name;
    gchar *code;
    gchar *formula;
    GPtrArray *propGPA;
  };




  /* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS, INITING FUNCTIONS ...
   */
  PxmMonomer *
  pxmchem_monomer_new (void);

  PxmMonomer *
  pxmchem_monomer_new_by_code (gchar *code, GPtrArray *GPA);

  PxmMonomer *
  pxmchem_monomer_dup (const PxmMonomer *monomer, PxmHowDup how_dup);

  PxmProp *
  pxmchem_monomer_prop_dup (const PxmProp *prop, PxmHowDup how_dup);
  
  gboolean
  pxmchem_monomer_set_name (PxmMonomer *monomer, gchar *name);

  gboolean
  pxmchem_monomer_set_code (PxmMonomer *monomer, gchar *code);

  gboolean
  pxmchem_monomer_set_formula (PxmMonomer *monomer, gchar *formula);


  /* COMPARISON FUNCTIONS
   */

  gint
  pxmchem_monomer_cmp (PxmMonomer *monomer1, PxmMonomer *monomer2, 
		       PxmHowCmp how_cmp);
  
  gint
  pxmchem_monomer_prop_cmp (PxmProp *prop1, PxmProp *prop2, PxmHowCmp how_cmp);
  

  /* INTEGRITY CHECKING FUNCTIONS
   */
  gboolean
  pxmchem_monomer_validate (PxmMonomer *monomer, gint codelen,
			    GPtrArray *atom_refGPA, gchar **valid);
  gboolean
  pxmchem_monomer_unique_by_name (PxmMonomer *monomer, 
				  GPtrArray *GPA);
  gboolean
  pxmchem_monomer_unique_by_code (PxmMonomer *monomer, 
				  GPtrArray *GPA);
  gboolean
  pxmchem_monomer_check_code_syntax (gchar *code, gint max_chars);

  gchar *
  pxmchem_monomer_find_code_in_delimited_codes_string (gchar *codes,
						       gchar *code,
						       gchar delim);


  /*  LOCATING FUNCTIONS
   */
  gint
  pxmchem_monomer_get_index_by_name (gchar *name, GPtrArray *GPA);
    
  gint
  pxmchem_monomer_get_index_top_by_name (gchar *name, GPtrArray *GPA);
  
  gint
  pxmchem_monomer_get_index_bottom_by_name (gchar *name, GPtrArray *GPA);

  gint
  pxmchem_monomer_get_index_by_code (gchar *code, GPtrArray *GPA);

  gint
  pxmchem_monomer_get_index_top_by_code (gchar *code, GPtrArray *GPA);

  gint
  pxmchem_monomer_get_index_bottom_by_code (gchar *code, GPtrArray *GPA);

  gint
  pxmchem_monomer_get_index_by_ptr (PxmMonomer *monomer, GPtrArray *GPA);
    
  gint
  pxmchem_monomer_get_index_by_completing_code (GPtrArray *GPA, 
						gchar *code,
						gint *idx);
  PxmMonomer *
  pxmchem_monomer_get_ptr_by_name (gchar *name, GPtrArray *GPA);

  PxmMonomer *
  pxmchem_monomer_get_ptr_by_code (gchar *code, GPtrArray *GPA);

  gint
  pxmchem_monomer_get_ptrs_by_completing_code (gchar *code,
					       GPtrArray *GPA,
					       GPtrArray *fillGPA);  
  gchar *
  pxmchem_monomer_get_modif_name (PxmMonomer *monomer);


  PxmProp *
  pxmchem_monomer_find_prop (PxmMonomer *monomer, 
			     PxmProp *prop,
			     gint how_cmp,
			     gint *idx);

  



  /* MASS/COMPOSITION ACCOUNTING FUNCTIONS
   */
  gboolean
  pxmchem_monomer_account_mass_by_name (gchar *name,
					GPtrArray *monomerGPA,
					GPtrArray *atom_refGPA,
					gint times,
					PxmMasspair *masspair);
  
  gboolean
  pxmchem_monomer_account_mass_by_code (gchar *code,
					GPtrArray *monomerGPA,
					GPtrArray *atom_refGPA,
					gint times,
					PxmMasspair *masspair);
  
  gboolean
  pxmchem_monomer_account_mass_for_modif (PxmMonomer *monomer,
					  GPtrArray *modifGPA,
					  GPtrArray *atom_refGPA,
					  gint times,
					  PxmMasspair *masspair);
  
  gboolean
  pxmchem_monomer_account_elemcompos_for_modif (PxmMonomer *monomer,
						GPtrArray *modifGPA,
						GPtrArray *atom_refGPA,
						gint times,
						GPtrArray *acGPA);
  
       

  /* CHEMICALLY-MODIFYING FUNCTIONS
   */
  gboolean
  pxmchem_monomer_modify (PxmMonomer *monomer, gchar *modif);
  
  gint
  pxmchem_monomer_un_modify (PxmMonomer *monomer, gchar *modif);
  


  /* UTILITY FUNCTIONS
   */
  gchar *
  pxmchem_monomer_make_delimited_codes_string (GPtrArray *GPA,
					       gchar delim);


  gchar *
  pxmchem_monomer_make_codes_string (GPtrArray *GPA);


  gchar *
  pxmchem_monomer_make_delimited_codes_string_by_idces (GPtrArray *GPA,
							gchar delim,
							gint start_idx, 
							gint end_idx);


  gchar *
  pxmchem_monomer_make_codes_string_by_idces (GPtrArray *GPA,
					      gint start_idx,
					      gint end_idx);


  gint
  pxmchem_monomer_extract_code_from_string (gchar *code, gint codelen,
					    gchar *seq,
					    gint *idx,
					    gchar *err);


  gint
  pxmchem_monomer_fill_array_from_string (GPtrArray *fillGPA,
					  gchar *seq, gint codelen,
					  GPtrArray *mnm_refGPA,
					  gboolean empty_first);


  gint
  pxmchem_monomer_fill_array_from_string_check_errors (GPtrArray *fillGPA,
						       GPtrArray *errorsGPA,
						       gchar *seq, 
						       gint codelen,
						       GPtrArray *mnm_refGPA,
						       gboolean empty_first);
  
  gint
  pxmchem_monomer_count_from_string (gchar* seq, gint codelen,
				     gboolean check_codes,
				     GPtrArray *mnm_refGPA);
  



  /* text-format TRANSACTIONS
   */
  gchar *
  pxmchem_monomer_format_xml_string_monomer (PxmMonomer *monomer, 
					     gchar *indent, gint offset);


  gchar *
  pxmchem_monomer_format_txt_string_monomer (PxmMonomer *monomer,
					     PxmReportOpt *reportopt);


  PxmMonomer *
  pxmchem_monomer_render_xml_node_monomer (xmlDocPtr xml_doc,
					   xmlNodePtr xml_node,
					   GPtrArray *mnm_refGPA,
					   gpointer user_data);


  gint
  pxmchem_monomer_render_xml_node_codes (xmlDocPtr xml_doc,
					 xmlNodePtr xml_node,
					 GPtrArray *mnm_refGPA,
					 gint codelen,
					 GPtrArray *fillGPA,
					 gpointer user_data);
  

  gchar *
  pxmchem_monomer_format_xml_string_mnm (PxmMonomer *monomer, 
					 gchar *indent, gint offset);


  PxmMonomer *
  pxmchem_monomer_render_xml_node_mnm (xmlDocPtr xml_doc,
				       xmlNodePtr xml_node,
				       gpointer user_data);






  /* FREE'ING FUNCTIONS
   */
  gboolean
  pxmchem_monomer_free (PxmMonomer *monomer);


  /* GPtrArray-RELATED FUNCTIONS
   */
  gint
  pxmchem_monomer_GPA_empty (GPtrArray *GPA);

  gint
  pxmchem_monomer_GPA_free (GPtrArray *GPA);

  gint
  pxmchem_monomer_GPA_prop_free (PxmProp *prop);







#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* PXMCHEM_MONOMER_H */

