/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef POLYXMASS_UI_NOTE_H
#define POLYXMASS_UI_NOTE_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"


enum
{
  NOTE_SINGLE,
  NOTE_RANGE
};


GtkWidget *
polyxmass_note_setup_wnd (GtkWidget *seqed_widget,
			  gint target,
			  gint start_idx,
			  gint end_idx,
			  gint index);


/* Note treeview setup and housekeeping functions.
 */
gint
polyxmass_note_wnd_setup_note_treeview (GtkWidget *widget,
					GPtrArray *GPA);

GtkTreeModel *
polyxmass_note_wnd_setup_note_treemodel (GPtrArray *GPA);

void
polyxmass_note_wnd_treeview_selection_changed (GtkTreeSelection 
							*selection,
							gpointer data);




void
polyxmass_note_wnd_value_add_button (GtkWidget *widget,
				  gpointer data);

void
polyxmass_note_wnd_value_apply_button (GtkWidget *widget,
				       gpointer data);

void
polyxmass_note_wnd_note_add_button (GtkWidget *widget,
				    gpointer data);

void
polyxmass_note_wnd_note_apply_button (GtkWidget *widget,
				    gpointer data);

void
polyxmass_note_wnd_selected_item_remove_single (GtkMenuItem *menuitem,
						gpointer data);

void
polyxmass_note_wnd_selected_item_remove_range (GtkMenuItem *menuitem,
					       gpointer data);

void
polyxmass_note_wnd_selected_item_propagate (GtkMenuItem *menuitem,
					    gpointer data);

void
polyxmass_note_wnd_reset_note_related_widgets (GtkWidget *widget);






/* Window house keeping functions.
 */
void 
polyxmass_note_wnd_get_active_valtype_radiobutton (GtkWidget *window,
						   GtkWidget **radiobutton,
						   PxmNoteValType *valtype);





/* WINDOW LIFE-CYCLE FUNCTIONS.
 */
void
polyxmass_note_wnd_really_close (GtkWidget *window);

gboolean
polyxmass_note_wnd_delete_event (GtkWidget *window, 
				 GdkEventAny *event, 
				 gpointer data);







#endif /* POLYXMASS_UI_NOTE_H */
