CREATE TABLE test_data (
    id integer,
    wkt text,
    wkb_xdr text,
    wkb_ndr text
);




INSERT INTO test_data VALUES (1, 'MULTIPOINT(1 2)', '00000000040000000100000000013FF00000000000004000000000000000', '0104000000010000000101000000000000000000F03F0000000000000040');
INSERT INTO test_data VALUES (-5, 'LINESTRING(1 2,3 4)', '0000000002000000023FF0000000000000400000000000000040080000000000004010000000000000', '010200000002000000000000000000F03F000000000000004000000000000008400000000000001040');
INSERT INTO test_data VALUES (-4, 'LINESTRING(1 2 3,4 5 6)', '0080000002000000023FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000', '010200008002000000000000000000F03F00000000000000400000000000000840000000000000104000000000000014400000000000001840');
INSERT INTO test_data VALUES (110, 'GEOMETRYCOLLECTION(LINESTRING(1 2,3 4))', '0000000007000000010000000002000000023FF0000000000000400000000000000040080000000000004010000000000000', '010700000001000000010200000002000000000000000000F03F000000000000004000000000000008400000000000001040');
INSERT INTO test_data VALUES (114, 'GEOMETRYCOLLECTION(LINESTRING(1 2,3 4),LINESTRING(5 6,7 8))', '0000000007000000020000000002000000023FF000000000000040000000000000004008000000000000401000000000000000000000020000000240140000000000004018000000000000401C0000000000004020000000000000', '010700000002000000010200000002000000000000000000F03F000000000000004000000000000008400000000000001040010200000002000000000000000000144000000000000018400000000000001C400000000000002040');
INSERT INTO test_data VALUES (14, 'MULTILINESTRING((1 2,3 4),(5 6,7 8))', '0000000005000000020000000002000000023FF000000000000040000000000000004008000000000000401000000000000000000000020000000240140000000000004018000000000000401C0000000000004020000000000000', '010500000002000000010200000002000000000000000000F03F000000000000004000000000000008400000000000001040010200000002000000000000000000144000000000000018400000000000001C400000000000002040');
INSERT INTO test_data VALUES (0, 'POINT(1 2)', '00000000013FF00000000000004000000000000000', '0101000000000000000000F03F0000000000000040');
INSERT INTO test_data VALUES (101, 'GEOMETRYCOLLECTION(POINT(1 2))', '00000000070000000100000000013FF00000000000004000000000000000', '0107000000010000000101000000000000000000F03F0000000000000040');
INSERT INTO test_data VALUES (-1, 'POINT(1 2 3)', '00800000013FF000000000000040000000000000004008000000000000', '0101000080000000000000F03F00000000000000400000000000000840');
INSERT INTO test_data VALUES (118, 'GEOMETRYCOLLECTION(LINESTRING(1 2 -1,3 4 -2,5 6 -3),LINESTRING(7 8 -1,9 10 -2,11 12 -3))', '0080000007000000020080000002000000033FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C00000000000000040140000000000004018000000000000C008000000000000008000000200000003401C0000000000004020000000000000BFF000000000000040220000000000004024000000000000C00000000000000040260000000000004028000000000000C008000000000000', '010700008002000000010200008003000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C00000000000001440000000000000184000000000000008C00102000080030000000000000000001C400000000000002040000000000000F0BF0000000000002240000000000000244000000000000000C00000000000002640000000000000284000000000000008C0');
INSERT INTO test_data VALUES (-8, 'LINESTRING(1 2,3 4,5 6,7 8,9 10)', '0000000002000000053FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000401C000000000000402000000000000040220000000000004024000000000000', '010200000005000000000000000000F03F000000000000004000000000000008400000000000001040000000000000144000000000000018400000000000001C40000000000000204000000000000022400000000000002440');
INSERT INTO test_data VALUES (115, 'GEOMETRYCOLLECTION(LINESTRING(1 2,3 4,5 6),LINESTRING(7 8,9 10))', '0000000007000000020000000002000000033FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000000000000200000002401C000000000000402000000000000040220000000000004024000000000000', '010700000002000000010200000003000000000000000000F03F000000000000004000000000000008400000000000001040000000000000144000000000000018400102000000020000000000000000001C40000000000000204000000000000022400000000000002440');
INSERT INTO test_data VALUES (117, 'GEOMETRYCOLLECTION(LINESTRING(5 6 -55,7 8 -22),LINESTRING(1 2 -1,3 4 -2))', '00800000070000000200800000020000000240140000000000004018000000000000C04B800000000000401C0000000000004020000000000000C0360000000000000080000002000000023FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C000000000000000', '010700008002000000010200008002000000000000000000144000000000000018400000000000804BC00000000000001C40000000000000204000000000000036C0010200008002000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C0');
INSERT INTO test_data VALUES (-7, 'LINESTRING(1 2,3 4,5 6,7 8)', '0000000002000000043FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000401C0000000000004020000000000000', '010200000004000000000000000000F03F000000000000004000000000000008400000000000001040000000000000144000000000000018400000000000001C400000000000002040');
INSERT INTO test_data VALUES (105, 'GEOMETRYCOLLECTION(POINT(1 2 -1))', '00800000070000000100800000013FF00000000000004000000000000000BFF0000000000000', '0107000080010000000101000080000000000000F03F0000000000000040000000000000F0BF');
INSERT INTO test_data VALUES (112, 'GEOMETRYCOLLECTION(LINESTRING(1 2 -1,3 4 -2))', '0080000007000000010080000002000000023FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C000000000000000', '010700008001000000010200008002000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C0');
INSERT INTO test_data VALUES (-6, 'LINESTRING(1 2,3 4,5 6)', '0000000002000000033FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000', '010200000003000000000000000000F03F00000000000000400000000000000840000000000000104000000000000014400000000000001840');
INSERT INTO test_data VALUES (111, 'GEOMETRYCOLLECTION(LINESTRING(1 2,3 4,5 6))', '0000000007000000010000000002000000033FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000', '010700000001000000010200000003000000000000000000F03F00000000000000400000000000000840000000000000104000000000000014400000000000001840');
INSERT INTO test_data VALUES (18, 'MULTILINESTRING((1 2 -1,3 4 -2,5 6 -3),(7 8 -1,9 10 -2,11 12 -3))', '0080000005000000020080000002000000033FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C00000000000000040140000000000004018000000000000C008000000000000008000000200000003401C0000000000004020000000000000BFF000000000000040220000000000004024000000000000C00000000000000040260000000000004028000000000000C008000000000000', '010500008002000000010200008003000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C00000000000001440000000000000184000000000000008C00102000080030000000000000000001C400000000000002040000000000000F0BF0000000000002240000000000000244000000000000000C00000000000002640000000000000284000000000000008C0');
INSERT INTO test_data VALUES (127, 'GEOMETRYCOLLECTION(POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)),POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1),(2 2,2 3,3 3,3 2,2 2)))', '0000000007000000020000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A0000000003000000020000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A000000054000000000000000400000000000000040000000000000004008000000000000400800000000000040080000000000004008000000000000400000000000000040000000000000004000000000000000', '0107000000020000000103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F0103000000020000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F050000000000000000000040000000000000004000000000000000400000000000000840000000000000084000000000000008400000000000000840000000000000004000000000000000400000000000000040');
INSERT INTO test_data VALUES (120, 'GEOMETRYCOLLECTION(POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)))', '0000000007000000010000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A', '0107000000010000000103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F');
INSERT INTO test_data VALUES (100, 'GEOMETRYCOLLECTION(POINT(1 2),POINT(3 4))', '00000000070000000200000000013FF00000000000004000000000000000000000000140080000000000004010000000000000', '0107000000020000000101000000000000000000F03F0000000000000040010100000000000000000008400000000000001040');
INSERT INTO test_data VALUES (122, 'GEOMETRYCOLLECTION(POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1),(2 2,2 3,3 3,3 2,2 2)))', '0000000007000000010000000003000000020000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A000000054000000000000000400000000000000040000000000000004008000000000000400800000000000040080000000000004008000000000000400000000000000040000000000000004000000000000000', '0107000000010000000103000000020000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F050000000000000000000040000000000000004000000000000000400000000000000840000000000000084000000000000008400000000000000840000000000000004000000000000000400000000000000040');
INSERT INTO test_data VALUES (27, 'MULTIPOLYGON(((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)),((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1),(2 2,2 3,3 3,3 2,2 2)))', '0000000006000000020000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A0000000003000000020000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A000000054000000000000000400000000000000040000000000000004008000000000000400800000000000040080000000000004008000000000000400000000000000040000000000000004000000000000000', '0106000000020000000103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F0103000000020000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F050000000000000000000040000000000000004000000000000000400000000000000840000000000000084000000000000008400000000000000840000000000000004000000000000000400000000000000040');
INSERT INTO test_data VALUES (106, 'GEOMETRYCOLLECTION(POINT(1 2 -2),POINT(3 4 -2),POINT(5 6 -3))', '00800000070000000300800000013FF00000000000004000000000000000C000000000000000008000000140080000000000004010000000000000C000000000000000008000000140140000000000004018000000000000C008000000000000', '0107000080030000000101000080000000000000F03F000000000000004000000000000000C001010000800000000000000840000000000000104000000000000000C001010000800000000000001440000000000000184000000000000008C0');
INSERT INTO test_data VALUES (11, 'MULTILINESTRING((1 2,3 4,5 6))', '0000000005000000010000000002000000033FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000', '010500000001000000010200000003000000000000000000F03F00000000000000400000000000000840000000000000104000000000000014400000000000001840');
INSERT INTO test_data VALUES (12, 'MULTILINESTRING((1 2 -1,3 4 -2))', '0080000005000000010080000002000000023FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C000000000000000', '010500008001000000010200008002000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C0');
INSERT INTO test_data VALUES (13, 'MULTILINESTRING((1 2 -1,3 4 -2,5 6 -3))', '0080000005000000010080000002000000033FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C00000000000000040140000000000004018000000000000C008000000000000', '010500008001000000010200008003000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C00000000000001440000000000000184000000000000008C0');
INSERT INTO test_data VALUES (102, 'GEOMETRYCOLLECTION(POINT(1 2),POINT(3 4),POINT(5 6))', '00000000070000000300000000013FF00000000000004000000000000000000000000140080000000000004010000000000000000000000140140000000000004018000000000000', '0107000000030000000101000000000000000000F03F0000000000000040010100000000000000000008400000000000001040010100000000000000000014400000000000001840');
INSERT INTO test_data VALUES (104, 'GEOMETRYCOLLECTION(POINT(1 2 -1),POINT(3 4 -2))', '00800000070000000200800000013FF00000000000004000000000000000BFF0000000000000008000000140080000000000004010000000000000C000000000000000', '0107000080020000000101000080000000000000F03F0000000000000040000000000000F0BF01010000800000000000000840000000000000104000000000000000C0');
INSERT INTO test_data VALUES (17, 'MULTILINESTRING((5 6 -55,7 8 -22),(1 2 -1,3 4 -2))', '00800000050000000200800000020000000240140000000000004018000000000000C04B800000000000401C0000000000004020000000000000C0360000000000000080000002000000023FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C000000000000000', '010500008002000000010200008002000000000000000000144000000000000018400000000000804BC00000000000001C40000000000000204000000000000036C0010200008002000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C0');
INSERT INTO test_data VALUES (113, 'GEOMETRYCOLLECTION(LINESTRING(1 2 -1,3 4 -2,5 6 -3))', '0080000007000000010080000002000000033FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C00000000000000040140000000000004018000000000000C008000000000000', '010700008001000000010200008003000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C00000000000001440000000000000184000000000000008C0');
INSERT INTO test_data VALUES (-3, 'LINESTRING(1 2 3,4 5 6,7 8 9)', '0080000002000000033FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000401C00000000000040200000000000004022000000000000', '010200008003000000000000000000F03F000000000000004000000000000008400000000000001040000000000000144000000000000018400000000000001C4000000000000020400000000000002240');
INSERT INTO test_data VALUES (21, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01)))', '0080000006000000010080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0106000080010000000103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF');
INSERT INTO test_data VALUES (116, 'GEOMETRYCOLLECTION(LINESTRING(1 2 -1,3 4 -2),LINESTRING(5 6 -55,7 8 -22))', '0080000007000000020080000002000000023FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C00000000000000000800000020000000240140000000000004018000000000000C04B800000000000401C0000000000004020000000000000C036000000000000', '010700008002000000010200008002000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C0010200008002000000000000000000144000000000000018400000000000804BC00000000000001C40000000000000204000000000000036C0');
INSERT INTO test_data VALUES (-2, 'LINESTRING(1 2 3,4 5 6,7 8 9,10 11 12)', '0080000002000000043FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000401C00000000000040200000000000004022000000000000402400000000000040260000000000004028000000000000', '010200008004000000000000000000F03F000000000000004000000000000008400000000000001040000000000000144000000000000018400000000000001C4000000000000020400000000000002240000000000000244000000000000026400000000000002840');
INSERT INTO test_data VALUES (2, 'MULTIPOINT(1 2,3 4)', '00000000040000000200000000013FF00000000000004000000000000000000000000140080000000000004010000000000000', '0104000000020000000101000000000000000000F03F0000000000000040010100000000000000000008400000000000001040');
INSERT INTO test_data VALUES (3, 'MULTIPOINT(1 2 3,4 5 6)', '00800000040000000200800000013FF0000000000000400000000000000040080000000000000080000001401000000000000040140000000000004018000000000000', '0104000080020000000101000080000000000000F03F000000000000004000000000000008400101000080000000000000104000000000000014400000000000001840');
INSERT INTO test_data VALUES (4, 'MULTIPOINT(1 2 3,4 5 6,7 8 9)', '00800000040000000300800000013FF00000000000004000000000000000400800000000000000800000014010000000000000401400000000000040180000000000000080000001401C00000000000040200000000000004022000000000000', '0104000080030000000101000080000000000000F03F00000000000000400000000000000840010100008000000000000010400000000000001440000000000000184001010000800000000000001C4000000000000020400000000000002240');
INSERT INTO test_data VALUES (5, 'MULTIPOINT(1 2,4 5,7 8)', '00000000040000000300000000013FF000000000000040000000000000000000000001401000000000000040140000000000000000000001401C0000000000004020000000000000', '0104000000030000000101000000000000000000F03F000000000000004001010000000000000000001040000000000000144001010000000000000000001C400000000000002040');
INSERT INTO test_data VALUES (10, 'MULTILINESTRING((1 2,3 4))', '0000000005000000010000000002000000023FF0000000000000400000000000000040080000000000004010000000000000', '010500000001000000010200000002000000000000000000F03F000000000000004000000000000008400000000000001040');
INSERT INTO test_data VALUES (121, 'GEOMETRYCOLLECTION(POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01)))', '0080000007000000010080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0107000080010000000103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF');
INSERT INTO test_data VALUES (123, 'GEOMETRYCOLLECTION(POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)))', '0080000007000000010080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0107000080010000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF');
INSERT INTO test_data VALUES (125, 'GEOMETRYCOLLECTION(POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)),POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)))', '0000000007000000020000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A0000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A', '0107000000020000000103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F0103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F');
INSERT INTO test_data VALUES (15, 'MULTILINESTRING((1 2,3 4,5 6),(7 8,9 10))', '0000000005000000020000000002000000033FF000000000000040000000000000004008000000000000401000000000000040140000000000004018000000000000000000000200000002401C000000000000402000000000000040220000000000004024000000000000', '010500000002000000010200000003000000000000000000F03F000000000000004000000000000008400000000000001040000000000000144000000000000018400102000000020000000000000000001C40000000000000204000000000000022400000000000002440');
INSERT INTO test_data VALUES (16, 'MULTILINESTRING((1 2 -1,3 4 -2),(5 6 -55,7 8 -22))', '0080000005000000020080000002000000023FF00000000000004000000000000000BFF000000000000040080000000000004010000000000000C00000000000000000800000020000000240140000000000004018000000000000C04B800000000000401C0000000000004020000000000000C036000000000000', '010500008002000000010200008002000000000000000000F03F0000000000000040000000000000F0BF0000000000000840000000000000104000000000000000C0010200008002000000000000000000144000000000000018400000000000804BC00000000000001C40000000000000204000000000000036C0');
INSERT INTO test_data VALUES (20, 'MULTIPOLYGON(((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)))', '0000000006000000010000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A', '0106000000010000000103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F');
INSERT INTO test_data VALUES (22, 'MULTIPOLYGON(((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1),(2 2,2 3,3 3,3 2,2 2)))', '0000000006000000010000000003000000020000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A000000054000000000000000400000000000000040000000000000004008000000000000400800000000000040080000000000004008000000000000400000000000000040000000000000004000000000000000', '0106000000010000000103000000020000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F050000000000000000000040000000000000004000000000000000400000000000000840000000000000084000000000000008400000000000000840000000000000004000000000000000400000000000000040');
INSERT INTO test_data VALUES (23, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)))', '0080000006000000010080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0106000080010000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF');
INSERT INTO test_data VALUES (24, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0)))', '0080000006000000010080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0106000080010000000103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000');
INSERT INTO test_data VALUES (25, 'MULTIPOLYGON(((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)),((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1)))', '0000000006000000020000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A0000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A', '0106000000020000000103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F0103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F');
INSERT INTO test_data VALUES (26, 'MULTIPOLYGON(((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01)))', '0080000006000000020080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A00000000000000000080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0106000080020000000103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F00000000000000000103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF');
INSERT INTO test_data VALUES (28, 'MULTIPOLYGON(((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)))', '0080000006000000020080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A00000000000000000080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0106000080020000000103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F00000000000000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF');
INSERT INTO test_data VALUES (29, 'MULTIPOLYGON(((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0)))', '0080000006000000020080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A00000000000000000080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0106000080020000000103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F00000000000000000103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000');
INSERT INTO test_data VALUES (30, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A0000000000000000', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F0000000000000000');
INSERT INTO test_data VALUES (31, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF');
INSERT INTO test_data VALUES (32, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0),(2 2 0,2 3 0,3 3 0,3 2 0,2 2 0)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000020000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A000000000000000000000005400000000000000040000000000000000000000000000000400000000000000040080000000000000000000000000000400800000000000040080000000000000000000000000000400800000000000040000000000000000000000000000000400000000000000040000000000000000000000000000000', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080020000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F000000000000000005000000000000000000004000000000000000400000000000000000000000000000004000000000000008400000000000000000000000000000084000000000000008400000000000000000000000000000084000000000000000400000000000000000000000000000004000000000000000400000000000000000');
INSERT INTO test_data VALUES (33, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF');
INSERT INTO test_data VALUES (34, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000');
INSERT INTO test_data VALUES (124, 'GEOMETRYCOLLECTION(POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0)))', '0080000007000000010080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0107000080010000000103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000');
INSERT INTO test_data VALUES (126, 'GEOMETRYCOLLECTION(POLYGON((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)),POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01)))', '0080000007000000020080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A00000000000000000080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0107000080020000000103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F00000000000000000103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF');
INSERT INTO test_data VALUES (128, 'GEOMETRYCOLLECTION(POLYGON((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)),POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)))', '0080000007000000020080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A00000000000000000080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0107000080020000000103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F00000000000000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF');
INSERT INTO test_data VALUES (129, 'GEOMETRYCOLLECTION(POLYGON((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)),POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0)))', '0080000007000000020080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A00000000000000000080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0107000080020000000103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F00000000000000000103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000');
INSERT INTO test_data VALUES (130, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000010000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A0000000000000000', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080010000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F0000000000000000');
INSERT INTO test_data VALUES (131, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF');
INSERT INTO test_data VALUES (132, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 0,0.2 10.3 0,10.4 10.5 0,10.7 0.6 0,0 0.1 0),(2 2 0,2 3 0,3 3 0,3 2 0,2 2 0)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000020000000500000000000000003FB999999999999A00000000000000003FC999999999999A402499999999999A00000000000000004024CCCCCCCCCCCD4025000000000000000000000000000040256666666666663FE3333333333333000000000000000000000000000000003FB999999999999A000000000000000000000005400000000000000040000000000000000000000000000000400000000000000040080000000000000000000000000000400800000000000040080000000000000000000000000000400800000000000040000000000000000000000000000000400000000000000040000000000000000000000000000000', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080020000000500000000000000000000009A9999999999B93F00000000000000009A9999999999C93F9A999999999924400000000000000000CDCCCCCCCCCC2440000000000000254000000000000000006666666666662540333333333333E33F000000000000000000000000000000009A9999999999B93F000000000000000005000000000000000000004000000000000000400000000000000000000000000000004000000000000008400000000000000000000000000000084000000000000008400000000000000000000000000000084000000000000000400000000000000000000000000000004000000000000000400000000000000000');
INSERT INTO test_data VALUES (133, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF');
INSERT INTO test_data VALUES (134, 'MULTIPOLYGON(((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01)),((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0)))', '0080000006000000020080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B0080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0106000080020000000103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF0103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000');
INSERT INTO test_data VALUES (-9, 'POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1))', '0000000003000000010000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A', '0103000000010000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F');
INSERT INTO test_data VALUES (-10, 'POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01))', '0080000003000000010000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B', '0103000080010000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF');
INSERT INTO test_data VALUES (-11, 'POLYGON((0 0.1,0.2 10.3,10.4 10.5,10.7 0.6,0 0.1),(2 2,2 3,3 3,3 2,2 2))', '0000000003000000020000000500000000000000003FB999999999999A3FC999999999999A402499999999999A4024CCCCCCCCCCCD402500000000000040256666666666663FE333333333333300000000000000003FB999999999999A000000054000000000000000400000000000000040000000000000004008000000000000400800000000000040080000000000004008000000000000400000000000000040000000000000004000000000000000', '0103000000020000000500000000000000000000009A9999999999B93F9A9999999999C93F9A99999999992440CDCCCCCCCCCC244000000000000025406666666666662540333333333333E33F00000000000000009A9999999999B93F050000000000000000000040000000000000004000000000000000400000000000000840000000000000084000000000000008400000000000000840000000000000004000000000000000400000000000000040');
INSERT INTO test_data VALUES (-12, 'POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01))', '0080000003000000020000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B', '0103000080020000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF');
INSERT INTO test_data VALUES (-13, 'POLYGON((0 0.1 -0.01,0.2 10.3 -0.02,10.4 10.5 -0.03,10.7 0.6 -0.04,0 0.1 -0.01),(2 2 -0.01,2 3 -0.01,3 3 -0.01,3 2 -0.01,2 2 -0.01),(4 2 0,4 3 0,5 3 0,5 2 0,4 2 0))', '0080000003000000030000000500000000000000003FB999999999999ABF847AE147AE147B3FC999999999999A402499999999999ABF947AE147AE147B4024CCCCCCCCCCCD4025000000000000BF9EB851EB851EB840256666666666663FE3333333333333BFA47AE147AE147B00000000000000003FB999999999999ABF847AE147AE147B0000000540000000000000004000000000000000BF847AE147AE147B40000000000000004008000000000000BF847AE147AE147B40080000000000004008000000000000BF847AE147AE147B40080000000000004000000000000000BF847AE147AE147B40000000000000004000000000000000BF847AE147AE147B00000005401000000000000040000000000000000000000000000000401000000000000040080000000000000000000000000000401400000000000040080000000000000000000000000000401400000000000040000000000000000000000000000000401000000000000040000000000000000000000000000000', '0103000080030000000500000000000000000000009A9999999999B93F7B14AE47E17A84BF9A9999999999C93F9A999999999924407B14AE47E17A94BFCDCCCCCCCCCC24400000000000002540B81E85EB51B89EBF6666666666662540333333333333E33F7B14AE47E17AA4BF00000000000000009A9999999999B93F7B14AE47E17A84BF05000000000000000000004000000000000000407B14AE47E17A84BF000000000000004000000000000008407B14AE47E17A84BF000000000000084000000000000008407B14AE47E17A84BF000000000000084000000000000000407B14AE47E17A84BF000000000000004000000000000000407B14AE47E17A84BF05000000000000000000104000000000000000400000000000000000000000000000104000000000000008400000000000000000000000000000144000000000000008400000000000000000000000000000144000000000000000400000000000000000000000000000104000000000000000400000000000000000');


SELECT id,wkt FROM test_data WHERE
       asEWKT(geometry(wkt)) != wkt  OR
       asEWKT(geometry(wkb_xdr)) != wkt OR 
       asEWKT(geometry(wkb_ndr)) != wkt OR
       asBinary(geometry(wkb_ndr)) != asBinary(geometry(wkb_xdr)) OR
       asBinary(geometry(wkt)) != asBinary(geometry(wkb_xdr));


SELECT extent(geometry(wkb_ndr)) from test_data;
SELECT extent3d(geometry(wkb_ndr)) from test_data;
SELECT mem_size(collect(force_2d(geometry(wkb_ndr)))) from test_data;
SELECT mem_size(collect(force_3dz(geometry(wkb_ndr)))) from test_data;
SELECT mem_size(collect(force_4d(force_2d(geometry(wkb_ndr))))) from test_data;
SELECT mem_size(collect(force_3dm(geometry(wkb_ndr)))) from test_data;
SELECT mem_size(collect(force_2d(force_4d(force_3dm(force_3dz(force_2d(geometry(wkb_ndr)))))))) from test_data;

DROP TABLE test_data;
