/*                               
Service_Dotlearn.cc
*/

#include "Service_Dotlearn.h"
#include "ClientHTTP.h"

extern Language *L;
extern Configuration *Conf;
extern Skin *skin;

bool Service_Dotlearn_Initialized = false;
TBuffer DotlearnURL2Get;

#define POSTMAN_HOST "correo.uv.es"
#define DOTLEARN_HOST "pizarra.uv.es"
#define DOTLEARN_URL_BEGIN  "/dotlrn/postman_redir?username={username}"
#define DOTLEARN_PORT 80
//In seconds
#define DOTLEARN_TIMEOUT 240

class HTMLPages: public HTMLBasic
  {
  private:
    //
  public:
    void PrintDotlearnDisplayPage (const char *lang, const char *user, const char *connid, UserOptions *uo, 
                                     StringList *SLHead, StringList *SLBody);
  };

//retrieve the url for the Service icon
const char *GetService_Dotlearn_ICO_URL (void)
  {
  return skin->getI(L_DOTLEARN);
  }

//Retrieve the ALT tag for the Service icon
const char *GetService_Dotlearn_ICO_ALT (void)
  {
  return L->get(L_DOTLEARN);
  }

//Retrieve the Service name
const char *GetService_Dotlearn_NAME (void)
  {
  return L->get(L_DOTLEARN);
  }

//Retrieve the Service Description
const char *GetService_Dotlearn_DESCRIPTION (void)
  {
  return L->get(L_DOTLEARN_DESCRIPTION);
  }

//Entry point to service init
bool DoService_Dotlearn_BEGIN (TProgData *pd)
  {
  TBuffer file2show;
  XString XS;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}
  if (Service_Dotlearn_Initialized == true) {return true;}
  LOG ("Initializating Service Dotlearn for user=%s", pd->username);
  Service_Dotlearn_Initialized = true;
  
  XS = XString (DOTLEARN_URL_BEGIN);
  XS.replace ("{username}", pd->username);
  XS.replace ("{password}", pd->password);  
  xstrncpy (DotlearnURL2Get, CMAXBUFFER, XS.cstr());  
    
  return true;
  }

//Entry point to service end
bool DoService_Dotlearn_END (TProgData *pd)
  {
  Service_Dotlearn_Initialized = false;  
  return true;
  }

//Entry point to execute a service command
bool DoService_Dotlearn_CMD (TProgData *pd)
  {
  ClientHTTP *CliHTTP;
  HTMLPages *html;
  int cmd, httpcode;
  StringList *SLHTTPHead, *SLHTTPBody;
  bool b;
  TBuffer header2send, url2back, abuff;

  html = (HTMLPages *)pd->html;
  cmd = pd->cmd;

  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {html->dumpFile (file2show, "TEXT/HTML"); return false;}

  SLHTTPHead = new StringList;    
  SLHTTPBody = new StringList;
  
  sprintf (header2send, "GET %s HTTP/1.0\n", DotlearnURL2Get);
  xsnprintf (url2back, CMAXBUFFER, "http://%s%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/", 
                                   POSTMAN_HOST, PATH_CGI, SERVICE_MAIN, pd->stlang, pd->username, pd->connid,
                                   pd->uo->getValidator(), pd->uo->getPageId(), pd->uo->getLastCmd(), pd->uo->getCurrentPosition());
  xstrncat(header2send, CMAXBUFFER, "Cookie: Backurl="); xstrncat (header2send, CMAXBUFFER, url2back);
  xstrncat(header2send, CMAXBUFFER, "\n");
  xstrncat (header2send, CMAXBUFFER, "Connection: close\n");
  xstrncat (header2send, CMAXBUFFER, "\n");
  
  switch (pd->cmd)    
    {    
    case (CMD_DOTLEARN_GOTO):  
      {       
      CliHTTP = new ClientHTTP (DOTLEARN_HOST, DOTLEARN_PORT, DOTLEARN_TIMEOUT);
      b = CliHTTP->doGetHTTPSL (header2send, SLHTTPHead, SLHTTPBody, &httpcode);
      if (b == false)
        {
        LOG ("ERROR: Service_Dotlearn: Get: %s", CliHTTP->getErrorMsg());
        sprintf (abuff, "http://%s/register/?return_url=/dotlrn/index", DOTLEARN_HOST);
        pd->html->Redirect (abuff);
        break;
        }
      delete CliHTTP;
      html->PrintDotlearnDisplayPage  (pd->stlang, pd->username, pd->connid, pd->uo, SLHTTPHead, SLHTTPBody);
      break;
      }
    default: 
      {    
      LOG ("ERROR: Service_Dotlearn: Here we can not go! cmd=%d, stcmd=--%s--, stsubcmd=--%s--", pd->cmd, pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }                                   
    }  

  delete SLHTTPHead;  
  delete SLHTTPBody;
  return false;  
  }  

void HTMLPages::PrintDotlearnDisplayPage (const char *lang, const char *user, const char *connid, UserOptions *uo, 
                                            StringList *SLHead, StringList *SLBody)
  { 
  for (int i = 0; i < SLHead->Count(); ++i) 
    {
    WRITE ("%s\n", SLHead->getString (i).cstr());
    }  
  WRITE ("\n");
  for (int i = 0; i < SLBody->Count(); ++i)
    {
    WRITE ("%s\n", SLBody->getString (i).cstr());
    }
  }
  
  
  
  

