/*
XString.cc
*/

#include "XString.h"
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

//============
//Constructors
//============
XString::XString( const char *Value )
{
        if ( Value == NULL )
                Value = "";

        GetBuffer( Length = strlen( Value ) );
        strcpy( Buffer, Value);
}

XString::XString( const XString &Value )
{
        GetBuffer( Length = Value.Length );
        strcpy( Buffer, Value.Buffer );
}

char
XString::charAt( UINT loc ) const
{
        return operator[]( loc );
}

int
XString::compareTo( const XString &s2 ) const
{
        return strcmp( Buffer, s2.Buffer );
}

const XString &
XString::concat( const XString &s2 )
{
        return (*this) += s2;
}

const XString &
XString::operator=( const XString &Rhs )
{
        if ( this == &Rhs )
                return *this;

        if ( Rhs.Length > Length )
        {
                delete [] Buffer;
                GetBuffer( Rhs.Length );
        }

        Length = Rhs.Length;
        strcpy( Buffer, Rhs.Buffer );

        return *this;
}

const XString &
XString::operator+=( const char aChar )
{
        if ( Length == BufferLen )
                Double();

        Buffer[ Length++ ] = aChar;
        Buffer[ Length ] = '\0';

        return *this;
}

const XString &
XString::operator+=( const XString &other )
{
        Length += other.Length;
        if ( Length > BufferLen )
        {
                char *temp = Buffer;
                GetBuffer( Length );
                strcpy( Buffer, temp );
                delete [] temp;
        }
        strcat( Buffer, other.Buffer );
        return *this;
}

        

int
XString::operator==( const XString &Rhs ) const
{
        return ( Length == Rhs.Length && strcmp( Buffer, Rhs.Buffer ) == 0 );
}

int
XString::operator!=( const XString &Rhs ) const
{
        return ( Length != Rhs.length() || strcmp( Buffer, Rhs.cstr() ) != 0 );
}

int
XString::operator<( const XString &Rhs ) const
{
        return strcmp( Buffer, Rhs.Buffer ) < 0;
}

int
XString::operator>( const XString &Rhs ) const
{
        return strcmp( Buffer, Rhs.Buffer ) > 0;
}

int
XString::operator<=( const XString &Rhs ) const
{
        return strcmp( Buffer, Rhs.Buffer ) <= 0;
}

int
XString::operator>=( const XString & Rhs ) const
{
        return strcmp( Buffer, Rhs.Buffer ) >= 0;
}

char &
XString::operator[]( UINT Index )
{
        verifyIndex( Index, "operator[]" );
        return Buffer[ Index ];
}

char
XString::operator[]( UINT Index ) const
{
        verifyIndex( Index, "operator[] const" );
        return Buffer[ Index ];
}


int
XString::endsWith( const XString &s2 ) const
{
        if ( Length < s2.Length )
                return 0;

        if (strcmp( &Buffer[ Length - s2.Length], s2.cstr() ) == 0) return 1;
        else return 0;
}

int
XString::equals( const XString &s2 ) const
{
        return ( Length == s2.Length && strcmp( Buffer,s2.Buffer ) == 0 );
}


int
XString::equalsIgnoreCase( const XString &s2 ) const
{
        if ( this == &s2 )
                return 1;
        else if ( Length != s2.Length )
                return 0;

        return strcmp(toLowerCase().cstr(), s2.toLowerCase().cstr()) == 0;
}

void
XString::Format( const char* fmt, ... )
{
        va_list iterator;
        va_start( iterator, fmt );


        va_end( iterator );
}

void
XString::replace( char findChar, char replaceChar )
{
        char* temp = strchr( Buffer, findChar );

        if ( temp != NULL )
                *temp = replaceChar;
}
   
void
XString::replace( const XString& match, const XString& replace )
{
        XString temp = Buffer, newString;

        int loc;
        while ( (loc = temp.indexOf( match )) != -1 )
        {
                newString += temp.substring( 0, loc );
                newString += replace;
                temp = temp.substring( loc + match.Length );
        } 

        newString += temp;                                 //get rest of string;

        *this = newString;
}

int
XString::indexOf( char temp ) const
{
        return indexOf( temp, 0 );
}

int
XString::indexOf( char ch, UINT fromIndex ) const
{
        if ( fromIndex >= Length )
                return -1;

        const char* temp = strchr( &Buffer[fromIndex], ch );
        if ( temp == NULL )
                return -1;

        return temp - Buffer;
}

int
XString::indexOf( const XString &s2 ) const
{
        return indexOf( s2, 0 );
}


int
XString::indexOf( const XString &s2, UINT fromIndex ) const
{
        if ( fromIndex >= Length )
                return -1;

        const char *theFind = strstr( &Buffer[ fromIndex ], s2.cstr() );

        if ( theFind == NULL )
                return -1;

        return theFind - Buffer; //pointer substraction
}



int
XString::lastIndexOf( char theChar ) const
{
        return lastIndexOf( theChar, Length - 1 );
}

int
XString::lastIndexOf( char ch, UINT fromIndex ) const
{
        if ( fromIndex >= Length )
                return -1;

        char tempchar = Buffer[fromIndex + 1];
        Buffer[fromIndex + 1] = '\0';
        char* temp = strrchr( Buffer, ch );
        Buffer[fromIndex + 1] = tempchar;

        if ( temp == NULL )
                return -1;

        return temp - Buffer;
}

int
XString::lastIndexOf( const XString &s2 ) const
{
        return lastIndexOf( s2, Length - s2.Length );
}

int
XString::lastIndexOf( const XString &s2, UINT fromIndex ) const
{
        //=============================
        //avoid check for empty strings
        //=============================
        if ( s2.Length == 0 || s2.Length - 1 > fromIndex || 
                fromIndex >= Length )
        return -1;

        //========================
        //matching first character
        //========================
        char temp = s2[ 0 ];

        for ( int i = fromIndex; i >= 0; i-- )
        {
                if ( Buffer[ i ] == temp &&
                        (*this).substring( i, i + s2.Length ).equals( s2 ) )
                        return i;
        }
        return -1;
}

int
XString::startsWith( const XString &s2 ) const
{
        if ( Length < s2.Length )
                return 0;

        return startsWith( s2, 0 );
}

int
XString::startsWith( const XString &s2, UINT offset ) const
{
        if ( offset > Length - s2.Length )
                return 0;

        if (strncmp( &Buffer[offset], s2.cstr(), s2.Length ) == 0) return 1;
        else return 0;
}

XString
XString::substring( UINT left ) const
{
        return substring( left, Length );
}

XString
XString::substring( UINT left, UINT right ) const
{
        if ( left > right )
        {
                int temp = right;
                right = left;
                left = temp;
        }

        if ( right > Length )
        {
                //cerr << "Index Out Of Bounds Exception w/ substring(" << left 
                //        << "," << right << "]:\n" << Buffer << endl;
                fprintf (stderr, "XString.cc: Index Out Of Bounds Exception w/ substring(%d,%d]:\n%s\n", left, right, Buffer);
                exit(1);
        }

        char temp = Buffer[ right ]; //save the replaced character
        Buffer[ right ] = '\0';   //nullify the the character

        XString outPut = ( Buffer + left ); //Pointer arithmetic

        Buffer[ right ] = temp;   //restore character

        return outPut;
}

XString
XString::toLowerCase( ) const
{
        XString temp = Buffer;

        for ( UINT i = 0; i < Length; i++ )
                temp.Buffer[ i ] = tolower( temp.Buffer[ i ] );

        return temp;
}

XString
XString::toUpperCase() const
{
        XString temp = Buffer;

        for ( UINT i = 0; i < Length; i++ )
                temp.Buffer[ i ] = toupper( temp.Buffer[ i ] );

        return temp;
}

XString
XString::trim() const
{
        XString temp = Buffer;
        UINT i,j;

        for ( i = 0; i < Length; i++ )
        {
                if ( !isspace(Buffer[i]) )
                        break;
        }

        for ( j = temp.Length - 1; j > i; j-- )
        {
                if ( !isspace(Buffer[j]) )
                        break;
        }

        return temp.substring( i, j + 1);
}

//CORTA EL XSTRING DEJANDOLO EN donde CARACTERES
// pe. Cut ("123456789, 4) -->  "1234"
void            
XString::Cut ( UINT donde) 
  {
  if (Length > donde)
    {
    Length = donde;
    Buffer[donde] = '\0';
    }
  }       

