/***************************************************************************
 *   Copyright (C) 2004 by Antonio Fasolato                                *
 *   Antonio.Fasolato@poste.it                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef AUTOTRACEFORMATS_H
#define AUTOTRACEFORMATS_H

#include <qobject.h>
#include <qstringlist.h>
#include <qprocess.h>

//! Class to read autotrace input and output formats
/** This class executes autotrace to gain informations about the formats it can use
 * \author Antonio Fasolato
 */
class AutotraceFormats : public QObject
{
Q_OBJECT
public:
	//! Standard QObject-like constructor
	/** The constructor, nothing fancy
 	 * \param parent The parent of the QObject
	 * \param name The name of the QObject
	 */
	AutotraceFormats(QObject *parent = 0, const char *name = 0);
	//!Returns the list of supported input formats
	/** This class returns the list of formats returned by <code>autotrace -list-input-formats</code>
	 * \return The supported formats
	 */
	QStringList inputFormats();
	//!Returns the list of supported output formats
	/** This class returns the list of formats returned by <code>autotrace -list-output-formats</code>
	 * \return The supported formats
	 */
	QStringList outputFormats();
	//! Function to test the execution of autotrace
	/** This functions returns <code>true</code> if the autotrace command could be run succesfully. If it returns
	 * <code>false</code> autotrace executable can not be found in the environment
	 * \return <code>true</code> if autotrace ran, <code>false</code> otherways
	 */
	bool OK();
	//! Tests if the class has ended its work
	/** This class tests if the autotrace processes ended, thus completing the formats listing
	 * \return <code>true</code> if the processes has ended, <code>false</code> otherways
	 */
	bool done();

private:
	//! The process to get input formats
	QProcess *inputProcess;
	//! The process to get output formats
	QProcess *outputProcess;
	//! The list of input formats
	QStringList input;
	//! The list of output formats
	QStringList output;
	//! <code>true</code> if autotrace could be run
	bool allOK;
	
private slots:
	//! Reads from inputProcess stderr
	/** Reads, when possible, the output of AutotraceFormats::inputProcess
	 */
	void inputRead();
	//! Reads from outputProcess stderr
	/** Reads, when possible, the output of AutotraceFormats::outputProcess
	 */
	void outputRead();
};

#endif
