  /*  powershell.h - powershell
   *  Copyright (C) 1999  Matt Spong <spong@glue.umd.edu>
   *  Based from zterm.c by Michael Zucci from the libzvt docs
   *
   *  A big, puffy lotsa-shells-in-one app. 
   *
   *  This program is free software; you can redistribute it and/or modify
   *  it under the terms of the GNU General Public License as published by
   *  the Free Software Foundation; either version 2 of the License, or
   *  (at your option) any later version.
   *
   *  This program is distributed in the hope that it will be useful,
   *  but WITHOUT ANY WARRANTY; without even the implied warranty of
   *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   *  GNU General Public License for more details.
   *
   *  You should have received a copy of the GNU General Public License
   *  along with this program; if not, write to the Free Software
   *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <pwd.h>
#include <stdlib.h>
#include <assert.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkprivate.h>
#include <gdk/gdkkeysyms.h>

#include <gnome.h>

#include <zvt/zvtterm.h>

#include "config.h"

char FONT[512];
int scrollbacklines;


#define POWERSHELL_VERSION "0.9"

enum palette_enum {
        PALETTE_LINUX,
        PALETTE_XTERM,
        PALETTE_RXVT,
        PALETTE_CUSTOM
};

/* structures */

typedef struct _shortcut_key
{
  gint key;
  gint modifiers;
} shortcut_key;

typedef struct _key_preferences
{
  shortcut_key cycle_forwards;
  shortcut_key cycle_backwards;

  shortcut_key move_forwards;
  shortcut_key move_backwards;

  shortcut_key specific_term[20];

  shortcut_key quit;
  shortcut_key close;
  shortcut_key rename;
  shortcut_key run;

} key_preferences;


typedef struct _appentry
{
  char * tab_title;
  char * command;
  char * menu_item_title;

  char * menu_title;
  char ** menu_entries;

  int run_on_startup;

  shortcut_key shortcut;

  GtkWidget * menubar;

} appentry;

typedef struct _preferences
{
  char http_handler[256], ftp_handler[256], 
    mail_handler[256], telnet_handler[256];

  int use_pixmap, transparent, shaded;
  char bg_pixmap[512];

  char font[512];

  int colors[16][16][16];

  int scrollbacklines;  
  int ask_ssh_password;

  int use_matching;
  GtkPositionType notebookpos;
  int hidemenubar;
  int hidestatusbar;
  int hidetabswhensingle;

  int scrollbarpos;
  int run_def_shell;

} preferences;

typedef struct _color_settings
{
  int initialized;
  gushort red[18], green[18], blue[18];
  gushort fg[3], bg[3];
  guint palette;
  gushort blink, bell, scroll_keystroke, scroll_output, del_bs_switch;
} color_settings;



/* globals */
extern char      **environ;       
extern char **env;
extern char **env_copy;
extern int winid_pos;
extern GtkWidget * window;
extern GtkWidget * notebook;
extern appentry * app_entries;
extern int num_apps;
extern int terms_open;
extern preferences Prefs;
extern color_settings ColorPrefs;
extern key_preferences keyprefs;
extern ZvtTerm * current_term;
extern GtkWidget * popup_file;
extern GnomeUIInfo * file_menu;
extern GtkItemFactoryEntry * menu_items;

extern GtkTargetEntry target_table[];

extern gushort linux_red[], linux_grn[], linux_blu[];
extern gushort xterm_red[], xterm_grn[], xterm_blu[];
extern gushort rxvt_red[], rxvt_grn[], rxvt_blu[];

extern int window_shown;

/* signal handlers */
void child_died_event (ZvtTerm *term);
void term_died_event (ZvtTerm *term);
void quit_proggie (GtkWidget * widget, GdkEvent * event, gpointer data);
void title_changed_event (ZvtTerm *term, VTTITLE_TYPE type, 
				 char *newtitle);
void set_hints (GtkWidget *widget);

gboolean term_key_event (GtkWidget * widget, GdkEventKey * event, gpointer user_data);

void NotebookHandler (GtkNotebook * notebook, GtkNotebookPage * page,
		      gint page_num, gpointer user_data);
void MenuHandler (GtkWidget * w, gchar * data);

gint term_click_event (GtkWidget * widget, GdkEventButton * event);

void  
drag_data_received  (GtkWidget *widget, GdkDragContext *context, 
                     gint x, gint y,
                     GtkSelectionData *selection_data, guint info,
                     guint time);

void windowmoved (GtkWidget * widget, gpointer data);

gint notebook_click_event (GtkWidget * widget, GdkEventButton * event,
			   gpointer user_data);

/* program functions */

GtkWidget * new_term (GtkWidget * notebook, gchar * command, gchar * args, gchar * title);
GtkWidget * new_term_x (GtkWidget * notebook, gchar * command, gchar * args, gchar * title,
			int w, int h);

void get_main_menu (GtkWidget * window, GtkWidget **menubar);
int InitMenus (GtkWidget * window);
int InitRCFile ();
int WriteRCFile ();
int DoPreferences();
void RenameTerm();
void RenameTerm2();
void AboutDialog();
void FileRun();
void FontSel();
void UpdateTerm(ZvtTerm * term);
void UpdateAllTerms();
ZvtTerm * get_nth_zvt (GtkNotebook * notebook, gint n);
void QuickMessage (gchar * message);
void drag_data_received (GtkWidget * widget, GdkDragContext * context,
			 gint x, gint y, GtkSelectionData * data,
			 guint info, guint time);
void RunArbitrary();
void set_color_scheme (ZvtTerm * term, color_settings cs);
void DisconnectTerm();
void InitIPC(int pid);

int CreatePrefsAppearance (GtkContainer * area);
int CreatePrefsColors (GtkContainer * area);
int CreatePrefsMenus (GtkContainer * area);
int CreatePrefsHandlers (GtkContainer * area);
int CreatePrefsShortcuts (GtkContainer * area);

int ApplyPrefsAppearance();
int ApplyPrefsColors();
int ApplyPrefsMenus();
int ApplyPrefsHandlers();
int ApplyPrefsShortcuts();

void property_changed (GtkWidget * w, gpointer user_data);
