/* Copyright (C) 1999-2000 Bernhard Trummer
 * Copyright (C) 2002      Benjamin Drieu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: inlinenode.h,v $
 * Revision 1.3  2003/03/06 14:54:21  benj
 * Update copyrigth where it is necessary
 *
 * Revision 1.2  2002/05/02 09:32:32  slash
 * Changes to make PresTiMeL compilable with g++ 3.0.
 * (Thanks to Benjamin Drieu)
 *
 * Revision 1.1.1.1  2001/01/30 18:36:40  slash
 * Initial release.
 *
 */

#ifndef INLINENODE_H
#define INLINENODE_H

#include <string>

#include "node.h"

//---------------------------------------------------------------------------
/**
 * This class provides a common interface and implementation for all
 * inline-nodes.
 */
class InlineNode : public Node {
  public:
    //-----------------------------------------------------------------------
    /**
     * Constructor.
     */
    InlineNode();

    //-----------------------------------------------------------------------
    /**
     * Destructor
     */
    virtual ~InlineNode();


    //-----------------------------------------------------------------------
    /**
     * This method initializes the node out of the given XML-node.
     *
     * @param node The XML-node.
     */
    virtual void read(xmlNodePtr node);
    
    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be HTML.
     *
     * @param parameter An integer-parameter which may have a special meaning
     *                  for each derivated class.
     */
    virtual void writeHTML(int parameter = 0) const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be LaTeX.
     */
    virtual void writeLaTeX() const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be XML.
     */       
    virtual void writeXML() const;


  protected:

    //-----------------------------------------------------------------------
    /**
     * The opening-markup for the HTML-output.
     */
    std::string html_open_;

    /**
     * The closing-markup for the HTML-output.
     */
    std::string html_close_;

    //-----------------------------------------------------------------------
    /**
     * The opening-markup for the LaTeX-output.
     */
    std::string latex_open_;

    /**
     * The closing-markup for the LaTeX-output.
     */
    std::string latex_close_;

    //-----------------------------------------------------------------------
    /**
     * The opening-markup for the XML-output.
     */
    std::string xml_open_;

    /**
     * The closing-markup for the XML-output.
     */
    std::string xml_close_;
};

#endif //INLINENODE_H
