/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: itemnode.cc,v $
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:22  slash
 * Initial release.
 *
 */

#include "main.h"
#include "itemnode.h"


//---------------------------------------------------------------------------
ItemNode::ItemNode(xmlNodePtr node, int closing_p) : InlineNode()
{
    html_close_  = (closing_p == 1 ? "</P></LI>\n" : "</LI>\n");
    latex_open_  = "\\item ";
    latex_close_ = "\n";
    xml_open_    = "<item>";
    xml_close_   = "</item>\n";

    read(node);
}

//---------------------------------------------------------------------------
ItemNode::~ItemNode()
{
}


//---------------------------------------------------------------------------
void ItemNode::writeHTML(int style) const
{
    switch (style) {
      case NORMAL:
        Output_ << "<LI class=\"itemnormal\"><P class=\"itemnormal\">"; break;
      case WEAK:
        Output_ << "<LI class=\"itemweak\"><P class=\"itemweak\">"; break;
    }

    for (unsigned int i=0;i<child_nodes_.size();i++) {
        child_nodes_[i]->writeHTML();
    }

    Output_ << html_close_;
}
