/* 
 * This is just a simple lib to get position data from gpsd. 
 * A part of this source is taken from xgpsspeed 
 */
#include <stdlib.h>
#include <string.h>
#include "fxgps.h"
#include "gpsd/nmea.h"
#include "gpsd/gpsd.h"
#include <unistd.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>


#define BUFSIZE          4096
#define DEFAULTPORT "2947"
char latd, lond;
double latitude, longitude;
int device_type;
int debug = 0;
static int gps_src = 0;

#if defined(ultrix) || defined(SOLARIS) 
extern double rint();
#endif

static void handle_input(int source);
int gps_initialize();
void update_gpsdata();
int my_serial_open();

#undef Offset

int errexit(char *s)
{
    perror(s);
    gps_src = -1;
	return(-1);
}


void update_gpsdata()
{
	handle_input(gps_src);
}


int gps_initialize()
{
    int        i;
    gps_src=my_serial_open();
    if (gps_src > 0)
    	for(i=0;i<10;i++)
    	{
      		handle_input(gps_src);
      		usleep(10000);
    	}
    return gps_src;
}


int gps_get_xy(float* lLat, float* lLong)
{
  handle_input(gps_src);
  *lLat=gNMEAdata.latitude;
  *lLong=gNMEAdata.longitude;
  return gNMEAdata.status;
}


static void handle_input(int source)
{
  static unsigned char buf[BUFSIZE];  /* that is more than a sentence */
  static int offset = 0;
  int count;
  int flags;

  ioctl(source, FIONREAD, &count);

  /* Make the port NON-BLOCKING so reads will not wait if no data */
  if ((flags = fcntl(source, F_GETFL)) < 0) return;
  if (fcntl(source, F_SETFL, flags | O_NDELAY) < 0) return;

  while (offset < BUFSIZE && count--) {
    if (read(source, buf + offset, 1) != 1)
      return;

    if (buf[offset] == '\n') {
      if (buf[offset - 1] == '\r')
	buf[offset - 1] = '\0';
      handle_message(buf);
      offset = 0;
      return;
    }
    offset++;
  }
}


int my_serial_open()
{
    char *temp;
    char *port = DEFAULTPORT;
    char *device_name="localhost";
    int one = 1;
    int ttyfd;

    temp = malloc(strlen(device_name) + 1);
    strcpy(temp, device_name);

    /* temp now holds the HOSTNAME portion and port the port number. */

    ttyfd = connectTCP(temp, port);

    free(temp);
    port = 0;
    setsockopt(ttyfd, SOL_SOCKET, SO_REUSEADDR, (char *) &one, sizeof(one));
    if ((ttyfd) && (gps_src >= 0)) {
      if (write(ttyfd, "r\n", 2) != 2)
        errexit("Can't write to socket\n");
    }  
    else
      return(-1);  

    return ttyfd;
}
