/*
    Debuggig.m

    Debugging overrides for the ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/*
 * The purpose of this entire file is to hold special overrides which
 * redefine the standard behavior so that it is easier to trace bugs
 * when debugging PM. That's also why the entire file's contents are
 * encloded in "#ifdef DEBUG" - unless debugging is enabled, this file
 * doesn't change anything in the resulting app.
 */

#ifdef DEBUG

#import <Foundation/NSException.h>

@implementation NSException (PMDebugging)

/**
 * Redefines the -raise method of NSException to immediatelly abort
 * the program. This makes it easier to spot in a debugger than as
 * if we were following the typical GNUstep-GUI path of things...
 */
- (void) raise
{
  NSString * name = [self name];
  NSString * reason = [self reason];

  abort ();
}

@end

#endif
