/*
    ProjectTemplateDescription.m

    Implementation of the ProjectTemplateDescription class for the
    ProjectManager app.

    Copyright (C) 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "ProjectTemplateDescription.h"

/**
 * A project template description.
 *
 * This object serves as a container for information about a certain
 * project template, which is then used in the ProjectCreator object
 * to feed information into it's project type/template outline view.
 */
@implementation ProjectTemplateDescription

- (void) dealloc
{
  TEST_RELEASE(name);
  TEST_RELEASE(description);
  TEST_RELEASE(icon);

  [super dealloc];
}

/**
 * Designated initializer.
 *
 * @param aName A name of a template.
 * @param aDescription A human-readable description of a template.
 */
- initWithTemplateName: (NSString *) aName
           description: (NSString *) aDescription
                  icon: (NSImage *) anIcon
                parent: (ProjectTypeDescription *) aParent
{
  if ((self = [self init]) != nil)
    {
      ASSIGN(name, aName);
      ASSIGN(description, aDescription);
      ASSIGN(icon, anIcon);

      parent = aParent;
    }

  return self;
}

/**
 * Returns the receiver's template's name.
 */
- (NSString *) name
{
  return name;
}

/**
 * Returns the receiver's template's human-readable description.
 */
- (NSString *) description
{
  return description;
}

/** 
 * Returns the receiver's icon representation.
 */
- (NSImage *) icon
{
  return icon;
}

/**
 * Returns the parent type description which contains this template
 * description.
 */
- (ProjectTypeDescription *) parent
{
  return parent;
}

@end
