/***************************************************************************
                          database_mysql.h  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATABASE_MYSQL_H
#define DATABASE_MYSQL_H


#include "prokyon.h"
#include "database.h"

#include <qmap.h>
#include <qpixmap.h>
#include <string>

#ifdef EMBEDDED
  #include "qsql_2.3.h"
   namespace qts = qt_embedded_library; 
#else
  #include <qsqldatabase.h>
  #include <qsqlquery.h>
#endif   // ifdef EMBEDDED

using namespace std;

class DataBase_MySQL : public DataBase {
  Q_OBJECT
 public: 
  DataBase_MySQL();
  
  void establishConnection(QString host, QString db, QString user, QString pass);
  
  QString createNewDatabase(QString host, QString db, QString user, QString pass, QString su, QString su_pass, QString clienthost);

  QList<ARTISTALBUM> *getAlbumBasis();
  QList<ARTISTALBUM> *getFavouritesBasis();
  QList<ARTISTALBUM> *getArtistAlbumBasis();
  QList<MEDIUM> *getMediumBasis();
  QList<PLAYLIST> *getPlaylistBasis();
  QList<PLAYLIST_TRACK> *getPlaylistTracksBasis(int playlistID);

#ifdef HAVE_MEXTRAS
  EXTRADATA_GUI *getExtraData(TRACK *);
#endif /* HAVE_MEXTRAS */

  void generatePlaylist(int, int, int, int, bool, bool, int);
  
  QMap<int, QMap<int, DELTAINFO*> > *getArtistDelta();

  QMap<int, QMap<int, int> > *getLocalDeltaBasis();
  QMap<int, QMap<QString, int> > *getLocalAlbumDeltaBasis();
  QMap<int, int> getLocalDelta(int id);
  QMap<QString, int> getLocalAlbumDelta(int id);
  QMap<QString,QString> getCustomQueries();
  
  void storeCustomQuery(QString, QString);
  void removeCustomQuery(QString);
  
  bool checkVersion();

  int appendTracks(QList<TRACK> *tracklist, int mediumtype, QString mediumlabel, QString mediumpath, unsigned mediumchecksum, bool createNewMedium, int mediumID);
  void updateTracks(QList<TRACK> *tracklist);
  void deleteTracks(QList<TRACK> *tracklist);

  int appendPlaylist(QString listname);
  void renamePlaylist(int id, QString newname);
  void deletePlaylist(int id);

  int getPlaylistIdByName(QString listname);
  int appendPlaylistTracks(QList<TRACK> *tracklist, int playlistID, int *position);
  void deletePlaylistTracks(QList<TRACK> *tracklist);
  void deletePlaylistTracks(QList<PLAYLIST_TRACK> *playlist_tracklist);
  void updatePlaylistTrack(int playlistID, int trackID, int new_pos);
  
  void deleteMedium(int id);
  void renameMedium(MEDIUM *medium);
  
  void modifyFavouriteArtist(int, bool);

  int getCountFromTable(QString);
  int getCountColumnDistinctFromTable(QString, QString);
  
  QList<TRACK> *getTracksByMedium(int id);
  
  QList<TRACK> *queryTracksByMedium(int id);
  QList<TRACK> *queryTracksByArtist(int id);
  QList<TRACK> *queryTracksByArtistAlbum(QString artist, QString album); 
  QList<TRACK> *queryTracksByAlbum(QString comment, QString album); 
  QList<TRACK> *queryTracksByPlaylist(int id);
  QList<TRACK> *queryTracksByPhrase(QString phrase, bool byFilename, bool byArtist, bool byTitle, bool byAlbum, bool byComment, bool byNotes);
  QList<TRACK> *queryTracksByWhere(QString phrase);
  
  QList<TRACK> *getLastQuery();
  
#ifdef HAVE_MEXTRAS
  EXTRA_STATUS checkMextras(TRACK *track);
  void updateMextras(EXTRADATA *data, TRACK *track);
  int addByteArrayMextras(QByteArray& pix);
  int addStringMextras(QString& st);
  void alterImageArtistsMextras(int image_id, int artists_id);
  void alterYearsActiveArtistsMextras(QString& years_active, int artists_id);
  void alterBiographyArtistsMextras(int biography_id, int artists_id);
  void alterLyricsTracksMextras(int lyrics_id, int tracks_id);
  void alterCoverTracksMextras(int, int, const QString, const QString);
  void alterAlbumReviewTracksMextras(int album_review_id, int album_id);
  void alterAlbumTracksTracksMextras(int album_tracks_id, int album_id);
  void deleteMextras(int ID);
  void zapExtraData();
  void zapExtraData(TRACK *track);

  const QByteArray getByteArrayMextras(int ID);
  const QString    getStringMextras(int ID);
#endif /* HAVE_MEXTRAS */

  QPixmap* getAlbumThumbnail(const QString, const QString);

  void disconnect();
  
  ~DataBase_MySQL();
  
 signals:
  void connected( bool );
  
 private:
#ifdef EMBEDDED
  qts::QSqlDatabase *db;
  void setError(int, qts::QSqlQuery&);
#else
  QSqlDatabase *db;
  void setError(int, QSqlQuery&);
#endif   // ifdef EMBEDDED
  bool	isConnected;
  int maxID_artists, maxID_tracks, maxID_mediums;
  int maxID_playlists, maxID_albums;

  string lastquery;
  
  bool checkIndex(const QString& table, const QString& indexname);
  bool checkExtra(const QString& table, const QString& column, const QString& extra);
  bool checkFieldExists(const QString& table, const QString& column);
  bool checkType(const QString& table, const QString& column, const QString& extra);
  int getMaxIDFromTable(QString);
  QList<ARTISTALBUM> *getArtistAlbumBasisByQuery(QString);  
  QList<TRACK> *applySelectTracksQuery(string sqlquery);
  QDateTime stringToDatetime(QString s);
  QCString dateTimeToString(QDateTime d);
  void loadCaches();
  void repairTableArtists();
  void fillTableAlbumsFromTableTracks(bool);
  
  QMap<int, QMap<int, DELTAINFO*> > *deltamap;
  QMap<int, int> baselistArtists;
  QMap<QString, int> artistToID;
  QMap<int, int> baselistAlbums;
  QMap<QString, int> albumToID;
  QMap<QString, QPixmap*> albumImageThumbnails;
  
  QPixmap *defaultAlbumThumbnail;
};

#endif
