/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  netpriv.h
 * Purpose: Miscellaeous definitions for the network library
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
 * Copyright (C) 1999 Pete Zaitcev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * Packet driver error return codes:
 */
#define	NO_ERROR	 0
#define	BAD_HANDLE	-1	/* invalid handle number 		*/
#define	NO_CLASS	-2	/* no interfaces of specified class	*/
#define	NO_TYPE		-3	/* no interfaces of specified type	*/
#define	NO_NUMBER	-4	/* no interfaces of specified number	*/
#define	BAD_TYPE	-5	/* bad packet type specified		*/
#define	NO_MULTICAST	-6	/* interface does not support multicast	*/
#define	CANT_TERMINATE	-7	/* packet driver cannot terminate	*/
#define	BAD_MODE	-8	/* invalid receiver mode		*/
#define	NO_SPACE	-9	/* insufficient space			*/
#define	TYPE_INUSE	-10	/* type not released			*/
#define	BAD_COMMAND	-11	/* command not implemented		*/
#define	CANT_SEND	-12	/* can't send packet (hardware error)	*/
#define CANT_SET	-13	/* can't change hardware address	*/
#define BAD_ADDRESS	-14	/* bad hardware address			*/
#define CANT_RESET	-15	/* couldn't reset interface		*/



/*
 **************************************************************************
 *
 * Usable Ethernet Protocol ID's:
 */
#define ETH_P_IP	0x0800		/* Internet Protocol packet	*/
#define ETH_P_X25	0x0805		/* CCITT X.25			*/
#define ETH_P_ARP	0x0806		/* Address Resolution packet	*/
#define ETH_P_RARP	0x8035		/* Reverse ARP			*/
#define ETH_P_ATALK	0x809B		/* Appletalk DDP		*/
#define ETH_P_IPX	0x8137		/* IPX over DIX			*/

/*
 **************************************************************************
 * Interface structures
 */

#define CHECKSUM_NONE 0
#define CHECKSUM_HW 1
#define CHECKSUM_UNNECESSARY 2

struct sk_buff {
	/*
	 * Managment fields.
	 */
	int allocn;
	/*
	 * Linux fields.
	 */
	struct device *dev;
	char *data;
	int len;
	int protocol;
	unsigned char ip_summed;
};

struct device {
	char			*name;

#if 0
	unsigned short          flags;  /* interface flags (a la BSD)   */
	unsigned                mtu;    /* interface MTU value          */
#endif

	unsigned long		trans_start;	/* Time (in jiffies) of last Tx	*/
	void                    *priv;  /* pointer to private data      */

	/* Low-level status flags. */
	volatile unsigned char	start;		/* start an operation	*/

	/*
	 * These two are just single-bit flags, but due to atomicity
	 * reasons they have to be inside a "unsigned long". However,
	 * they should be inside the SAME unsigned long instead of
	 * this wasteful use of memory..
	 */
	unsigned long		interrupt;	/* bitops.. */
	unsigned long		tbusy;		/* transmitter busy */

/* Interface address info. */
	unsigned char           broadcast[ETH_ALEN];
	unsigned char           dev_addr[ETH_ALEN];

/* Pointers to interface service routines.      */
	void	(*destructor)(struct device *dev);
	int	(*open)(struct device *dev);
	int	(*stop)(struct device *dev);
	int	(*hard_start_xmit) (struct sk_buff *skb, struct device *dev);
};


/*
 **************************************************************************
 * 
 * Global variables in the network library:
 *
 */
extern unsigned char myhwaddr[ETH_ALEN]; /* my own hardware address	*/
extern unsigned char bcasthw[ETH_ALEN];  /* broadcast hardware addr	*/
extern t_ipaddr      myipaddr;           /* my own IP address		*/
extern t_ipaddr      mynetmask;		 /* netmask for my network	*/
extern char         *net_module_name;	 /* initialized module's name	*/
extern t_ipaddr      servaddr;           /* server IP address		*/


/*
 **************************************************************************
 *
 * Public routines of the packet driver interface:
 */

/* Initialize packet driver */
extern void init_packet __P((void));

/* Setup receiver routine for a packet type */
extern unsigned char *reg_type __P((int typeval, int (* receive)()));

/* Write a packet to the network */
extern int write_packet __P((int bufsize, int typeval, unsigned char *addr));

/* Empty read buffer */
extern void empty_buf __P((void));

/* Registed Ethernet device */
extern void ether_setup __P((struct device *dev));

/*
 **************************************************************************
 *
 * External routines in the utility modules:
 */

/* Compute IP header checksum */
extern int ipchksum __P((unsigned char *buf, int len));

/*
 * Linux environment functions, provided by packet.c.
 */
extern struct sk_buff *dev_alloc_skb(unsigned int size);
extern void dev_kfree_skb(struct sk_buff *);
extern void skb_reserve(struct sk_buff *skb, unsigned int len);
extern unsigned char *skb_put(struct sk_buff *skb, unsigned int len);
extern void skb_trim(struct sk_buff *skb, unsigned len);
extern void eth_copy_and_sum(struct sk_buff *dest, unsigned char *src,
    int len, int base);
extern unsigned short eth_type_trans(struct sk_buff *skb, struct device *dev);
extern void netif_rx(struct sk_buff *skb);
