/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  romlib.h
 * Purpose: Header file for interfacing with the C library functions
 * Entries: none
 * Version: proll
 *
 **************************************************************************
 *
 * Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * Special characters from ASCII character set:
 */
#define CHR_BS		'\010'
#define CHR_LF		'\012'
#define CHR_FF		'\014'
#define CHR_CR		'\015'
#define CHR_STOP	'\023'
#define CHR_ESC		'\033'



/*
 **************************************************************************
 *
 * I/O functions:
 */
#define printf  printk
extern void printk(char *format, ...);
void xtoa(unsigned int x, char *buf, int len);


/*
 **************************************************************************
 *
 * Time related functions:
 */
extern void set_timeout __P((int ticks));	/* set timeout ticks	*/
extern int chk_timeout __P((void));		/* timeout reached	*/
extern unsigned long get_ticks __P((void));	/* get timer ticks	*/


/*
 **************************************************************************
 *
 * String and memory handling functions:
 *
 * We use bzero/bcmp/bcopy because memcpy/memcmp/memset conflict with
 * builtins in many gcc versions.
 */
#define memcpy(dst, src, len)	bcopy(src, dst, len)
#define memcmp(x1, x2, len)	bcmp(x1, x2, len)
#define memset(p, len, zero)	bzero(p, len)
extern void bcopy(void *b1, void *b2, int length);
extern int  bcmp(void *b1, void *b2, int length);
extern void bzero(void *b, int c);
/* gcc complains about "conflicting types for builtin function strlen". */
#define strlen(s)		ssize(s)
extern int ssize(char *s);


/*
 **************************************************************************
 *
 * Miscellaneous routines:
 */
extern void fatal __P((void));			/* terminate boot rom	*/
extern short int random __P((void));		/* get random value	*/
extern int highc __P((int mask, int size));	/* get highest order bit # */
