#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <linux/joystick.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "main.h"

// OmniJoy Logo
#include "pixmaps/oj.xpm"
#include "pixmaps/glade.xpm"

static char error[256];
static GtkWidget *error_window;
static int controller = 1;

void // When a window is destroyed...
on_window_destroy                       (GtkObject       *object,
                                        gpointer         user_data)
{
	gtk_main_quit(); // We quit.
}


void // When the OK button in config window is clicked...
on_OK_click                            (GtkButton       *button,
                                        gpointer         user_data)
{
	// Lookup the config window...
	GtkWidget *cfg_dialog = lookup_widget( GTK_WIDGET(button), "config_window" );

	gtk_widget_destroy( cfg_dialog ); // ... and destroy the config window
	save_conf();
}


void // When the Cancel button in config window is clicked...
on_cancel_click                        (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy( lookup_widget( GTK_WIDGET(button), "config_window" ) );
}


void // When the config window is shown...
on_config_show                         (GtkWidget       *widget,
                                        gpointer         user_data)
{
	// Lookup the pixmap, config window widgets.
	GtkWidget *pixmap = lookup_widget( GTK_WIDGET(widget), "oj_pixmap" );
	GtkWidget *window = lookup_widget( GTK_WIDGET(widget), "config_window" );
	GtkWidget *entry  = lookup_widget( GTK_WIDGET(widget), "entry_jsdev" );
	GtkLabel  *label_status = GTK_LABEL(lookup_widget( GTK_WIDGET(widget), "label_status" ) );
	char *buffer = malloc( 256 * sizeof( char ) );
	// Create a GDK Pixmap for use later
	GdkPixmap *gdk_pix = gdk_pixmap_create_from_xpm_d( window->window, NULL, NULL, oj_xpm );

	// Set entry's text
	gtk_entry_set_text( GTK_ENTRY( entry ), get_dev(1) );
	// set the image to the GDK pixmap created.
	gtk_image_set_from_pixmap( GTK_IMAGE( pixmap ), gdk_pix, NULL );

	if( use_epsxe == 1 ) gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(
	                        lookup_widget( GTK_WIDGET(widget), "check_epsxe" ) ), TRUE );
	if( use_keyboard == 1 ) gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(
	                          lookup_widget( GTK_WIDGET(widget), "check_keyboard" ) ), TRUE );

	snprintf( buffer, 256, "You are using OmniJoy v%d.%d.%d build %d", VER_MAJ, VER_MIN, VER_PAT, BUILD );
	gtk_label_set_text( label_status, buffer );
}

void
on_cfg_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	const char *joydev;
	char buf[256];
	int fd, but_no = -1, value;
	int key_no = 0;
	clock_t start;
	struct js_event js_ev;
	GdkEvent *gdk_ev;

	GtkWidget *entry_jsdev  = lookup_widget( GTK_WIDGET(button), "entry_jsdev" );
	GtkWidget *label_status = lookup_widget( GTK_WIDGET(button), "label_status" );

	joydev = gtk_entry_get_text( GTK_ENTRY(entry_jsdev) );

	fd = open( joydev, O_RDONLY | O_NONBLOCK );
	if( fd < 0 )
	{
		snprintf( error, 256, "Error opening device %s\nPlease double check yourself!",
		          joydev );
		error_window = create_error_window();
		gtk_widget_show( error_window );
		return;
	}

	gtk_label_set_text( GTK_LABEL(label_status), "Joystick opened. Waiting for input" );

	gtk_widget_set_sensitive( window, FALSE );
	start = clock();
	while( (clock() - start)/ CLOCKS_PER_SEC < 5  && but_no == -1 && key_no == 0 )
	{
		static int curr_sec = -1;
		if( read( fd, &js_ev, sizeof( struct js_event ) ) > 0 )
		{
			if( js_ev.type == JS_EVENT_BUTTON && js_ev.value == 1 )
				but_no = js_ev.number;
			else if( js_ev.type == JS_EVENT_AXIS )
			{
				if( js_ev.value > 32000 )
					but_no = js_ev.number + 128;
				else if( js_ev.value < -32000 )
					but_no = -(js_ev.number + 128);
			}
		}
		if( use_keyboard == 1 )
		{
			while( (gdk_ev = gdk_event_get()) != NULL && gdk_ev->type == GDK_KEY_PRESS )
			{
				key_no = gdk_ev->key.keyval + 256;
				break;
			}
		}

		if( curr_sec != (clock()-start)/CLOCKS_PER_SEC )
		{
			curr_sec = (clock()-start)/CLOCKS_PER_SEC;
			snprintf( buf, 256, "Joystick opened. Waiting for input (%d)", curr_sec );
			gtk_label_set_text( GTK_LABEL(label_status), buf );
		}
		gtk_main_iteration_do( FALSE );
	}
	close(fd);

	if( key_no ) value = key_no;
	else value = but_no;

	if( value != -1 )
	{
		if( but_no > -1 && but_no < 128 )
			snprintf( buf, 256, "Button %d was pressed", but_no );
		else if( but_no < -127 )
			snprintf( buf, 256, "Axis %d in negative direction", -(but_no) - 128 );
		else if( but_no > 127 && but_no <= 256 )
			snprintf( buf, 256, "Axis %d in positive direction", but_no - 128 );
		else if( key_no )
			snprintf( buf, 256, "Key %s was pressed.", XKeysymToString( key_no-256 ) );

		gtk_label_set_text( GTK_LABEL(label_status), buf );
		set_conf( controller, 0, 0, joydev );
		if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_sel" ) ) )
			set_conf( controller, OJ_BTN_SEL, value, NULL );
		else if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_start" ) ) )
			set_conf( controller, OJ_BTN_START, value, NULL );
		else if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_up" ) ) )
			set_conf( controller, OJ_BTN_UP, value, NULL );
		else if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_right" ) ) )
			set_conf( controller, OJ_BTN_RIGHT, value, NULL );
		else if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_down" ) ) )
			set_conf( controller, OJ_BTN_DOWN, value, NULL );
		else if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_left" ) ) )
			set_conf( controller, OJ_BTN_LEFT, value, NULL );
		else if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_l2" ) ) )
			set_conf( controller, OJ_BTN_L2, value, NULL );
		else if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_r2" ) ) )
			set_conf( controller, OJ_BTN_R2, value, NULL );
		else if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_l1" ) ) )
			set_conf( controller, OJ_BTN_L1, value, NULL );
		else if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_r1" ) ) )
			set_conf( controller, OJ_BTN_R1, value, NULL );
		else if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_tri" ) ) )
			set_conf( controller, OJ_BTN_TRI, value, NULL );
		else if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_cir" ) ) )
			set_conf( controller, OJ_BTN_CIRCLE, value, NULL );
		else if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_cro" ) ) )
			set_conf( controller, OJ_BTN_CROSS, value, NULL );
		else if( button == GTK_BUTTON(lookup_widget( GTK_WIDGET(button), "button_squ" ) ) )
			set_conf( controller, OJ_BTN_SQUARE, value, NULL );
	}
	else
		gtk_label_set_text( GTK_LABEL(label_status),
		                    "Joystick Closed. No input after 5 seconds." );
	gtk_widget_set_sensitive( window, TRUE );
}


void
on_about_show                          (GtkWidget       *widget,
                                        gpointer         user_data)
{
	// Lookup the image and dialog widgets
	GtkWidget *pix_widg = lookup_widget( GTK_WIDGET(widget), "glade_xpm" );
	GtkWidget *window = lookup_widget( GTK_WIDGET(widget), "about_dlg" );
	GdkPixmap *gdk_pix;
	GdkBitmap *mask;
	GtkStyle *style = gtk_widget_get_style( window ); // Get the style

	// Fill the GdkPixmap struct
	gdk_pix = gdk_pixmap_create_from_xpm_d( window->window, &mask,
	                                        &style->bg[GTK_STATE_NORMAL], glade_xpm );
	// Set the pixmap image
	gtk_image_set_from_pixmap( GTK_IMAGE(pix_widg), gdk_pix, mask );
}


void
on_error_show                          (GtkWidget       *widget,
                                        gpointer         user_data)
{
	// Lookup the label to be changed
	GtkWidget *error_label = lookup_widget( GTK_WIDGET(widget), "label_error" );
	// Set the main window to insensitive
	gtk_widget_set_sensitive( GTK_WIDGET(window), FALSE );
	// Set the label
	gtk_label_set_text( GTK_LABEL(error_label), error );
}


void
on_error_destroy                       (GtkObject       *object,
                                        gpointer         user_data)
{
	gtk_widget_set_sensitive( GTK_WIDGET(window), TRUE ); // Set the main window sensitive
}



void
on_controller_toggle                   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *entry_jsdev = lookup_widget( GTK_WIDGET(togglebutton), "entry_jsdev" );
	if( (gtk_toggle_button_get_active( togglebutton ) == TRUE) &&
	    (togglebutton == GTK_TOGGLE_BUTTON(
	                     lookup_widget( GTK_WIDGET(togglebutton), "controller2" ) )) )
	{
		set_conf( 1, 0, 0, gtk_entry_get_text( GTK_ENTRY( entry_jsdev ) ) );
		controller = 2;
		gtk_entry_set_text( GTK_ENTRY( entry_jsdev ), get_dev( controller ) );
	}
	else if( (gtk_toggle_button_get_active( togglebutton ) == TRUE ) &&
	         (togglebutton == GTK_TOGGLE_BUTTON(
                                  lookup_widget( GTK_WIDGET(togglebutton), "controller1" ) )) )
	{
		set_conf( 2, 0, 0, gtk_entry_get_text( GTK_ENTRY( entry_jsdev ) ) );
		controller = 1;
		gtk_entry_set_text( GTK_ENTRY( entry_jsdev ), get_dev( controller ) );
	}
}

void
on_option_toggled                      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkLabel *label_status = GTK_LABEL(lookup_widget( GTK_WIDGET(togglebutton), "label_status" ));
	if( GTK_WIDGET(togglebutton) == lookup_widget( GTK_WIDGET(togglebutton), "check_epsxe" ) )
	{
		if( gtk_toggle_button_get_active( togglebutton ) == TRUE )
		{
			use_epsxe = 1;
			gtk_label_set_text( label_status, "ePSXe support enabled. Do not use with other emus." );
		}
		else
		{
			use_epsxe = 0;
			gtk_label_set_text( label_status, "ePSXe support disabled." );
		}
	}
	else if( GTK_WIDGET(togglebutton) == lookup_widget( GTK_WIDGET(togglebutton), "check_keyboard" ) )
	{
		if( gtk_toggle_button_get_active( togglebutton ) == TRUE )
		{
			use_keyboard = 1;
			gtk_label_set_text( label_status, "Keyboard support enabled. Please RECONFIGURE." );
		}
		else
		{
			use_keyboard = 0;
			gtk_label_set_text( label_status, "Keyboard support disabled. Please RECONFIGURE." );
		}
	}
}
