/*
 * systemwatch_mac.cpp - Detect changes in the system state (Windows).
 * Copyright (C) 2005  James Chaldecott
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "systemwatch_win.h"

#include <qwidget.h>
#include <qt_windows.h>


// -----------------------------------------------------------------------------
// WinSystemWatchPrivate
// -----------------------------------------------------------------------------

class WinSystemWatch::WinSystemWatchPrivate : public QWidget
{
	Q_OBJECT

public:
	WinSystemWatchPrivate( ) : QWidget( 0 ) { }
    ~WinSystemWatchPrivate() { }

	bool winEvent( MSG * ); 

signals:
	void sleep();
	void wakeup();
};


bool WinSystemWatch::WinSystemWatchPrivate::winEvent( MSG *m ) 
{
	if(WM_POWERBROADCAST == m->message) {
		switch (m->wParam) {
			case PBT_APMSUSPEND:
				emit sleep();
				break;

			case PBT_APMRESUMESUSPEND:
				emit wakeup();
				break;

			case PBT_APMRESUMECRITICAL:
				// The system previously went into SUSPEND state (suddenly)
				// without sending PBT_APMSUSPEND.  Net connections are
				// probably invalid.  Not sure what to do about this.
				// Maybe:
				emit sleep();
				emit wakeup();
				break;

			case PBT_APMQUERYSUSPEND:
				// TODO: Check if file transfers are running, and don't go
				// to sleep if there are.  To refuse to suspend, we somehow
				// need to return BROADCAST_QUERY_DENY from the actual
				// windows procedure.
				break;

			case WM_QUERYENDSESSION:
				// TODO : If we allow the user to cancel suspend if they
				// are doing a file transfer, we should probably also give
				// them the chance to cancel a shutdown or log-off
				break; 
		} 
	}
	return QWidget::winEvent( m );
}


// -----------------------------------------------------------------------------
// WinSystemWatch
// -----------------------------------------------------------------------------

WinSystemWatch::WinSystemWatch() 
{
	d = new WinSystemWatchPrivate();
	connect(d,SIGNAL(sleep()),this,SIGNAL(sleep()));
	connect(d,SIGNAL(wakeup()),this,SIGNAL(wakeup()));
}

WinSystemWatch::~WinSystemWatch()
{
	disconnect(d,SIGNAL(sleep()),this,SIGNAL(sleep()));
	disconnect(d,SIGNAL(wakeup()),this,SIGNAL(wakeup()));
	delete d;
}

WinSystemWatch* WinSystemWatch::instance()
{
	if (!instance_) 
		instance_ = new WinSystemWatch();

	return instance_;
}

WinSystemWatch* WinSystemWatch::instance_ = 0;

// -----------------------------------------------------------------------------

#include "systemwatch_win.moc"

