/* $Log: sdot.c,v $
/* Revision 1.1.1.1  2000/02/04 22:52:32  evaleev
/* Started PSI 3 repository
/*
/* Revision 1.2  1999/08/17 19:04:18  evaleev
/* Changed the default symmetric orthogonalization to the canonical
/* orthogonalization. Now, if near-linear dependencies in the basis are found,
/* eigenvectors of the overlap matrix with eigenvalues less than 1E-6 will be
/* left out. This will lead to num_mo != num_so, i.e. SCF eigenvector is no
/* longer a square matrix. Had to rework some routines in libfile30, and add some.
/* The progrem prints out a warning if near-linear dependencies are found. TRANSQT
/* and a whole bunch of other codes has to be fixed to work with such basis sets.
/*
/* Revision 1.1.1.1  1999/04/12 16:59:27  evaleev
/* Added a version of CSCF that can work with CINTS.
/* -Ed
 */

static char *rcsid = "$Id: sdot.c,v 1.1.1.1 2000/02/04 22:52:32 evaleev Exp $";

#define EXTERN
#include "includes.h"
#include "common.h"

void sdot(a,b,n,value)
   double **a, **b, *value;
   int n;

   {
      register int i,j;
      double *ta, *tb, tval;

      tval = 0.0;
      for (i=0; i < n; i++) {
         ta = a[i];
         tb = b[i];
         for (j=0; j <= i; j++,ta++,tb++) {
            tval += (*ta) * (*tb);
            }
         }
      *value = tval;
      }

void vdot(a,b,n,value)
  double *a,*b,*value;
  int n;
{
  int i;
  double tval=0.0;

  for(i=0; i < n ; i++) tval += a[i]*b[i];

  *value = tval;
  }
