# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.
#
# $Id: subdir.mk,v 1.2 2000/12/27 07:57:47 muaddib Exp $
#
# To use this makefile fragment:
#  include $(top_srcdir)/mk/subdir.mk
#
# set SUBDIRS to a list of directories
# IMPORTANT:  SUBDIRS must be set before this file is included

.PHONY: $(addsuffix -subdirs, $(TARGETS))

ifeq ($(strip $(SUBDIRS)),)

$(addsuffix -subdirs, $(TARGETS)): %-subdirs:
	@echo Error: subdir.mk included before SUBDIRS set >&2 && exit 1

else

.PHONY: \
	$(addsuffix -depend, $(SUBDIRS)) \
	$(addsuffix -all, $(SUBDIRS)) \
	$(addsuffix -install, $(SUBDIRS)) \
	$(addsuffix -clean, $(SUBDIRS)) \
	$(addsuffix -distclean, $(SUBDIRS)) \
	$(addsuffix -doc, $(SUBDIRS)) \
	$(addsuffix -install-doc, $(SUBDIRS)) \
	$(addsuffix -fast-install, $(SUBDIRS)) \
	$(addsuffix -install-test, $(SUBDIRS))
	$(addsuffix -pile, $(SUBDIRS)) \
	$(addsuffix -clean-pile, $(SUBDIRS)) \
	$(addsuffix -install-pile, $(SUBDIRS))
	$(addsuffix -install-pile-check, $(SUBDIRS))

# targets for all-subdirs, install-subdirs, etc.
$(addsuffix -subdirs, $(TARGETS)): %-subdirs: $(addsuffix -%, $(SUBDIRS))

# the individual directory targets all depend on Makefile
# this means that a rule can be added to automatically generate the
# Makefile from a Makefile.PL where needed.
# For example, this is from src/lib/Makefile.in:
# perl/Makefile: perl/Makefile.PL
# 	( cd perl; $(perl) Makefile.PL ) || exit 1


# individual -depend target for each subdirectory
$(addsuffix -depend, $(SUBDIRS)):: %-depend: %/Makefile
	(cd $(@:-depend=); ${MAKE} depend) || exit 1

# individual -all target for each subdirectory, e.g. Error-all
$(addsuffix -all, $(SUBDIRS)):: %-all: %/Makefile
	(cd $(@:-all=); ${MAKE} all) || exit 1

# individual -pile target for each subdirectory, e.g. Error-all
$(addsuffix -pile, $(SUBDIRS)):: %-pile: %/Makefile
	(cd $(@:-pile=); ${MAKE} pile) || exit 1

# individual -install target for each subdirectory, e.g. Error-install
$(addsuffix -install, $(SUBDIRS)):: %-install: %/Makefile
	(cd $(@:-install=); ${MAKE} install) || exit 1

# individual -clean target for each subdirectory, e.g. Error-clean
$(addsuffix -clean, $(SUBDIRS)):: %-clean: %/Makefile
	-(cd $(@:-clean=); ${MAKE} clean) || exit 1

# individual -distclean target for each subdirectory, e.g. Error-distclean
# distclean usually depends on clean, clean sometimes removes the needed
# makefile, the dependency mechanism misses this because it has already been
# checked, so the if statement remakes it in case of emergency
$(addsuffix -distclean, $(SUBDIRS)):: %-distclean: %/Makefile
	@if test \! -f $?; then ${MAKE} $?; fi
	-(cd $(@:-distclean=); ${MAKE} distclean) || exit 1

# individual -doc target for each subdirectory, e.g. Error-all
$(addsuffix -doc, $(SUBDIRS)):: %-doc: %/Makefile
	(cd $(@:-doc=); ${MAKE} doc) || exit 1

# individual -clean-pile target for each subdirectory, e.g. Error-all
$(addsuffix -clean-pile, $(SUBDIRS)):: %-clean-pile: %/Makefile
	(cd $(@:-clean-pile=); ${MAKE} clean-pile) || exit 1

# individual -install-doc target for each subdirectory
$(addsuffix -install-doc, $(SUBDIRS)):: %-install-doc: %/Makefile
	(cd $(@:-install-doc=); ${MAKE} install-doc) || exit 1

# individual -fast-install target for each subdirectory
$(addsuffix -fast-install, $(SUBDIRS)):: %-fast-install: %/Makefile
	(cd $(@:-fast-install=); ${MAKE} fast-install) || exit 1

# individual -install-pile target for each subdirectory
$(addsuffix -install-pile, $(SUBDIRS)):: %-install-pile: %/Makefile
	(cd $(@:-install-pile=); ${MAKE} install-pile) || exit 1

# individual -install-check-pile target for each subdirectory, e.g. Error-check
$(addsuffix -install-check-pile, $(SUBDIRS)):: %-install-check-pile: %/Makefile
	(cd $(@:-install-check-pile=); ${MAKE} install-check-pile) || exit 1

# individual -install-test target for each subdirectory
$(addsuffix -install-test, $(SUBDIRS)):: %-install-test: %/Makefile
	(cd $(@:-install-test=); ${MAKE} install-test) || exit 1

endif

depend:: depend-subdirs

all:: all-subdirs

install:: install-subdirs

clean:: clean-subdirs

distclean:: distclean-subdirs

doc:: doc-subdirs

install-doc:: install-doc-subdirs

pile:: pile-subdirs

clean-pile:: clean-pile-subdirs

install-pile:: install-pile-subdirs

install-check-pile:: install-check-pile-subdirs

install-test:: install-test-subdirs

fast-install:: fast-install-subdirs

# See lib.mk for an explanation of DO_LIB_FIRST
ifneq ($(DO_LIB_FIRST),1)
# In case we are in a library:
all-lib: all-subdirs
install-lib: install-subdirs
clean-lib: clean-subdirs
distclean-lib: distclean-subdirs
endif

