#include "awCard.h"
#include "aw_lib.h"

using std::cout;

awCard::awCard(bool mode):debug(mode){
  try{
    if (aw_init()){
      throw AWCException("Unable to initialize driver. Exiting.");
    }
    else if (debug){
      cout << "Initialized driver." << endl;
    }

    number_of_boards = 0;

    if (aw_numberOfConnectedBoards(&number_of_boards)){
      throw AWCException("Unable to retrieve number of boards connected. Exiting.");
    }
    if (!number_of_boards){
      throw AWCException("No ActiveWire boards connected. Exiting.");
    }
	
    cout << static_cast<int>(number_of_boards) << " ActiveWire USB board connected." << endl;

    allOff_str = (unsigned char *)"0000000000000000";
    allOn_str = (unsigned char *)"1111111111111111";

    //set mode to output
    aw_binaryToDecimal(allOn_str, 2, decimal_array);

    if (aw_setDirectionsOfPinSets(0, decimal_array[0], decimal_array[1])){
	throw AWCException("Unable to set the IO pins' directions. Exiting.");
    }
    else if (debug){
      cout << "Set IO pins' directions." << endl;
    }
    
    write(allOff_str);

  }
  catch (AWCException &e){
    e.debug_print();
    throw;
  }
}

awCard::~awCard(){
  aw_close();
  cout << "Closed ActiveWire board(s)." << endl;
}

void awCard::write(unsigned char *s){
  try{
    aw_binaryToDecimal(s, 2, decimal_array);
    
    if (aw_writeData(0, decimal_array, 2)){
      throw AWCException("Unable to write data. Exiting.");
    }

  }
  catch (AWCException &e){
    e.debug_print();
    throw; //rethrow so the exception appears in python
  }
}

void awCard::allOn(){
  write(allOn_str);
}

void awCard::allOff(){
  write(allOff_str);
}

int main(){
  awCard a(true);  
}
